<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_Configurations_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request References element contains the specific instance set that should be returned in the Get operation. Only the Workday ID (GUID) should be specified for each instance to be returned.
 * @subpackage Structs
 */
class Asset_Book_Configurations_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Asset_Book_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to existing Asset Book Configuration to return data for in the response.
     * - maxOccurs: unbounded
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Asset_Book_Configuration_Reference;
    /**
     * Constructor method for Asset_Book_Configurations_Request_ReferencesType
     * @uses Asset_Book_Configurations_Request_ReferencesType::setAsset_Book_Configuration_Reference()
     * @param \StructType\Unique_IdentifierObjectType[] $asset_Book_Configuration_Reference
     */
    public function __construct(array $asset_Book_Configuration_Reference = array())
    {
        $this
            ->setAsset_Book_Configuration_Reference($asset_Book_Configuration_Reference);
    }
    /**
     * Get Asset_Book_Configuration_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getAsset_Book_Configuration_Reference()
    {
        return $this->Asset_Book_Configuration_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Configuration_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Configuration_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_Configuration_ReferenceForArrayConstraintsFromSetAsset_Book_Configuration_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_ReferencesTypeAsset_Book_Configuration_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_ReferencesTypeAsset_Book_Configuration_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_ReferencesTypeAsset_Book_Configuration_ReferenceItem) ? get_class($asset_Book_Configurations_Request_ReferencesTypeAsset_Book_Configuration_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_ReferencesTypeAsset_Book_Configuration_ReferenceItem), var_export($asset_Book_Configurations_Request_ReferencesTypeAsset_Book_Configuration_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Configuration_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Configuration_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $asset_Book_Configuration_Reference
     * @return \StructType\Asset_Book_Configurations_Request_ReferencesType
     */
    public function setAsset_Book_Configuration_Reference(array $asset_Book_Configuration_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_Configuration_ReferenceArrayErrorMessage = self::validateAsset_Book_Configuration_ReferenceForArrayConstraintsFromSetAsset_Book_Configuration_Reference($asset_Book_Configuration_Reference))) {
            throw new \InvalidArgumentException($asset_Book_Configuration_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Configuration_Reference = $asset_Book_Configuration_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Book_Configuration_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_ReferencesType
     */
    public function addToAsset_Book_Configuration_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Configuration_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Configuration_Reference[] = $item;
        return $this;
    }
}
