<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Adjust ServiceType
 * @subpackage Services
 */
class Adjust extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Adjust_Asset_Cost
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will allow you to adjust the cost of business assets, at acquisition date or post-acquisition, and submit them to the business process. The public Get Resources web service may be used to export current
     * business asset information and obtain references.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Adjust_Asset_Cost_RequestRootType $body
     * @return \StructType\Adjust_Asset_Cost_ResponseType|bool
     */
    public function Adjust_Asset_Cost(\StructType\Adjust_Asset_Cost_RequestRootType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Adjust_Asset_Cost($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Adjust_Asset_In_Service_Date
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is the submit request for asset in service date updates. You may adjust asset in service date using this operation. This web service will submit the transaction into the business process framework.The public Get Resources web
     * service may be used to export current business asset information and obtain references.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Adjust_Asset_In_Service_Date_RequestType $body
     * @return \StructType\Adjust_Asset_In_Service_Date_ResponseType|bool
     */
    public function Adjust_Asset_In_Service_Date(\StructType\Adjust_Asset_In_Service_Date_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Adjust_Asset_In_Service_Date($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Adjust_Asset_Cost_ResponseType|\StructType\Adjust_Asset_In_Service_Date_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
