<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Response_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Topmost element that captures a reference to a RFQ response document along with its content
 * @subpackage Structs
 */
class Request_for_Quote_Response_Response_DataType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Response
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Response_OutboundType[]
     */
    public $Request_for_Quote_Response;
    /**
     * Constructor method for Request_for_Quote_Response_Response_DataType
     * @uses Request_for_Quote_Response_Response_DataType::setRequest_for_Quote_Response()
     * @param \StructType\Request_for_Quote_Response_OutboundType[] $request_for_Quote_Response
     */
    public function __construct(array $request_for_Quote_Response = array())
    {
        $this
            ->setRequest_for_Quote_Response($request_for_Quote_Response);
    }
    /**
     * Get Request_for_Quote_Response value
     * @return \StructType\Request_for_Quote_Response_OutboundType[]|null
     */
    public function getRequest_for_Quote_Response()
    {
        return $this->Request_for_Quote_Response;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Response method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Response method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_ResponseForArrayConstraintsFromSetRequest_for_Quote_Response(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Response_Response_DataTypeRequest_for_Quote_ResponseItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Response_Response_DataTypeRequest_for_Quote_ResponseItem instanceof \StructType\Request_for_Quote_Response_OutboundType) {
                $invalidValues[] = is_object($request_for_Quote_Response_Response_DataTypeRequest_for_Quote_ResponseItem) ? get_class($request_for_Quote_Response_Response_DataTypeRequest_for_Quote_ResponseItem) : sprintf('%s(%s)', gettype($request_for_Quote_Response_Response_DataTypeRequest_for_Quote_ResponseItem), var_export($request_for_Quote_Response_Response_DataTypeRequest_for_Quote_ResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Response property can only contain items of type \StructType\Request_for_Quote_Response_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Response value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Response_OutboundType[] $request_for_Quote_Response
     * @return \StructType\Request_for_Quote_Response_Response_DataType
     */
    public function setRequest_for_Quote_Response(array $request_for_Quote_Response = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_ResponseArrayErrorMessage = self::validateRequest_for_Quote_ResponseForArrayConstraintsFromSetRequest_for_Quote_Response($request_for_Quote_Response))) {
            throw new \InvalidArgumentException($request_for_Quote_ResponseArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Response = $request_for_Quote_Response;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Response value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Response_OutboundType $item
     * @return \StructType\Request_for_Quote_Response_Response_DataType
     */
    public function addToRequest_for_Quote_Response(\StructType\Request_for_Quote_Response_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Response_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Response property can only contain items of type \StructType\Request_for_Quote_Response_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Response[] = $item;
        return $this;
    }
}
