<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Netting_Transaction_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Netting Transaction request criteria
 * @subpackage Structs
 */
class Netting_Transaction_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Customer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Customer
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Billable_EntityObjectType[]
     */
    public $Customer_Reference;
    /**
     * The Netting_Transaction_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Netting Transaction date on or after
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Netting_Transaction_Start_Date;
    /**
     * The Netting_Transaction_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Netting Transaction date on or before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Netting_Transaction_End_Date;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for Netting Transaction
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType[]
     */
    public $Currency_Reference;
    /**
     * The Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: Accounting date for Netting Transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accounting_Date;
    /**
     * The Netting_Transaction_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Netting Transaction Status. Examples of Document Status are Approved, Canceled, Denied, In Progress, Draft
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Netting_Transaction_Status_Reference;
    /**
     * The Netting_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Netting Rule for Netting Transaction
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Netting_RuleObjectType[]
     */
    public $Netting_Rule_Reference;
    /**
     * Constructor method for Netting_Transaction_Request_CriteriaType
     * @uses Netting_Transaction_Request_CriteriaType::setSupplier_Reference()
     * @uses Netting_Transaction_Request_CriteriaType::setCompany_Reference()
     * @uses Netting_Transaction_Request_CriteriaType::setCustomer_Reference()
     * @uses Netting_Transaction_Request_CriteriaType::setNetting_Transaction_Start_Date()
     * @uses Netting_Transaction_Request_CriteriaType::setNetting_Transaction_End_Date()
     * @uses Netting_Transaction_Request_CriteriaType::setCurrency_Reference()
     * @uses Netting_Transaction_Request_CriteriaType::setAccounting_Date()
     * @uses Netting_Transaction_Request_CriteriaType::setNetting_Transaction_Status_Reference()
     * @uses Netting_Transaction_Request_CriteriaType::setNetting_Rule_Reference()
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Billable_EntityObjectType[] $customer_Reference
     * @param string $netting_Transaction_Start_Date
     * @param string $netting_Transaction_End_Date
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     * @param string $accounting_Date
     * @param \StructType\Document_StatusObjectType[] $netting_Transaction_Status_Reference
     * @param \StructType\Netting_RuleObjectType[] $netting_Rule_Reference
     */
    public function __construct(array $supplier_Reference = array(), array $company_Reference = array(), array $customer_Reference = array(), $netting_Transaction_Start_Date = null, $netting_Transaction_End_Date = null, array $currency_Reference = array(), $accounting_Date = null, array $netting_Transaction_Status_Reference = array(), array $netting_Rule_Reference = array())
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setCompany_Reference($company_Reference)
            ->setCustomer_Reference($customer_Reference)
            ->setNetting_Transaction_Start_Date($netting_Transaction_Start_Date)
            ->setNetting_Transaction_End_Date($netting_Transaction_End_Date)
            ->setCurrency_Reference($currency_Reference)
            ->setAccounting_Date($accounting_Date)
            ->setNetting_Transaction_Status_Reference($netting_Transaction_Status_Reference)
            ->setNetting_Rule_Reference($netting_Rule_Reference);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($netting_Transaction_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($netting_Transaction_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($netting_Transaction_Request_CriteriaTypeSupplier_ReferenceItem), var_export($netting_Transaction_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($netting_Transaction_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($netting_Transaction_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($netting_Transaction_Request_CriteriaTypeCompany_ReferenceItem), var_export($netting_Transaction_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Customer_Reference value
     * @return \StructType\Billable_EntityObjectType[]|null
     */
    public function getCustomer_Reference()
    {
        return $this->Customer_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomer_ReferenceForArrayConstraintsFromSetCustomer_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_Request_CriteriaTypeCustomer_ReferenceItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_Request_CriteriaTypeCustomer_ReferenceItem instanceof \StructType\Billable_EntityObjectType) {
                $invalidValues[] = is_object($netting_Transaction_Request_CriteriaTypeCustomer_ReferenceItem) ? get_class($netting_Transaction_Request_CriteriaTypeCustomer_ReferenceItem) : sprintf('%s(%s)', gettype($netting_Transaction_Request_CriteriaTypeCustomer_ReferenceItem), var_export($netting_Transaction_Request_CriteriaTypeCustomer_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Customer_Reference property can only contain items of type \StructType\Billable_EntityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Customer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Billable_EntityObjectType[] $customer_Reference
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setCustomer_Reference(array $customer_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($customer_ReferenceArrayErrorMessage = self::validateCustomer_ReferenceForArrayConstraintsFromSetCustomer_Reference($customer_Reference))) {
            throw new \InvalidArgumentException($customer_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Customer_Reference = $customer_Reference;
        return $this;
    }
    /**
     * Add item to Customer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Billable_EntityObjectType $item
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function addToCustomer_Reference(\StructType\Billable_EntityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Billable_EntityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Customer_Reference property can only contain items of type \StructType\Billable_EntityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Customer_Reference[] = $item;
        return $this;
    }
    /**
     * Get Netting_Transaction_Start_Date value
     * @return string|null
     */
    public function getNetting_Transaction_Start_Date()
    {
        return $this->Netting_Transaction_Start_Date;
    }
    /**
     * Set Netting_Transaction_Start_Date value
     * @param string $netting_Transaction_Start_Date
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setNetting_Transaction_Start_Date($netting_Transaction_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($netting_Transaction_Start_Date) && !is_string($netting_Transaction_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netting_Transaction_Start_Date, true), gettype($netting_Transaction_Start_Date)), __LINE__);
        }
        $this->Netting_Transaction_Start_Date = $netting_Transaction_Start_Date;
        return $this;
    }
    /**
     * Get Netting_Transaction_End_Date value
     * @return string|null
     */
    public function getNetting_Transaction_End_Date()
    {
        return $this->Netting_Transaction_End_Date;
    }
    /**
     * Set Netting_Transaction_End_Date value
     * @param string $netting_Transaction_End_Date
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setNetting_Transaction_End_Date($netting_Transaction_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($netting_Transaction_End_Date) && !is_string($netting_Transaction_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netting_Transaction_End_Date, true), gettype($netting_Transaction_End_Date)), __LINE__);
        }
        $this->Netting_Transaction_End_Date = $netting_Transaction_End_Date;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType[]|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_Request_CriteriaTypeCurrency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_Request_CriteriaTypeCurrency_ReferenceItem instanceof \StructType\CurrencyObjectType) {
                $invalidValues[] = is_object($netting_Transaction_Request_CriteriaTypeCurrency_ReferenceItem) ? get_class($netting_Transaction_Request_CriteriaTypeCurrency_ReferenceItem) : sprintf('%s(%s)', gettype($netting_Transaction_Request_CriteriaTypeCurrency_ReferenceItem), var_export($netting_Transaction_Request_CriteriaTypeCurrency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setCurrency_Reference(array $currency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($currency_ReferenceArrayErrorMessage = self::validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference($currency_Reference))) {
            throw new \InvalidArgumentException($currency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Add item to Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType $item
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function addToCurrency_Reference(\StructType\CurrencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currency_Reference[] = $item;
        return $this;
    }
    /**
     * Get Accounting_Date value
     * @return string|null
     */
    public function getAccounting_Date()
    {
        return $this->Accounting_Date;
    }
    /**
     * Set Accounting_Date value
     * @param string $accounting_Date
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setAccounting_Date($accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Date) && !is_string($accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Date, true), gettype($accounting_Date)), __LINE__);
        }
        $this->Accounting_Date = $accounting_Date;
        return $this;
    }
    /**
     * Get Netting_Transaction_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getNetting_Transaction_Status_Reference()
    {
        return $this->Netting_Transaction_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setNetting_Transaction_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetting_Transaction_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNetting_Transaction_Status_ReferenceForArrayConstraintsFromSetNetting_Transaction_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_Request_CriteriaTypeNetting_Transaction_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_Request_CriteriaTypeNetting_Transaction_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($netting_Transaction_Request_CriteriaTypeNetting_Transaction_Status_ReferenceItem) ? get_class($netting_Transaction_Request_CriteriaTypeNetting_Transaction_Status_ReferenceItem) : sprintf('%s(%s)', gettype($netting_Transaction_Request_CriteriaTypeNetting_Transaction_Status_ReferenceItem), var_export($netting_Transaction_Request_CriteriaTypeNetting_Transaction_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Netting_Transaction_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Netting_Transaction_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $netting_Transaction_Status_Reference
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setNetting_Transaction_Status_Reference(array $netting_Transaction_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($netting_Transaction_Status_ReferenceArrayErrorMessage = self::validateNetting_Transaction_Status_ReferenceForArrayConstraintsFromSetNetting_Transaction_Status_Reference($netting_Transaction_Status_Reference))) {
            throw new \InvalidArgumentException($netting_Transaction_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Netting_Transaction_Status_Reference = $netting_Transaction_Status_Reference;
        return $this;
    }
    /**
     * Add item to Netting_Transaction_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function addToNetting_Transaction_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Netting_Transaction_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Netting_Transaction_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Netting_Rule_Reference value
     * @return \StructType\Netting_RuleObjectType[]|null
     */
    public function getNetting_Rule_Reference()
    {
        return $this->Netting_Rule_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setNetting_Rule_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetting_Rule_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNetting_Rule_ReferenceForArrayConstraintsFromSetNetting_Rule_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_Request_CriteriaTypeNetting_Rule_ReferenceItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_Request_CriteriaTypeNetting_Rule_ReferenceItem instanceof \StructType\Netting_RuleObjectType) {
                $invalidValues[] = is_object($netting_Transaction_Request_CriteriaTypeNetting_Rule_ReferenceItem) ? get_class($netting_Transaction_Request_CriteriaTypeNetting_Rule_ReferenceItem) : sprintf('%s(%s)', gettype($netting_Transaction_Request_CriteriaTypeNetting_Rule_ReferenceItem), var_export($netting_Transaction_Request_CriteriaTypeNetting_Rule_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Netting_Rule_Reference property can only contain items of type \StructType\Netting_RuleObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Netting_Rule_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Netting_RuleObjectType[] $netting_Rule_Reference
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function setNetting_Rule_Reference(array $netting_Rule_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($netting_Rule_ReferenceArrayErrorMessage = self::validateNetting_Rule_ReferenceForArrayConstraintsFromSetNetting_Rule_Reference($netting_Rule_Reference))) {
            throw new \InvalidArgumentException($netting_Rule_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Netting_Rule_Reference = $netting_Rule_Reference;
        return $this;
    }
    /**
     * Add item to Netting_Rule_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Netting_RuleObjectType $item
     * @return \StructType\Netting_Transaction_Request_CriteriaType
     */
    public function addToNetting_Rule_Reference(\StructType\Netting_RuleObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Netting_RuleObjectType) {
            throw new \InvalidArgumentException(sprintf('The Netting_Rule_Reference property can only contain items of type \StructType\Netting_RuleObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Netting_Rule_Reference[] = $item;
        return $this;
    }
}
