<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Amendment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Contract Amendment Data
 * @subpackage Structs
 */
class Supplier_Contract_Amendment_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_To_Amend_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference for Amendment
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_To_Amend_Reference;
    /**
     * The Supplier_Contract_Amendment_Information
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Information Data
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Amendment_InformationType
     */
    public $Supplier_Contract_Amendment_Information;
    /**
     * The Supplier_Contract_Amendment_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Contract_Amendment_Reference_ID;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference
     * - choice: Company_Reference | Company_Hierarchy_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Hierarchy Reference
     * - choice: Company_Reference | Company_Hierarchy_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\OrganizationObjectType
     */
    public $Company_Hierarchy_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Order_From_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Order-From Connection is a specific supplier site or division where you issue the purchase order. Accepted Order-From Connections must be active and belong to the Supplier. Contract Type must allow either Scheduled Purchase Order or
     * Manual Purchase Order to use Order-From Connection. In addition, Consignment, Multi-Supplier and Lease Contract Types are not compatible with Order-From Connection.
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_ConnectionObjectType
     */
    public $Order_From_Connection_Reference;
    /**
     * The Contract_Specialist_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contract Specialist Reference
     * @var \StructType\WorkerObjectType
     */
    public $Contract_Specialist_Reference;
    /**
     * The Contract_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Type Reference
     * @var \StructType\Supplier_Contract_TypeObjectType
     */
    public $Contract_Type_Reference;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Status of Supplier Contract or Supplier Contract Amendment. This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Buyer Reference
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Buyer_Reference;
    /**
     * The Contract_Name
     * Meta information extracted from the WSDL
     * - documentation: Contract Name
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Name;
    /**
     * The Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contract Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Reference;
    /**
     * The GPO_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Group Purchasing Organization (GPO) Contract Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GPO_Contract_Reference;
    /**
     * The Contract_Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Link to the external document captured on the contract.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Document_Link;
    /**
     * The Contract_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract Start Date
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Start_Date;
    /**
     * The Contract_Signed_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract Signed Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Signed_Date;
    /**
     * The Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date;
    /**
     * The Charge_Control_Data
     * Meta information extracted from the WSDL
     * - documentation: Header charge control amounts for amendment.
     * - minOccurs: 0
     * @var \StructType\Charge_Control_DataType
     */
    public $Charge_Control_Data;
    /**
     * The Total_Contract_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total Contract Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Contract_Amount;
    /**
     * The Original_Contract_Amount
     * Meta information extracted from the WSDL
     * - documentation: Original Supplier Contract Amount. This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Original_Contract_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Default_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Tax Code Reference
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Default_Tax_Code_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment terms for non-scheduled types of contracts.
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The payment type to use if it differs from the default payment type from the Supplier. This is used for all contract types except ones that have scheduled invoices
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Override_Payment_Type_Reference;
    /**
     * The Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: The credit card to default on POs. This can only be set if the default payment type or override payment type is set to Credit Card.
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Credit_Card_Reference;
    /**
     * The Renewal_Terms_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Renewal_Terms_DataType
     */
    public $Renewal_Terms_Data;
    /**
     * The Contract_Overview
     * Meta information extracted from the WSDL
     * - documentation: Contract Overview
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Overview;
    /**
     * The Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_CatalogObjectType[]
     */
    public $Catalog_Reference;
    /**
     * The Catalog_Discount_Percent
     * Meta information extracted from the WSDL
     * - documentation: Catalog Discount Percent
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Catalog_Discount_Percent;
    /**
     * The Supplier_Invoice_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public $Supplier_Invoice_Data;
    /**
     * The Purchase_Order_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public $Purchase_Order_Data;
    /**
     * The On_Hold
     * Meta information extracted from the WSDL
     * - documentation: On Hold Flag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $On_Hold;
    /**
     * The System_Generated
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Amendment was System Generated. Not enterable for Submit Suplier Contract Amendment web service. It is used only by Get Supplier Contract Amendment web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $System_Generated;
    /**
     * The Percent_to_Retain
     * Meta information extracted from the WSDL
     * - documentation: Percent to Retain for Supplier Contract. | Percent to Retain for Purchase Order. | Percent to Retain for Supplier Contract Amendment.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Percent_to_Retain;
    /**
     * The Estimated_Retention_Release_Date
     * Meta information extracted from the WSDL
     * - documentation: Estimated Retention Release Date for Supplier Contract Amendment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Estimated_Retention_Release_Date;
    /**
     * The Third_Party_Retention
     * Meta information extracted from the WSDL
     * - documentation: 3rd Party Retention for Supplier Contract Amendment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Third_Party_Retention;
    /**
     * The Retention_Memo
     * Meta information extracted from the WSDL
     * - documentation: Retention memo for Supplier Contract Amendment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Retention_Memo;
    /**
     * The Goods_Lines_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Goods Lines Replacement Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType[]
     */
    public $Goods_Lines_Replacement_Data;
    /**
     * The Service_Lines_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Service Lines Replacement Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType[]
     */
    public $Service_Lines_Replacement_Data;
    /**
     * The Multi_Supplier_Data
     * Meta information extracted from the WSDL
     * - documentation: Multi-Supplier Data
     * - minOccurs: 0
     * @var \StructType\Multi_Supplier_DataType
     */
    public $Multi_Supplier_Data;
    /**
     * The Multi_Participant_Data
     * Meta information extracted from the WSDL
     * - documentation: Multi-Participant Data
     * - minOccurs: 0
     * @var \StructType\Multi_Participant_DataType
     */
    public $Multi_Participant_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * Constructor method for Supplier_Contract_Amendment_DataType
     * @uses Supplier_Contract_Amendment_DataType::setSupplier_Contract_To_Amend_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setSupplier_Contract_Amendment_Information()
     * @uses Supplier_Contract_Amendment_DataType::setSupplier_Contract_Amendment_Reference_ID()
     * @uses Supplier_Contract_Amendment_DataType::setCompany_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setCompany_Hierarchy_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setSupplier_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setOrder_From_Connection_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Specialist_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Type_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setDocument_Status_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setBuyer_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Name()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setGPO_Contract_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Document_Link()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Start_Date()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Signed_Date()
     * @uses Supplier_Contract_Amendment_DataType::setContract_End_Date()
     * @uses Supplier_Contract_Amendment_DataType::setCharge_Control_Data()
     * @uses Supplier_Contract_Amendment_DataType::setTotal_Contract_Amount()
     * @uses Supplier_Contract_Amendment_DataType::setOriginal_Contract_Amount()
     * @uses Supplier_Contract_Amendment_DataType::setCurrency_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setDefault_Tax_Code_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setPayment_Terms_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setOverride_Payment_Type_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setCredit_Card_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setRenewal_Terms_Data()
     * @uses Supplier_Contract_Amendment_DataType::setContract_Overview()
     * @uses Supplier_Contract_Amendment_DataType::setCatalog_Reference()
     * @uses Supplier_Contract_Amendment_DataType::setCatalog_Discount_Percent()
     * @uses Supplier_Contract_Amendment_DataType::setSupplier_Invoice_Data()
     * @uses Supplier_Contract_Amendment_DataType::setPurchase_Order_Data()
     * @uses Supplier_Contract_Amendment_DataType::setOn_Hold()
     * @uses Supplier_Contract_Amendment_DataType::setSystem_Generated()
     * @uses Supplier_Contract_Amendment_DataType::setPercent_to_Retain()
     * @uses Supplier_Contract_Amendment_DataType::setEstimated_Retention_Release_Date()
     * @uses Supplier_Contract_Amendment_DataType::setThird_Party_Retention()
     * @uses Supplier_Contract_Amendment_DataType::setRetention_Memo()
     * @uses Supplier_Contract_Amendment_DataType::setGoods_Lines_Replacement_Data()
     * @uses Supplier_Contract_Amendment_DataType::setService_Lines_Replacement_Data()
     * @uses Supplier_Contract_Amendment_DataType::setMulti_Supplier_Data()
     * @uses Supplier_Contract_Amendment_DataType::setMulti_Participant_Data()
     * @uses Supplier_Contract_Amendment_DataType::setAttachment_Data()
     * @uses Supplier_Contract_Amendment_DataType::setSubmit()
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference
     * @param \StructType\Supplier_Contract_Amendment_InformationType $supplier_Contract_Amendment_Information
     * @param string $supplier_Contract_Amendment_Reference_ID
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\OrganizationObjectType $company_Hierarchy_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @param \StructType\WorkerObjectType $contract_Specialist_Reference
     * @param \StructType\Supplier_Contract_TypeObjectType $contract_Type_Reference
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @param string $contract_Name
     * @param string $contract_Reference
     * @param string $gPO_Contract_Reference
     * @param string $contract_Document_Link
     * @param string $contract_Start_Date
     * @param string $contract_Signed_Date
     * @param string $contract_End_Date
     * @param \StructType\Charge_Control_DataType $charge_Control_Data
     * @param float $total_Contract_Amount
     * @param float $original_Contract_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @param \StructType\Worker_Credit_CardObjectType $credit_Card_Reference
     * @param \StructType\Renewal_Terms_DataType $renewal_Terms_Data
     * @param string $contract_Overview
     * @param \StructType\Supplier_CatalogObjectType[] $catalog_Reference
     * @param float $catalog_Discount_Percent
     * @param \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType $supplier_Invoice_Data
     * @param \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType $purchase_Order_Data
     * @param bool $on_Hold
     * @param bool $system_Generated
     * @param float $percent_to_Retain
     * @param string $estimated_Retention_Release_Date
     * @param bool $third_Party_Retention
     * @param string $retention_Memo
     * @param \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType[] $goods_Lines_Replacement_Data
     * @param \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType[] $service_Lines_Replacement_Data
     * @param \StructType\Multi_Supplier_DataType $multi_Supplier_Data
     * @param \StructType\Multi_Participant_DataType $multi_Participant_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @param bool $submit
     */
    public function __construct(\StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference = null, \StructType\Supplier_Contract_Amendment_InformationType $supplier_Contract_Amendment_Information = null, $supplier_Contract_Amendment_Reference_ID = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\OrganizationObjectType $company_Hierarchy_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null, \StructType\WorkerObjectType $contract_Specialist_Reference = null, \StructType\Supplier_Contract_TypeObjectType $contract_Type_Reference = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\WorkerObjectType $buyer_Reference = null, $contract_Name = null, $contract_Reference = null, $gPO_Contract_Reference = null, $contract_Document_Link = null, $contract_Start_Date = null, $contract_Signed_Date = null, $contract_End_Date = null, \StructType\Charge_Control_DataType $charge_Control_Data = null, $total_Contract_Amount = null, $original_Contract_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null, \StructType\Worker_Credit_CardObjectType $credit_Card_Reference = null, \StructType\Renewal_Terms_DataType $renewal_Terms_Data = null, $contract_Overview = null, array $catalog_Reference = array(), $catalog_Discount_Percent = null, \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType $supplier_Invoice_Data = null, \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType $purchase_Order_Data = null, $on_Hold = null, $system_Generated = null, $percent_to_Retain = null, $estimated_Retention_Release_Date = null, $third_Party_Retention = null, $retention_Memo = null, array $goods_Lines_Replacement_Data = array(), array $service_Lines_Replacement_Data = array(), \StructType\Multi_Supplier_DataType $multi_Supplier_Data = null, \StructType\Multi_Participant_DataType $multi_Participant_Data = null, array $attachment_Data = array(), $submit = null)
    {
        $this
            ->setSupplier_Contract_To_Amend_Reference($supplier_Contract_To_Amend_Reference)
            ->setSupplier_Contract_Amendment_Information($supplier_Contract_Amendment_Information)
            ->setSupplier_Contract_Amendment_Reference_ID($supplier_Contract_Amendment_Reference_ID)
            ->setCompany_Reference($company_Reference)
            ->setCompany_Hierarchy_Reference($company_Hierarchy_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setOrder_From_Connection_Reference($order_From_Connection_Reference)
            ->setContract_Specialist_Reference($contract_Specialist_Reference)
            ->setContract_Type_Reference($contract_Type_Reference)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setBuyer_Reference($buyer_Reference)
            ->setContract_Name($contract_Name)
            ->setContract_Reference($contract_Reference)
            ->setGPO_Contract_Reference($gPO_Contract_Reference)
            ->setContract_Document_Link($contract_Document_Link)
            ->setContract_Start_Date($contract_Start_Date)
            ->setContract_Signed_Date($contract_Signed_Date)
            ->setContract_End_Date($contract_End_Date)
            ->setCharge_Control_Data($charge_Control_Data)
            ->setTotal_Contract_Amount($total_Contract_Amount)
            ->setOriginal_Contract_Amount($original_Contract_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setDefault_Tax_Code_Reference($default_Tax_Code_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setOverride_Payment_Type_Reference($override_Payment_Type_Reference)
            ->setCredit_Card_Reference($credit_Card_Reference)
            ->setRenewal_Terms_Data($renewal_Terms_Data)
            ->setContract_Overview($contract_Overview)
            ->setCatalog_Reference($catalog_Reference)
            ->setCatalog_Discount_Percent($catalog_Discount_Percent)
            ->setSupplier_Invoice_Data($supplier_Invoice_Data)
            ->setPurchase_Order_Data($purchase_Order_Data)
            ->setOn_Hold($on_Hold)
            ->setSystem_Generated($system_Generated)
            ->setPercent_to_Retain($percent_to_Retain)
            ->setEstimated_Retention_Release_Date($estimated_Retention_Release_Date)
            ->setThird_Party_Retention($third_Party_Retention)
            ->setRetention_Memo($retention_Memo)
            ->setGoods_Lines_Replacement_Data($goods_Lines_Replacement_Data)
            ->setService_Lines_Replacement_Data($service_Lines_Replacement_Data)
            ->setMulti_Supplier_Data($multi_Supplier_Data)
            ->setMulti_Participant_Data($multi_Participant_Data)
            ->setAttachment_Data($attachment_Data)
            ->setSubmit($submit);
    }
    /**
     * Get Supplier_Contract_To_Amend_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_To_Amend_Reference()
    {
        return $this->Supplier_Contract_To_Amend_Reference;
    }
    /**
     * Set Supplier_Contract_To_Amend_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Contract_To_Amend_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference = null)
    {
        $this->Supplier_Contract_To_Amend_Reference = $supplier_Contract_To_Amend_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Amendment_Information value
     * @return \StructType\Supplier_Contract_Amendment_InformationType|null
     */
    public function getSupplier_Contract_Amendment_Information()
    {
        return $this->Supplier_Contract_Amendment_Information;
    }
    /**
     * Set Supplier_Contract_Amendment_Information value
     * @param \StructType\Supplier_Contract_Amendment_InformationType $supplier_Contract_Amendment_Information
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Contract_Amendment_Information(\StructType\Supplier_Contract_Amendment_InformationType $supplier_Contract_Amendment_Information = null)
    {
        $this->Supplier_Contract_Amendment_Information = $supplier_Contract_Amendment_Information;
        return $this;
    }
    /**
     * Get Supplier_Contract_Amendment_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Contract_Amendment_Reference_ID()
    {
        return $this->Supplier_Contract_Amendment_Reference_ID;
    }
    /**
     * Set Supplier_Contract_Amendment_Reference_ID value
     * @param string $supplier_Contract_Amendment_Reference_ID
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Contract_Amendment_Reference_ID($supplier_Contract_Amendment_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Contract_Amendment_Reference_ID) && !is_string($supplier_Contract_Amendment_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Contract_Amendment_Reference_ID, true), gettype($supplier_Contract_Amendment_Reference_ID)), __LINE__);
        }
        $this->Supplier_Contract_Amendment_Reference_ID = $supplier_Contract_Amendment_Reference_ID;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return isset($this->Company_Reference) ? $this->Company_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCompany_ReferenceForChoiceConstraintsFromSetCompany_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Company_Hierarchy_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Company_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Company_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Company_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        // validation for constraint: choice(Company_Reference, Company_Hierarchy_Reference)
        if ('' !== ($company_ReferenceChoiceErrorMessage = self::validateCompany_ReferenceForChoiceConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($company_Reference) || (is_array($company_Reference) && empty($company_Reference))) {
            unset($this->Company_Reference);
        } else {
            $this->Company_Reference = $company_Reference;
        }
        return $this;
    }
    /**
     * Get Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getCompany_Hierarchy_Reference()
    {
        return isset($this->Company_Hierarchy_Reference) ? $this->Company_Hierarchy_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCompany_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Hierarchy_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCompany_Hierarchy_ReferenceForChoiceConstraintsFromSetCompany_Hierarchy_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Company_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Company_Hierarchy_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Company_Hierarchy_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Company_Hierarchy_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $company_Hierarchy_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setCompany_Hierarchy_Reference(\StructType\OrganizationObjectType $company_Hierarchy_Reference = null)
    {
        // validation for constraint: choice(Company_Reference, Company_Hierarchy_Reference)
        if ('' !== ($company_Hierarchy_ReferenceChoiceErrorMessage = self::validateCompany_Hierarchy_ReferenceForChoiceConstraintsFromSetCompany_Hierarchy_Reference($company_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($company_Hierarchy_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($company_Hierarchy_Reference) || (is_array($company_Hierarchy_Reference) && empty($company_Hierarchy_Reference))) {
            unset($this->Company_Hierarchy_Reference);
        } else {
            $this->Company_Hierarchy_Reference = $company_Hierarchy_Reference;
        }
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Order_From_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType|null
     */
    public function getOrder_From_Connection_Reference()
    {
        return $this->Order_From_Connection_Reference;
    }
    /**
     * Set Order_From_Connection_Reference value
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setOrder_From_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null)
    {
        $this->Order_From_Connection_Reference = $order_From_Connection_Reference;
        return $this;
    }
    /**
     * Get Contract_Specialist_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getContract_Specialist_Reference()
    {
        return $this->Contract_Specialist_Reference;
    }
    /**
     * Set Contract_Specialist_Reference value
     * @param \StructType\WorkerObjectType $contract_Specialist_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Specialist_Reference(\StructType\WorkerObjectType $contract_Specialist_Reference = null)
    {
        $this->Contract_Specialist_Reference = $contract_Specialist_Reference;
        return $this;
    }
    /**
     * Get Contract_Type_Reference value
     * @return \StructType\Supplier_Contract_TypeObjectType|null
     */
    public function getContract_Type_Reference()
    {
        return $this->Contract_Type_Reference;
    }
    /**
     * Set Contract_Type_Reference value
     * @param \StructType\Supplier_Contract_TypeObjectType $contract_Type_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Type_Reference(\StructType\Supplier_Contract_TypeObjectType $contract_Type_Reference = null)
    {
        $this->Contract_Type_Reference = $contract_Type_Reference;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * Set Buyer_Reference value
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setBuyer_Reference(\StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
    /**
     * Get Contract_Name value
     * @return string|null
     */
    public function getContract_Name()
    {
        return $this->Contract_Name;
    }
    /**
     * Set Contract_Name value
     * @param string $contract_Name
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Name($contract_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Name) && !is_string($contract_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Name, true), gettype($contract_Name)), __LINE__);
        }
        $this->Contract_Name = $contract_Name;
        return $this;
    }
    /**
     * Get Contract_Reference value
     * @return string|null
     */
    public function getContract_Reference()
    {
        return $this->Contract_Reference;
    }
    /**
     * Set Contract_Reference value
     * @param string $contract_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Reference($contract_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Reference) && !is_string($contract_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Reference, true), gettype($contract_Reference)), __LINE__);
        }
        $this->Contract_Reference = $contract_Reference;
        return $this;
    }
    /**
     * Get GPO_Contract_Reference value
     * @return string|null
     */
    public function getGPO_Contract_Reference()
    {
        return $this->GPO_Contract_Reference;
    }
    /**
     * Set GPO_Contract_Reference value
     * @param string $gPO_Contract_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setGPO_Contract_Reference($gPO_Contract_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($gPO_Contract_Reference) && !is_string($gPO_Contract_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gPO_Contract_Reference, true), gettype($gPO_Contract_Reference)), __LINE__);
        }
        $this->GPO_Contract_Reference = $gPO_Contract_Reference;
        return $this;
    }
    /**
     * Get Contract_Document_Link value
     * @return string|null
     */
    public function getContract_Document_Link()
    {
        return $this->Contract_Document_Link;
    }
    /**
     * Set Contract_Document_Link value
     * @param string $contract_Document_Link
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Document_Link($contract_Document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Document_Link) && !is_string($contract_Document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Document_Link, true), gettype($contract_Document_Link)), __LINE__);
        }
        $this->Contract_Document_Link = $contract_Document_Link;
        return $this;
    }
    /**
     * Get Contract_Start_Date value
     * @return string|null
     */
    public function getContract_Start_Date()
    {
        return $this->Contract_Start_Date;
    }
    /**
     * Set Contract_Start_Date value
     * @param string $contract_Start_Date
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Start_Date($contract_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date) && !is_string($contract_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date, true), gettype($contract_Start_Date)), __LINE__);
        }
        $this->Contract_Start_Date = $contract_Start_Date;
        return $this;
    }
    /**
     * Get Contract_Signed_Date value
     * @return string|null
     */
    public function getContract_Signed_Date()
    {
        return $this->Contract_Signed_Date;
    }
    /**
     * Set Contract_Signed_Date value
     * @param string $contract_Signed_Date
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Signed_Date($contract_Signed_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Signed_Date) && !is_string($contract_Signed_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Signed_Date, true), gettype($contract_Signed_Date)), __LINE__);
        }
        $this->Contract_Signed_Date = $contract_Signed_Date;
        return $this;
    }
    /**
     * Get Contract_End_Date value
     * @return string|null
     */
    public function getContract_End_Date()
    {
        return $this->Contract_End_Date;
    }
    /**
     * Set Contract_End_Date value
     * @param string $contract_End_Date
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_End_Date($contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date) && !is_string($contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date, true), gettype($contract_End_Date)), __LINE__);
        }
        $this->Contract_End_Date = $contract_End_Date;
        return $this;
    }
    /**
     * Get Charge_Control_Data value
     * @return \StructType\Charge_Control_DataType|null
     */
    public function getCharge_Control_Data()
    {
        return $this->Charge_Control_Data;
    }
    /**
     * Set Charge_Control_Data value
     * @param \StructType\Charge_Control_DataType $charge_Control_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setCharge_Control_Data(\StructType\Charge_Control_DataType $charge_Control_Data = null)
    {
        $this->Charge_Control_Data = $charge_Control_Data;
        return $this;
    }
    /**
     * Get Total_Contract_Amount value
     * @return float|null
     */
    public function getTotal_Contract_Amount()
    {
        return $this->Total_Contract_Amount;
    }
    /**
     * Set Total_Contract_Amount value
     * @param float $total_Contract_Amount
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setTotal_Contract_Amount($total_Contract_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Contract_Amount) && !(is_float($total_Contract_Amount) || is_numeric($total_Contract_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Contract_Amount, true), gettype($total_Contract_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Contract_Amount) && mb_strlen(mb_substr($total_Contract_Amount, false !== mb_strpos($total_Contract_Amount, '.') ? mb_strpos($total_Contract_Amount, '.') + 1 : mb_strlen($total_Contract_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Contract_Amount, true), mb_strlen(mb_substr($total_Contract_Amount, mb_strpos($total_Contract_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($total_Contract_Amount) && $total_Contract_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($total_Contract_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Contract_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Contract_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount))), __LINE__);
        }
        $this->Total_Contract_Amount = $total_Contract_Amount;
        return $this;
    }
    /**
     * Get Original_Contract_Amount value
     * @return float|null
     */
    public function getOriginal_Contract_Amount()
    {
        return $this->Original_Contract_Amount;
    }
    /**
     * Set Original_Contract_Amount value
     * @param float $original_Contract_Amount
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setOriginal_Contract_Amount($original_Contract_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($original_Contract_Amount) && !(is_float($original_Contract_Amount) || is_numeric($original_Contract_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($original_Contract_Amount, true), gettype($original_Contract_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($original_Contract_Amount) && mb_strlen(mb_substr($original_Contract_Amount, false !== mb_strpos($original_Contract_Amount, '.') ? mb_strpos($original_Contract_Amount, '.') + 1 : mb_strlen($original_Contract_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($original_Contract_Amount, true), mb_strlen(mb_substr($original_Contract_Amount, mb_strpos($original_Contract_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($original_Contract_Amount) && $original_Contract_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($original_Contract_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($original_Contract_Amount) && mb_strlen(preg_replace('/(\D)/', '', $original_Contract_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($original_Contract_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $original_Contract_Amount))), __LINE__);
        }
        $this->Original_Contract_Amount = $original_Contract_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Default_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getDefault_Tax_Code_Reference()
    {
        return $this->Default_Tax_Code_Reference;
    }
    /**
     * Set Default_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setDefault_Tax_Code_Reference(\StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null)
    {
        $this->Default_Tax_Code_Reference = $default_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getOverride_Payment_Type_Reference()
    {
        return $this->Override_Payment_Type_Reference;
    }
    /**
     * Set Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setOverride_Payment_Type_Reference(\StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null)
    {
        $this->Override_Payment_Type_Reference = $override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getCredit_Card_Reference()
    {
        return $this->Credit_Card_Reference;
    }
    /**
     * Set Credit_Card_Reference value
     * @param \StructType\Worker_Credit_CardObjectType $credit_Card_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setCredit_Card_Reference(\StructType\Worker_Credit_CardObjectType $credit_Card_Reference = null)
    {
        $this->Credit_Card_Reference = $credit_Card_Reference;
        return $this;
    }
    /**
     * Get Renewal_Terms_Data value
     * @return \StructType\Renewal_Terms_DataType|null
     */
    public function getRenewal_Terms_Data()
    {
        return $this->Renewal_Terms_Data;
    }
    /**
     * Set Renewal_Terms_Data value
     * @param \StructType\Renewal_Terms_DataType $renewal_Terms_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setRenewal_Terms_Data(\StructType\Renewal_Terms_DataType $renewal_Terms_Data = null)
    {
        $this->Renewal_Terms_Data = $renewal_Terms_Data;
        return $this;
    }
    /**
     * Get Contract_Overview value
     * @return string|null
     */
    public function getContract_Overview()
    {
        return $this->Contract_Overview;
    }
    /**
     * Set Contract_Overview value
     * @param string $contract_Overview
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setContract_Overview($contract_Overview = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Overview) && !is_string($contract_Overview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Overview, true), gettype($contract_Overview)), __LINE__);
        }
        $this->Contract_Overview = $contract_Overview;
        return $this;
    }
    /**
     * Get Catalog_Reference value
     * @return \StructType\Supplier_CatalogObjectType[]|null
     */
    public function getCatalog_Reference()
    {
        return $this->Catalog_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_ReferenceForArrayConstraintsFromSetCatalog_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Amendment_DataTypeCatalog_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Amendment_DataTypeCatalog_ReferenceItem instanceof \StructType\Supplier_CatalogObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Amendment_DataTypeCatalog_ReferenceItem) ? get_class($supplier_Contract_Amendment_DataTypeCatalog_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Amendment_DataTypeCatalog_ReferenceItem), var_export($supplier_Contract_Amendment_DataTypeCatalog_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Reference property can only contain items of type \StructType\Supplier_CatalogObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogObjectType[] $catalog_Reference
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setCatalog_Reference(array $catalog_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_ReferenceArrayErrorMessage = self::validateCatalog_ReferenceForArrayConstraintsFromSetCatalog_Reference($catalog_Reference))) {
            throw new \InvalidArgumentException($catalog_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Reference = $catalog_Reference;
        return $this;
    }
    /**
     * Add item to Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogObjectType $item
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function addToCatalog_Reference(\StructType\Supplier_CatalogObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CatalogObjectType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Reference property can only contain items of type \StructType\Supplier_CatalogObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Reference[] = $item;
        return $this;
    }
    /**
     * Get Catalog_Discount_Percent value
     * @return float|null
     */
    public function getCatalog_Discount_Percent()
    {
        return $this->Catalog_Discount_Percent;
    }
    /**
     * Set Catalog_Discount_Percent value
     * @param float $catalog_Discount_Percent
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setCatalog_Discount_Percent($catalog_Discount_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($catalog_Discount_Percent) && !(is_float($catalog_Discount_Percent) || is_numeric($catalog_Discount_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($catalog_Discount_Percent, true), gettype($catalog_Discount_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($catalog_Discount_Percent) && mb_strlen(mb_substr($catalog_Discount_Percent, false !== mb_strpos($catalog_Discount_Percent, '.') ? mb_strpos($catalog_Discount_Percent, '.') + 1 : mb_strlen($catalog_Discount_Percent))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($catalog_Discount_Percent, true), mb_strlen(mb_substr($catalog_Discount_Percent, mb_strpos($catalog_Discount_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($catalog_Discount_Percent) && $catalog_Discount_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($catalog_Discount_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($catalog_Discount_Percent) && mb_strlen(preg_replace('/(\D)/', '', $catalog_Discount_Percent)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($catalog_Discount_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $catalog_Discount_Percent))), __LINE__);
        }
        $this->Catalog_Discount_Percent = $catalog_Discount_Percent;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Data value
     * @return \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType|null
     */
    public function getSupplier_Invoice_Data()
    {
        return $this->Supplier_Invoice_Data;
    }
    /**
     * Set Supplier_Invoice_Data value
     * @param \StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType $supplier_Invoice_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setSupplier_Invoice_Data(\StructType\Supplier_Invoice_Defaults_for_Supplier_Contract_Amendment_DataType $supplier_Invoice_Data = null)
    {
        $this->Supplier_Invoice_Data = $supplier_Invoice_Data;
        return $this;
    }
    /**
     * Get Purchase_Order_Data value
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType|null
     */
    public function getPurchase_Order_Data()
    {
        return $this->Purchase_Order_Data;
    }
    /**
     * Set Purchase_Order_Data value
     * @param \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType $purchase_Order_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setPurchase_Order_Data(\StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType $purchase_Order_Data = null)
    {
        $this->Purchase_Order_Data = $purchase_Order_Data;
        return $this;
    }
    /**
     * Get On_Hold value
     * @return bool|null
     */
    public function getOn_Hold()
    {
        return $this->On_Hold;
    }
    /**
     * Set On_Hold value
     * @param bool $on_Hold
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setOn_Hold($on_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($on_Hold) && !is_bool($on_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($on_Hold, true), gettype($on_Hold)), __LINE__);
        }
        $this->On_Hold = $on_Hold;
        return $this;
    }
    /**
     * Get System_Generated value
     * @return bool|null
     */
    public function getSystem_Generated()
    {
        return $this->System_Generated;
    }
    /**
     * Set System_Generated value
     * @param bool $system_Generated
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setSystem_Generated($system_Generated = null)
    {
        // validation for constraint: boolean
        if (!is_null($system_Generated) && !is_bool($system_Generated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($system_Generated, true), gettype($system_Generated)), __LINE__);
        }
        $this->System_Generated = $system_Generated;
        return $this;
    }
    /**
     * Get Percent_to_Retain value
     * @return float|null
     */
    public function getPercent_to_Retain()
    {
        return $this->Percent_to_Retain;
    }
    /**
     * Set Percent_to_Retain value
     * @param float $percent_to_Retain
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setPercent_to_Retain($percent_to_Retain = null)
    {
        // validation for constraint: float
        if (!is_null($percent_to_Retain) && !(is_float($percent_to_Retain) || is_numeric($percent_to_Retain))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_to_Retain, true), gettype($percent_to_Retain)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($percent_to_Retain) && mb_strlen(mb_substr($percent_to_Retain, false !== mb_strpos($percent_to_Retain, '.') ? mb_strpos($percent_to_Retain, '.') + 1 : mb_strlen($percent_to_Retain))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($percent_to_Retain, true), mb_strlen(mb_substr($percent_to_Retain, mb_strpos($percent_to_Retain, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_to_Retain) && $percent_to_Retain < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_to_Retain, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($percent_to_Retain) && mb_strlen(preg_replace('/(\D)/', '', $percent_to_Retain)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($percent_to_Retain, true), mb_strlen(preg_replace('/(\D)/', '', $percent_to_Retain))), __LINE__);
        }
        $this->Percent_to_Retain = $percent_to_Retain;
        return $this;
    }
    /**
     * Get Estimated_Retention_Release_Date value
     * @return string|null
     */
    public function getEstimated_Retention_Release_Date()
    {
        return $this->Estimated_Retention_Release_Date;
    }
    /**
     * Set Estimated_Retention_Release_Date value
     * @param string $estimated_Retention_Release_Date
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setEstimated_Retention_Release_Date($estimated_Retention_Release_Date = null)
    {
        // validation for constraint: string
        if (!is_null($estimated_Retention_Release_Date) && !is_string($estimated_Retention_Release_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimated_Retention_Release_Date, true), gettype($estimated_Retention_Release_Date)), __LINE__);
        }
        $this->Estimated_Retention_Release_Date = $estimated_Retention_Release_Date;
        return $this;
    }
    /**
     * Get Third_Party_Retention value
     * @return bool|null
     */
    public function getThird_Party_Retention()
    {
        return $this->Third_Party_Retention;
    }
    /**
     * Set Third_Party_Retention value
     * @param bool $third_Party_Retention
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setThird_Party_Retention($third_Party_Retention = null)
    {
        // validation for constraint: boolean
        if (!is_null($third_Party_Retention) && !is_bool($third_Party_Retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($third_Party_Retention, true), gettype($third_Party_Retention)), __LINE__);
        }
        $this->Third_Party_Retention = $third_Party_Retention;
        return $this;
    }
    /**
     * Get Retention_Memo value
     * @return string|null
     */
    public function getRetention_Memo()
    {
        return $this->Retention_Memo;
    }
    /**
     * Set Retention_Memo value
     * @param string $retention_Memo
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setRetention_Memo($retention_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($retention_Memo) && !is_string($retention_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retention_Memo, true), gettype($retention_Memo)), __LINE__);
        }
        $this->Retention_Memo = $retention_Memo;
        return $this;
    }
    /**
     * Get Goods_Lines_Replacement_Data value
     * @return \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType[]|null
     */
    public function getGoods_Lines_Replacement_Data()
    {
        return $this->Goods_Lines_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setGoods_Lines_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoods_Lines_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoods_Lines_Replacement_DataForArrayConstraintsFromSetGoods_Lines_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Amendment_DataTypeGoods_Lines_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Amendment_DataTypeGoods_Lines_Replacement_DataItem instanceof \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Contract_Amendment_DataTypeGoods_Lines_Replacement_DataItem) ? get_class($supplier_Contract_Amendment_DataTypeGoods_Lines_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Contract_Amendment_DataTypeGoods_Lines_Replacement_DataItem), var_export($supplier_Contract_Amendment_DataTypeGoods_Lines_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Goods_Lines_Replacement_Data property can only contain items of type \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Goods_Lines_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType[] $goods_Lines_Replacement_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setGoods_Lines_Replacement_Data(array $goods_Lines_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($goods_Lines_Replacement_DataArrayErrorMessage = self::validateGoods_Lines_Replacement_DataForArrayConstraintsFromSetGoods_Lines_Replacement_Data($goods_Lines_Replacement_Data))) {
            throw new \InvalidArgumentException($goods_Lines_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Goods_Lines_Replacement_Data = $goods_Lines_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Goods_Lines_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType $item
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function addToGoods_Lines_Replacement_Data(\StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Goods_Lines_Replacement_Data property can only contain items of type \StructType\Supplier_Contract_Amendment_Goods_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Goods_Lines_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Service_Lines_Replacement_Data value
     * @return \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType[]|null
     */
    public function getService_Lines_Replacement_Data()
    {
        return $this->Service_Lines_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setService_Lines_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService_Lines_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateService_Lines_Replacement_DataForArrayConstraintsFromSetService_Lines_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Amendment_DataTypeService_Lines_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Amendment_DataTypeService_Lines_Replacement_DataItem instanceof \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Contract_Amendment_DataTypeService_Lines_Replacement_DataItem) ? get_class($supplier_Contract_Amendment_DataTypeService_Lines_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Contract_Amendment_DataTypeService_Lines_Replacement_DataItem), var_export($supplier_Contract_Amendment_DataTypeService_Lines_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service_Lines_Replacement_Data property can only contain items of type \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service_Lines_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType[] $service_Lines_Replacement_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setService_Lines_Replacement_Data(array $service_Lines_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($service_Lines_Replacement_DataArrayErrorMessage = self::validateService_Lines_Replacement_DataForArrayConstraintsFromSetService_Lines_Replacement_Data($service_Lines_Replacement_Data))) {
            throw new \InvalidArgumentException($service_Lines_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Service_Lines_Replacement_Data = $service_Lines_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Service_Lines_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType $item
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function addToService_Lines_Replacement_Data(\StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Service_Lines_Replacement_Data property can only contain items of type \StructType\Supplier_Contract_Amendment_Service_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service_Lines_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Multi_Supplier_Data value
     * @return \StructType\Multi_Supplier_DataType|null
     */
    public function getMulti_Supplier_Data()
    {
        return $this->Multi_Supplier_Data;
    }
    /**
     * Set Multi_Supplier_Data value
     * @param \StructType\Multi_Supplier_DataType $multi_Supplier_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setMulti_Supplier_Data(\StructType\Multi_Supplier_DataType $multi_Supplier_Data = null)
    {
        $this->Multi_Supplier_Data = $multi_Supplier_Data;
        return $this;
    }
    /**
     * Get Multi_Participant_Data value
     * @return \StructType\Multi_Participant_DataType|null
     */
    public function getMulti_Participant_Data()
    {
        return $this->Multi_Participant_Data;
    }
    /**
     * Set Multi_Participant_Data value
     * @param \StructType\Multi_Participant_DataType $multi_Participant_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setMulti_Participant_Data(\StructType\Multi_Participant_DataType $multi_Participant_Data = null)
    {
        $this->Multi_Participant_Data = $multi_Participant_Data;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Amendment_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Amendment_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($supplier_Contract_Amendment_DataTypeAttachment_DataItem) ? get_class($supplier_Contract_Amendment_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($supplier_Contract_Amendment_DataTypeAttachment_DataItem), var_export($supplier_Contract_Amendment_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Supplier_Contract_Amendment_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
}
