<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Prepaid_Spend_Amortization_Schedule_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The request for creating/updating a Prepaid Spend Amortization Schedule
 * @subpackage Structs
 */
class Submit_Prepaid_Spend_Amortization_Schedule_RequestType extends AbstractStructBase
{
    /**
     * The Prepaid_Spend_Amortization_Schedule_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to a Prepaid Spend Amortization Schedule. This is used to update an existing schedule. If this is entered, then the Supplier Invoice reference cannot.
     * - choice: Prepaid_Spend_Amortization_Schedule_Reference | Supplier_Invoice_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_ScheduleObjectType
     */
    public $Prepaid_Spend_Amortization_Schedule_Reference;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to a Supplier Invoice. If this is used then the Prepaid Spend Amortization Schedule Reference cannot.
     * - choice: Prepaid_Spend_Amortization_Schedule_Reference | Supplier_Invoice_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType[]
     */
    public $Business_Process_Parameters;
    /**
     * The Prepaid_Spend_Amortization_Schedule_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_Schedule_DataType
     */
    public $Prepaid_Spend_Amortization_Schedule_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Prepaid_Spend_Amortization_Schedule_RequestType
     * @uses Submit_Prepaid_Spend_Amortization_Schedule_RequestType::setPrepaid_Spend_Amortization_Schedule_Reference()
     * @uses Submit_Prepaid_Spend_Amortization_Schedule_RequestType::setSupplier_Invoice_Reference()
     * @uses Submit_Prepaid_Spend_Amortization_Schedule_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Prepaid_Spend_Amortization_Schedule_RequestType::setPrepaid_Spend_Amortization_Schedule_Data()
     * @uses Submit_Prepaid_Spend_Amortization_Schedule_RequestType::setVersion()
     * @param \StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @param \StructType\Prepaid_Spend_Amortization_Schedule_DataType $prepaid_Spend_Amortization_Schedule_Data
     * @param string $version
     */
    public function __construct(\StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, array $business_Process_Parameters = array(), \StructType\Prepaid_Spend_Amortization_Schedule_DataType $prepaid_Spend_Amortization_Schedule_Data = null, $version = null)
    {
        $this
            ->setPrepaid_Spend_Amortization_Schedule_Reference($prepaid_Spend_Amortization_Schedule_Reference)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setPrepaid_Spend_Amortization_Schedule_Data($prepaid_Spend_Amortization_Schedule_Data)
            ->setVersion($version);
    }
    /**
     * Get Prepaid_Spend_Amortization_Schedule_Reference value
     * @return \StructType\Prepaid_Spend_Amortization_ScheduleObjectType|null
     */
    public function getPrepaid_Spend_Amortization_Schedule_Reference()
    {
        return isset($this->Prepaid_Spend_Amortization_Schedule_Reference) ? $this->Prepaid_Spend_Amortization_Schedule_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPrepaid_Spend_Amortization_Schedule_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Spend_Amortization_Schedule_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrepaid_Spend_Amortization_Schedule_ReferenceForChoiceConstraintsFromSetPrepaid_Spend_Amortization_Schedule_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Invoice_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Prepaid_Spend_Amortization_Schedule_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Prepaid_Spend_Amortization_Schedule_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Prepaid_Spend_Amortization_Schedule_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference
     * @return \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType
     */
    public function setPrepaid_Spend_Amortization_Schedule_Reference(\StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference = null)
    {
        // validation for constraint: choice(Prepaid_Spend_Amortization_Schedule_Reference, Supplier_Invoice_Reference)
        if ('' !== ($prepaid_Spend_Amortization_Schedule_ReferenceChoiceErrorMessage = self::validatePrepaid_Spend_Amortization_Schedule_ReferenceForChoiceConstraintsFromSetPrepaid_Spend_Amortization_Schedule_Reference($prepaid_Spend_Amortization_Schedule_Reference))) {
            throw new \InvalidArgumentException($prepaid_Spend_Amortization_Schedule_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($prepaid_Spend_Amortization_Schedule_Reference) || (is_array($prepaid_Spend_Amortization_Schedule_Reference) && empty($prepaid_Spend_Amortization_Schedule_Reference))) {
            unset($this->Prepaid_Spend_Amortization_Schedule_Reference);
        } else {
            $this->Prepaid_Spend_Amortization_Schedule_Reference = $prepaid_Spend_Amortization_Schedule_Reference;
        }
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return isset($this->Supplier_Invoice_Reference) ? $this->Supplier_Invoice_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Invoice_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Invoice_ReferenceForChoiceConstraintsFromSetSupplier_Invoice_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Prepaid_Spend_Amortization_Schedule_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Invoice_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Invoice_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        // validation for constraint: choice(Prepaid_Spend_Amortization_Schedule_Reference, Supplier_Invoice_Reference)
        if ('' !== ($supplier_Invoice_ReferenceChoiceErrorMessage = self::validateSupplier_Invoice_ReferenceForChoiceConstraintsFromSetSupplier_Invoice_Reference($supplier_Invoice_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Invoice_Reference) || (is_array($supplier_Invoice_Reference) && empty($supplier_Invoice_Reference))) {
            unset($this->Supplier_Invoice_Reference);
        } else {
            $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        }
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType[]|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Process_Parameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Process_Parameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Prepaid_Spend_Amortization_Schedule_RequestTypeBusiness_Process_ParametersItem) {
            // validation for constraint: itemType
            if (!$submit_Prepaid_Spend_Amortization_Schedule_RequestTypeBusiness_Process_ParametersItem instanceof \StructType\Financials_Business_Process_ParametersType) {
                $invalidValues[] = is_object($submit_Prepaid_Spend_Amortization_Schedule_RequestTypeBusiness_Process_ParametersItem) ? get_class($submit_Prepaid_Spend_Amortization_Schedule_RequestTypeBusiness_Process_ParametersItem) : sprintf('%s(%s)', gettype($submit_Prepaid_Spend_Amortization_Schedule_RequestTypeBusiness_Process_ParametersItem), var_export($submit_Prepaid_Spend_Amortization_Schedule_RequestTypeBusiness_Process_ParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @return \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType
     */
    public function setBusiness_Process_Parameters(array $business_Process_Parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Process_ParametersArrayErrorMessage = self::validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters($business_Process_Parameters))) {
            throw new \InvalidArgumentException($business_Process_ParametersArrayErrorMessage, __LINE__);
        }
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Add item to Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType $item
     * @return \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType
     */
    public function addToBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Business_Process_ParametersType) {
            throw new \InvalidArgumentException(sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Process_Parameters[] = $item;
        return $this;
    }
    /**
     * Get Prepaid_Spend_Amortization_Schedule_Data value
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_DataType|null
     */
    public function getPrepaid_Spend_Amortization_Schedule_Data()
    {
        return $this->Prepaid_Spend_Amortization_Schedule_Data;
    }
    /**
     * Set Prepaid_Spend_Amortization_Schedule_Data value
     * @param \StructType\Prepaid_Spend_Amortization_Schedule_DataType $prepaid_Spend_Amortization_Schedule_Data
     * @return \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType
     */
    public function setPrepaid_Spend_Amortization_Schedule_Data(\StructType\Prepaid_Spend_Amortization_Schedule_DataType $prepaid_Spend_Amortization_Schedule_Data = null)
    {
        $this->Prepaid_Spend_Amortization_Schedule_Data = $prepaid_Spend_Amortization_Schedule_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
