<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Authorization_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the Spend Authorization Request specific criteria needed to search for instances. All of the elements are "AND" conditions.
 * @subpackage Structs
 */
class Spend_Authorization_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Organization_Reference;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Payee.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType[]
     */
    public $Expense_Payee_Reference;
    /**
     * The Expense_Payee_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Expense Payee Type on the Spend Authorization - Employee, Contingent Worker, or External Committee Member.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payee_TypeObjectType[]
     */
    public $Expense_Payee_Type_Reference;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Document_Number
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Number;
    /**
     * The Created_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Created From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Created_Start_Date;
    /**
     * The Created_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Created To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Created_End_Date;
    /**
     * The Approved_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Approved From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Approved_Start_Date;
    /**
     * The Approved_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Approved To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Approved_End_Date;
    /**
     * Constructor method for Spend_Authorization_Request_CriteriaType
     * @uses Spend_Authorization_Request_CriteriaType::setOrganization_Reference()
     * @uses Spend_Authorization_Request_CriteriaType::setExpense_Payee_Reference()
     * @uses Spend_Authorization_Request_CriteriaType::setExpense_Payee_Type_Reference()
     * @uses Spend_Authorization_Request_CriteriaType::setStart_Date()
     * @uses Spend_Authorization_Request_CriteriaType::setEnd_Date()
     * @uses Spend_Authorization_Request_CriteriaType::setDocument_Number()
     * @uses Spend_Authorization_Request_CriteriaType::setCreated_Start_Date()
     * @uses Spend_Authorization_Request_CriteriaType::setCreated_End_Date()
     * @uses Spend_Authorization_Request_CriteriaType::setApproved_Start_Date()
     * @uses Spend_Authorization_Request_CriteriaType::setApproved_End_Date()
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @param \StructType\Payee_TypeObjectType[] $expense_Payee_Type_Reference
     * @param string $start_Date
     * @param string $end_Date
     * @param string $document_Number
     * @param string $created_Start_Date
     * @param string $created_End_Date
     * @param string $approved_Start_Date
     * @param string $approved_End_Date
     */
    public function __construct(array $organization_Reference = array(), array $expense_Payee_Reference = array(), array $expense_Payee_Type_Reference = array(), $start_Date = null, $end_Date = null, $document_Number = null, $created_Start_Date = null, $created_End_Date = null, $approved_Start_Date = null, $approved_End_Date = null)
    {
        $this
            ->setOrganization_Reference($organization_Reference)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setExpense_Payee_Type_Reference($expense_Payee_Type_Reference)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setDocument_Number($document_Number)
            ->setCreated_Start_Date($created_Start_Date)
            ->setCreated_End_Date($created_End_Date)
            ->setApproved_Start_Date($approved_Start_Date)
            ->setApproved_End_Date($approved_End_Date);
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_Request_CriteriaTypeOrganization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_Request_CriteriaTypeOrganization_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($spend_Authorization_Request_CriteriaTypeOrganization_ReferenceItem) ? get_class($spend_Authorization_Request_CriteriaTypeOrganization_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Authorization_Request_CriteriaTypeOrganization_ReferenceItem), var_export($spend_Authorization_Request_CriteriaTypeOrganization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setOrganization_Reference(array $organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_ReferenceArrayErrorMessage = self::validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference($organization_Reference))) {
            throw new \InvalidArgumentException($organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Add item to Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function addToOrganization_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType[]|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Payee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Payee_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_Request_CriteriaTypeExpense_Payee_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_Request_CriteriaTypeExpense_Payee_ReferenceItem instanceof \StructType\Expense_PayeeObjectType) {
                $invalidValues[] = is_object($spend_Authorization_Request_CriteriaTypeExpense_Payee_ReferenceItem) ? get_class($spend_Authorization_Request_CriteriaTypeExpense_Payee_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Authorization_Request_CriteriaTypeExpense_Payee_ReferenceItem), var_export($spend_Authorization_Request_CriteriaTypeExpense_Payee_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setExpense_Payee_Reference(array $expense_Payee_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Payee_ReferenceArrayErrorMessage = self::validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference($expense_Payee_Reference))) {
            throw new \InvalidArgumentException($expense_Payee_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $item
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function addToExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_PayeeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Payee_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Payee_Type_Reference value
     * @return \StructType\Payee_TypeObjectType[]|null
     */
    public function getExpense_Payee_Type_Reference()
    {
        return $this->Expense_Payee_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Payee_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Payee_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Payee_Type_ReferenceForArrayConstraintsFromSetExpense_Payee_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem instanceof \StructType\Payee_TypeObjectType) {
                $invalidValues[] = is_object($spend_Authorization_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem) ? get_class($spend_Authorization_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Authorization_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem), var_export($spend_Authorization_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Payee_Type_Reference property can only contain items of type \StructType\Payee_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Payee_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payee_TypeObjectType[] $expense_Payee_Type_Reference
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setExpense_Payee_Type_Reference(array $expense_Payee_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Payee_Type_ReferenceArrayErrorMessage = self::validateExpense_Payee_Type_ReferenceForArrayConstraintsFromSetExpense_Payee_Type_Reference($expense_Payee_Type_Reference))) {
            throw new \InvalidArgumentException($expense_Payee_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Payee_Type_Reference = $expense_Payee_Type_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Payee_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payee_TypeObjectType $item
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function addToExpense_Payee_Type_Reference(\StructType\Payee_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payee_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Payee_Type_Reference property can only contain items of type \StructType\Payee_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Payee_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Document_Number value
     * @return string|null
     */
    public function getDocument_Number()
    {
        return $this->Document_Number;
    }
    /**
     * Set Document_Number value
     * @param string $document_Number
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setDocument_Number($document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($document_Number) && !is_string($document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Number, true), gettype($document_Number)), __LINE__);
        }
        $this->Document_Number = $document_Number;
        return $this;
    }
    /**
     * Get Created_Start_Date value
     * @return string|null
     */
    public function getCreated_Start_Date()
    {
        return $this->Created_Start_Date;
    }
    /**
     * Set Created_Start_Date value
     * @param string $created_Start_Date
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setCreated_Start_Date($created_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($created_Start_Date) && !is_string($created_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created_Start_Date, true), gettype($created_Start_Date)), __LINE__);
        }
        $this->Created_Start_Date = $created_Start_Date;
        return $this;
    }
    /**
     * Get Created_End_Date value
     * @return string|null
     */
    public function getCreated_End_Date()
    {
        return $this->Created_End_Date;
    }
    /**
     * Set Created_End_Date value
     * @param string $created_End_Date
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setCreated_End_Date($created_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($created_End_Date) && !is_string($created_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created_End_Date, true), gettype($created_End_Date)), __LINE__);
        }
        $this->Created_End_Date = $created_End_Date;
        return $this;
    }
    /**
     * Get Approved_Start_Date value
     * @return string|null
     */
    public function getApproved_Start_Date()
    {
        return $this->Approved_Start_Date;
    }
    /**
     * Set Approved_Start_Date value
     * @param string $approved_Start_Date
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setApproved_Start_Date($approved_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($approved_Start_Date) && !is_string($approved_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved_Start_Date, true), gettype($approved_Start_Date)), __LINE__);
        }
        $this->Approved_Start_Date = $approved_Start_Date;
        return $this;
    }
    /**
     * Get Approved_End_Date value
     * @return string|null
     */
    public function getApproved_End_Date()
    {
        return $this->Approved_End_Date;
    }
    /**
     * Set Approved_End_Date value
     * @param string $approved_End_Date
     * @return \StructType\Spend_Authorization_Request_CriteriaType
     */
    public function setApproved_End_Date($approved_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($approved_End_Date) && !is_string($approved_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved_End_Date, true), gettype($approved_End_Date)), __LINE__);
        }
        $this->Approved_End_Date = $approved_End_Date;
        return $this;
    }
}
