<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response_FilterType StructType
 * Meta information extracted from the WSDL
 * - documentation: Page number cannot be zero. | Parameters that let you filter the data returned in the response. You can filter returned data by dates and page attributes.
 * @subpackage Structs
 */
class Response_FilterType extends AbstractStructBase
{
    /**
     * The As_Of_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Indicates the date when application data, such as benefits and compensation, become effective (Also referred to as the Effective Moment). If you don't specify a date, this date defaults to today.{+4}
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $As_Of_Effective_Date;
    /**
     * The As_Of_Entry_DateTime
     * Meta information extracted from the WSDL
     * - documentation: The date and time the data was entered into the system. (This field is also referred to as the Entry Moment). If the date isn't specified, the default date is the current date and time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $As_Of_Entry_DateTime;
    /**
     * The Page
     * Meta information extracted from the WSDL
     * - documentation: The numbered page of data Workday returns in the response. The default page is the first page(Page = 1). For responses that contain more than one page of data, use this parameter to retrieve the additional pages of data. For example,
     * set Page = 2 to retrieve the second page of data.Note: If you set the page parameter, you must also specify the "As_Of_Entry_Date" to ensure that the result set remains the same between your requests. | The page number of the data the WWS returned
     * for your request.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Page;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - documentation: Sets the number of objects to return within each response page. Set a value between 1 and 999. The default value is 100.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Count;
    /**
     * Constructor method for Response_FilterType
     * @uses Response_FilterType::setAs_Of_Effective_Date()
     * @uses Response_FilterType::setAs_Of_Entry_DateTime()
     * @uses Response_FilterType::setPage()
     * @uses Response_FilterType::setCount()
     * @param string $as_Of_Effective_Date
     * @param string $as_Of_Entry_DateTime
     * @param float $page
     * @param float $count
     */
    public function __construct($as_Of_Effective_Date = null, $as_Of_Entry_DateTime = null, $page = null, $count = null)
    {
        $this
            ->setAs_Of_Effective_Date($as_Of_Effective_Date)
            ->setAs_Of_Entry_DateTime($as_Of_Entry_DateTime)
            ->setPage($page)
            ->setCount($count);
    }
    /**
     * Get As_Of_Effective_Date value
     * @return string|null
     */
    public function getAs_Of_Effective_Date()
    {
        return $this->As_Of_Effective_Date;
    }
    /**
     * Set As_Of_Effective_Date value
     * @param string $as_Of_Effective_Date
     * @return \StructType\Response_FilterType
     */
    public function setAs_Of_Effective_Date($as_Of_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($as_Of_Effective_Date) && !is_string($as_Of_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($as_Of_Effective_Date, true), gettype($as_Of_Effective_Date)), __LINE__);
        }
        $this->As_Of_Effective_Date = $as_Of_Effective_Date;
        return $this;
    }
    /**
     * Get As_Of_Entry_DateTime value
     * @return string|null
     */
    public function getAs_Of_Entry_DateTime()
    {
        return $this->As_Of_Entry_DateTime;
    }
    /**
     * Set As_Of_Entry_DateTime value
     * @param string $as_Of_Entry_DateTime
     * @return \StructType\Response_FilterType
     */
    public function setAs_Of_Entry_DateTime($as_Of_Entry_DateTime = null)
    {
        // validation for constraint: string
        if (!is_null($as_Of_Entry_DateTime) && !is_string($as_Of_Entry_DateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($as_Of_Entry_DateTime, true), gettype($as_Of_Entry_DateTime)), __LINE__);
        }
        $this->As_Of_Entry_DateTime = $as_Of_Entry_DateTime;
        return $this;
    }
    /**
     * Get Page value
     * @return float|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param float $page
     * @return \StructType\Response_FilterType
     */
    public function setPage($page = null)
    {
        // validation for constraint: float
        if (!is_null($page) && !(is_float($page) || is_numeric($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($page) && mb_strlen(mb_substr($page, false !== mb_strpos($page, '.') ? mb_strpos($page, '.') + 1 : mb_strlen($page))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($page, true), mb_strlen(mb_substr($page, mb_strpos($page, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($page) && $page < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($page, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($page) && mb_strlen(preg_replace('/(\D)/', '', $page)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($page, true), mb_strlen(preg_replace('/(\D)/', '', $page))), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get Count value
     * @return float|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param float $count
     * @return \StructType\Response_FilterType
     */
    public function setCount($count = null)
    {
        // validation for constraint: float
        if (!is_null($count) && !(is_float($count) || is_numeric($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($count) && mb_strlen(mb_substr($count, false !== mb_strpos($count, '.') ? mb_strpos($count, '.') + 1 : mb_strlen($count))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($count, true), mb_strlen(mb_substr($count, mb_strpos($count, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($count) && $count < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($count, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($count) && mb_strlen(preg_replace('/(\D)/', '', $count)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($count, true), mb_strlen(preg_replace('/(\D)/', '', $count))), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
}
