<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains purchase order information for supplier contracts
 * @subpackage Structs
 */
class Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType extends AbstractStructBase
{
    /**
     * The Company_for_Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company for Purchase Order Reference
     * @var \StructType\CompanyObjectType
     */
    public $Company_for_Purchase_Order_Reference;
    /**
     * The Purchase_Order_Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Issue Option
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Purchase_Order_Issue_Option_Reference;
    /**
     * The Purchase_Order_Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Payment Terms Reference
     * @var \StructType\Payment_TermsObjectType
     */
    public $Purchase_Order_Payment_Terms_Reference;
    /**
     * The Bill_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Contact
     * - maxOccurs: 1
     * @var string
     */
    public $Bill_To_Contact_Detail;
    /**
     * The Bill_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Reference
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Bill_To_Address_Reference;
    /**
     * The Ship_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Ship-To Contact
     * - maxOccurs: 1
     * @var string
     */
    public $Ship_To_Contact_Detail;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To address.
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * Constructor method for
     * Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     * @uses Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType::setCompany_for_Purchase_Order_Reference()
     * @uses Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType::setPurchase_Order_Issue_Option_Reference()
     * @uses Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType::setPurchase_Order_Payment_Terms_Reference()
     * @uses Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType::setBill_To_Contact_Detail()
     * @uses Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType::setBill_To_Address_Reference()
     * @uses Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType::setShip_To_Contact_Detail()
     * @uses Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType::setShip_To_Address_Reference()
     * @param \StructType\CompanyObjectType $company_for_Purchase_Order_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @param \StructType\Payment_TermsObjectType $purchase_Order_Payment_Terms_Reference
     * @param string $bill_To_Contact_Detail
     * @param \StructType\Address_ReferenceObjectType $bill_To_Address_Reference
     * @param string $ship_To_Contact_Detail
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     */
    public function __construct(\StructType\CompanyObjectType $company_for_Purchase_Order_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null, \StructType\Payment_TermsObjectType $purchase_Order_Payment_Terms_Reference = null, $bill_To_Contact_Detail = null, \StructType\Address_ReferenceObjectType $bill_To_Address_Reference = null, $ship_To_Contact_Detail = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this
            ->setCompany_for_Purchase_Order_Reference($company_for_Purchase_Order_Reference)
            ->setPurchase_Order_Issue_Option_Reference($purchase_Order_Issue_Option_Reference)
            ->setPurchase_Order_Payment_Terms_Reference($purchase_Order_Payment_Terms_Reference)
            ->setBill_To_Contact_Detail($bill_To_Contact_Detail)
            ->setBill_To_Address_Reference($bill_To_Address_Reference)
            ->setShip_To_Contact_Detail($ship_To_Contact_Detail)
            ->setShip_To_Address_Reference($ship_To_Address_Reference);
    }
    /**
     * Get Company_for_Purchase_Order_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_for_Purchase_Order_Reference()
    {
        return $this->Company_for_Purchase_Order_Reference;
    }
    /**
     * Set Company_for_Purchase_Order_Reference value
     * @param \StructType\CompanyObjectType $company_for_Purchase_Order_Reference
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setCompany_for_Purchase_Order_Reference(\StructType\CompanyObjectType $company_for_Purchase_Order_Reference = null)
    {
        $this->Company_for_Purchase_Order_Reference = $company_for_Purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getPurchase_Order_Issue_Option_Reference()
    {
        return $this->Purchase_Order_Issue_Option_Reference;
    }
    /**
     * Set Purchase_Order_Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setPurchase_Order_Issue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null)
    {
        $this->Purchase_Order_Issue_Option_Reference = $purchase_Order_Issue_Option_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPurchase_Order_Payment_Terms_Reference()
    {
        return $this->Purchase_Order_Payment_Terms_Reference;
    }
    /**
     * Set Purchase_Order_Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $purchase_Order_Payment_Terms_Reference
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setPurchase_Order_Payment_Terms_Reference(\StructType\Payment_TermsObjectType $purchase_Order_Payment_Terms_Reference = null)
    {
        $this->Purchase_Order_Payment_Terms_Reference = $purchase_Order_Payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact_Detail value
     * @return string|null
     */
    public function getBill_To_Contact_Detail()
    {
        return $this->{'Bill-To_Contact_Detail'};
    }
    /**
     * Set Bill_To_Contact_Detail value
     * @param string $bill_To_Contact_Detail
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setBill_To_Contact_Detail($bill_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($bill_To_Contact_Detail) && !is_string($bill_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_To_Contact_Detail, true), gettype($bill_To_Contact_Detail)), __LINE__);
        }
        $this->Bill_To_Contact_Detail = $this->{'Bill-To_Contact_Detail'} = $bill_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Bill_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getBill_To_Address_Reference()
    {
        return $this->{'Bill-To_Address_Reference'};
    }
    /**
     * Set Bill_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $bill_To_Address_Reference
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setBill_To_Address_Reference(\StructType\Address_ReferenceObjectType $bill_To_Address_Reference = null)
    {
        $this->Bill_To_Address_Reference = $this->{'Bill-To_Address_Reference'} = $bill_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Detail value
     * @return string|null
     */
    public function getShip_To_Contact_Detail()
    {
        return $this->{'Ship-To_Contact_Detail'};
    }
    /**
     * Set Ship_To_Contact_Detail value
     * @param string $ship_To_Contact_Detail
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setShip_To_Contact_Detail($ship_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Contact_Detail) && !is_string($ship_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Contact_Detail, true), gettype($ship_To_Contact_Detail)), __LINE__);
        }
        $this->Ship_To_Contact_Detail = $this->{'Ship-To_Contact_Detail'} = $ship_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Purchase_Order_Defaults_for_Supplier_Contract_Amendment_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
}
