<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Template_Definition_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Item Request Template Definition Data
 * @subpackage Structs
 */
class Purchase_Item_Request_Template_Definition_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Template_Definition_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Template Definition Data
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_Request_Template_Definition_ID;
    /**
     * The Worksheet_Template_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worksheet Template Type
     * @var \StructType\Worksheet_Template_TypeObjectType
     */
    public $Worksheet_Template_Type_Reference;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Text value for order of Condition Item. | Order
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The Purchase_Item_Request_Template_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Worksheet Template Definition Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_Template_Item_DataType[]
     */
    public $Purchase_Item_Request_Template_Item_Data;
    /**
     * Constructor method for Purchase_Item_Request_Template_Definition_DataType
     * @uses Purchase_Item_Request_Template_Definition_DataType::setPurchase_Item_Request_Template_Definition_ID()
     * @uses Purchase_Item_Request_Template_Definition_DataType::setWorksheet_Template_Type_Reference()
     * @uses Purchase_Item_Request_Template_Definition_DataType::setName()
     * @uses Purchase_Item_Request_Template_Definition_DataType::setOrder()
     * @uses Purchase_Item_Request_Template_Definition_DataType::setPurchase_Item_Request_Template_Item_Data()
     * @param string $purchase_Item_Request_Template_Definition_ID
     * @param \StructType\Worksheet_Template_TypeObjectType $worksheet_Template_Type_Reference
     * @param string $name
     * @param string $order
     * @param \StructType\Purchase_Item_Request_Template_Item_DataType[] $purchase_Item_Request_Template_Item_Data
     */
    public function __construct($purchase_Item_Request_Template_Definition_ID = null, \StructType\Worksheet_Template_TypeObjectType $worksheet_Template_Type_Reference = null, $name = null, $order = null, array $purchase_Item_Request_Template_Item_Data = array())
    {
        $this
            ->setPurchase_Item_Request_Template_Definition_ID($purchase_Item_Request_Template_Definition_ID)
            ->setWorksheet_Template_Type_Reference($worksheet_Template_Type_Reference)
            ->setName($name)
            ->setOrder($order)
            ->setPurchase_Item_Request_Template_Item_Data($purchase_Item_Request_Template_Item_Data);
    }
    /**
     * Get Purchase_Item_Request_Template_Definition_ID value
     * @return string|null
     */
    public function getPurchase_Item_Request_Template_Definition_ID()
    {
        return $this->Purchase_Item_Request_Template_Definition_ID;
    }
    /**
     * Set Purchase_Item_Request_Template_Definition_ID value
     * @param string $purchase_Item_Request_Template_Definition_ID
     * @return \StructType\Purchase_Item_Request_Template_Definition_DataType
     */
    public function setPurchase_Item_Request_Template_Definition_ID($purchase_Item_Request_Template_Definition_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_Request_Template_Definition_ID) && !is_string($purchase_Item_Request_Template_Definition_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_Request_Template_Definition_ID, true), gettype($purchase_Item_Request_Template_Definition_ID)), __LINE__);
        }
        $this->Purchase_Item_Request_Template_Definition_ID = $purchase_Item_Request_Template_Definition_ID;
        return $this;
    }
    /**
     * Get Worksheet_Template_Type_Reference value
     * @return \StructType\Worksheet_Template_TypeObjectType|null
     */
    public function getWorksheet_Template_Type_Reference()
    {
        return $this->Worksheet_Template_Type_Reference;
    }
    /**
     * Set Worksheet_Template_Type_Reference value
     * @param \StructType\Worksheet_Template_TypeObjectType $worksheet_Template_Type_Reference
     * @return \StructType\Purchase_Item_Request_Template_Definition_DataType
     */
    public function setWorksheet_Template_Type_Reference(\StructType\Worksheet_Template_TypeObjectType $worksheet_Template_Type_Reference = null)
    {
        $this->Worksheet_Template_Type_Reference = $worksheet_Template_Type_Reference;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Purchase_Item_Request_Template_Definition_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Purchase_Item_Request_Template_Definition_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Purchase_Item_Request_Template_Item_Data value
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType[]|null
     */
    public function getPurchase_Item_Request_Template_Item_Data()
    {
        return $this->Purchase_Item_Request_Template_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Request_Template_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Request_Template_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Request_Template_Item_DataForArrayConstraintsFromSetPurchase_Item_Request_Template_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Template_Definition_DataTypePurchase_Item_Request_Template_Item_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Template_Definition_DataTypePurchase_Item_Request_Template_Item_DataItem instanceof \StructType\Purchase_Item_Request_Template_Item_DataType) {
                $invalidValues[] = is_object($purchase_Item_Request_Template_Definition_DataTypePurchase_Item_Request_Template_Item_DataItem) ? get_class($purchase_Item_Request_Template_Definition_DataTypePurchase_Item_Request_Template_Item_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Template_Definition_DataTypePurchase_Item_Request_Template_Item_DataItem), var_export($purchase_Item_Request_Template_Definition_DataTypePurchase_Item_Request_Template_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Request_Template_Item_Data property can only contain items of type \StructType\Purchase_Item_Request_Template_Item_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Request_Template_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_Item_DataType[] $purchase_Item_Request_Template_Item_Data
     * @return \StructType\Purchase_Item_Request_Template_Definition_DataType
     */
    public function setPurchase_Item_Request_Template_Item_Data(array $purchase_Item_Request_Template_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Request_Template_Item_DataArrayErrorMessage = self::validatePurchase_Item_Request_Template_Item_DataForArrayConstraintsFromSetPurchase_Item_Request_Template_Item_Data($purchase_Item_Request_Template_Item_Data))) {
            throw new \InvalidArgumentException($purchase_Item_Request_Template_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Request_Template_Item_Data = $purchase_Item_Request_Template_Item_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Request_Template_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_Item_DataType $item
     * @return \StructType\Purchase_Item_Request_Template_Definition_DataType
     */
    public function addToPurchase_Item_Request_Template_Item_Data(\StructType\Purchase_Item_Request_Template_Item_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Request_Template_Item_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Request_Template_Item_Data property can only contain items of type \StructType\Purchase_Item_Request_Template_Item_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Request_Template_Item_Data[] = $item;
        return $this;
    }
}
