<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Timesheet_Day_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: vThis element encapsulates data for a single Project Timesheet Day
 * @subpackage Structs
 */
class Project_Timesheet_Day_DataType extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: The date this day contains hours for.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Hours
     * Meta information extracted from the WSDL
     * - documentation: The total hours worked on this day. | Hours worked.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Hours;
    /**
     * Constructor method for Project_Timesheet_Day_DataType
     * @uses Project_Timesheet_Day_DataType::setDate()
     * @uses Project_Timesheet_Day_DataType::setHours()
     * @param string $date
     * @param float $hours
     */
    public function __construct($date = null, $hours = null)
    {
        $this
            ->setDate($date)
            ->setHours($hours);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Project_Timesheet_Day_DataType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Hours value
     * @return float|null
     */
    public function getHours()
    {
        return $this->Hours;
    }
    /**
     * Set Hours value
     * @param float $hours
     * @return \StructType\Project_Timesheet_Day_DataType
     */
    public function setHours($hours = null)
    {
        // validation for constraint: float
        if (!is_null($hours) && !(is_float($hours) || is_numeric($hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hours, true), gettype($hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hours) && mb_strlen(mb_substr($hours, false !== mb_strpos($hours, '.') ? mb_strpos($hours, '.') + 1 : mb_strlen($hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hours, true), mb_strlen(mb_substr($hours, mb_strpos($hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($hours) && mb_strlen(preg_replace('/(\D)/', '', $hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($hours, true), mb_strlen(preg_replace('/(\D)/', '', $hours))), __LINE__);
        }
        $this->Hours = $hours;
        return $this;
    }
}
