<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_TagType StructType
 * Meta information extracted from the WSDL
 * - documentation: The element containing the item tag.
 * @subpackage Structs
 */
class Item_TagType extends AbstractStructBase
{
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the item tag class.
     * - minOccurs: 0
     * @var \StructType\Item_TagObjectType
     */
    public $Item_Tag_Reference;
    /**
     * The Item_Tag_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Tag_DataType[]
     */
    public $Item_Tag_Data;
    /**
     * Constructor method for Item_TagType
     * @uses Item_TagType::setItem_Tag_Reference()
     * @uses Item_TagType::setItem_Tag_Data()
     * @param \StructType\Item_TagObjectType $item_Tag_Reference
     * @param \StructType\Item_Tag_DataType[] $item_Tag_Data
     */
    public function __construct(\StructType\Item_TagObjectType $item_Tag_Reference = null, array $item_Tag_Data = array())
    {
        $this
            ->setItem_Tag_Reference($item_Tag_Reference)
            ->setItem_Tag_Data($item_Tag_Data);
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * Set Item_Tag_Reference value
     * @param \StructType\Item_TagObjectType $item_Tag_Reference
     * @return \StructType\Item_TagType
     */
    public function setItem_Tag_Reference(\StructType\Item_TagObjectType $item_Tag_Reference = null)
    {
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Get Item_Tag_Data value
     * @return \StructType\Item_Tag_DataType[]|null
     */
    public function getItem_Tag_Data()
    {
        return $this->Item_Tag_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Tag_DataForArrayConstraintsFromSetItem_Tag_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_TagTypeItem_Tag_DataItem) {
            // validation for constraint: itemType
            if (!$item_TagTypeItem_Tag_DataItem instanceof \StructType\Item_Tag_DataType) {
                $invalidValues[] = is_object($item_TagTypeItem_Tag_DataItem) ? get_class($item_TagTypeItem_Tag_DataItem) : sprintf('%s(%s)', gettype($item_TagTypeItem_Tag_DataItem), var_export($item_TagTypeItem_Tag_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag_Data property can only contain items of type \StructType\Item_Tag_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Tag_DataType[] $item_Tag_Data
     * @return \StructType\Item_TagType
     */
    public function setItem_Tag_Data(array $item_Tag_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Tag_DataArrayErrorMessage = self::validateItem_Tag_DataForArrayConstraintsFromSetItem_Tag_Data($item_Tag_Data))) {
            throw new \InvalidArgumentException($item_Tag_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag_Data = $item_Tag_Data;
        return $this;
    }
    /**
     * Add item to Item_Tag_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Tag_DataType $item
     * @return \StructType\Item_TagType
     */
    public function addToItem_Tag_Data(\StructType\Item_Tag_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Tag_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag_Data property can only contain items of type \StructType\Item_Tag_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag_Data[] = $item;
        return $this;
    }
}
