<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_iData_ReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Employee or Contingent Worker
 * @subpackage Structs
 */
class Worker_iData_ReferenceType extends AbstractStructBase
{
    /**
     * The Employee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Employee
     * - choice: Employee_Reference | Contingent_Worker_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\EmployeeObjectType
     */
    public $Employee_Reference;
    /**
     * The Contingent_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Contingent Worker
     * - choice: Employee_Reference | Contingent_Worker_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Contingent_WorkerObjectType
     */
    public $Contingent_Worker_Reference;
    /**
     * Constructor method for Worker_iData_ReferenceType
     * @uses Worker_iData_ReferenceType::setEmployee_Reference()
     * @uses Worker_iData_ReferenceType::setContingent_Worker_Reference()
     * @param \StructType\EmployeeObjectType $employee_Reference
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     */
    public function __construct(\StructType\EmployeeObjectType $employee_Reference = null, \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null)
    {
        $this
            ->setEmployee_Reference($employee_Reference)
            ->setContingent_Worker_Reference($contingent_Worker_Reference);
    }
    /**
     * Get Employee_Reference value
     * @return \StructType\EmployeeObjectType|null
     */
    public function getEmployee_Reference()
    {
        return isset($this->Employee_Reference) ? $this->Employee_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEmployee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployee_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEmployee_ReferenceForChoiceConstraintsFromSetEmployee_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Contingent_Worker_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Employee_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Employee_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Employee_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeObjectType $employee_Reference
     * @return \StructType\Worker_iData_ReferenceType
     */
    public function setEmployee_Reference(\StructType\EmployeeObjectType $employee_Reference = null)
    {
        // validation for constraint: choice(Employee_Reference, Contingent_Worker_Reference)
        if ('' !== ($employee_ReferenceChoiceErrorMessage = self::validateEmployee_ReferenceForChoiceConstraintsFromSetEmployee_Reference($employee_Reference))) {
            throw new \InvalidArgumentException($employee_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($employee_Reference) || (is_array($employee_Reference) && empty($employee_Reference))) {
            unset($this->Employee_Reference);
        } else {
            $this->Employee_Reference = $employee_Reference;
        }
        return $this;
    }
    /**
     * Get Contingent_Worker_Reference value
     * @return \StructType\Contingent_WorkerObjectType|null
     */
    public function getContingent_Worker_Reference()
    {
        return isset($this->Contingent_Worker_Reference) ? $this->Contingent_Worker_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setContingent_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContingent_Worker_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateContingent_Worker_ReferenceForChoiceConstraintsFromSetContingent_Worker_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Employee_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Contingent_Worker_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Contingent_Worker_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Contingent_Worker_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     * @return \StructType\Worker_iData_ReferenceType
     */
    public function setContingent_Worker_Reference(\StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null)
    {
        // validation for constraint: choice(Employee_Reference, Contingent_Worker_Reference)
        if ('' !== ($contingent_Worker_ReferenceChoiceErrorMessage = self::validateContingent_Worker_ReferenceForChoiceConstraintsFromSetContingent_Worker_Reference($contingent_Worker_Reference))) {
            throw new \InvalidArgumentException($contingent_Worker_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($contingent_Worker_Reference) || (is_array($contingent_Worker_Reference) && empty($contingent_Worker_Reference))) {
            unset($this->Contingent_Worker_Reference);
        } else {
            $this->Contingent_Worker_Reference = $contingent_Worker_Reference;
        }
        return $this;
    }
}
