<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Business Process Parameters, Business Asset Reference and Transfer details.
 * @subpackage Structs
 */
class Transfer_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: There is a pending event for the asset that should be completed before this asset transaction can be processed. | Reference to an existing Business Asset that will be used for the Transfer transaction.
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Asset_Transfer_Data
     * Meta information extracted from the WSDL
     * - documentation: Data values and flags that will be used to update the Business Asset during the Transfer transaction.
     * @var \StructType\Asset_Transfer_DataType
     */
    public $Asset_Transfer_Data;
    /**
     * Constructor method for Transfer_Asset_RequestType
     * @uses Transfer_Asset_RequestType::setBusiness_Process_Parameters()
     * @uses Transfer_Asset_RequestType::setBusiness_Asset_Reference()
     * @uses Transfer_Asset_RequestType::setAsset_Transfer_Data()
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Asset_Transfer_DataType $asset_Transfer_Data
     */
    public function __construct(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Asset_Transfer_DataType $asset_Transfer_Data = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setAsset_Transfer_Data($asset_Transfer_Data);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Transfer_Asset_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Transfer_Asset_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Asset_Transfer_Data value
     * @return \StructType\Asset_Transfer_DataType|null
     */
    public function getAsset_Transfer_Data()
    {
        return $this->Asset_Transfer_Data;
    }
    /**
     * Set Asset_Transfer_Data value
     * @param \StructType\Asset_Transfer_DataType $asset_Transfer_Data
     * @return \StructType\Transfer_Asset_RequestType
     */
    public function setAsset_Transfer_Data(\StructType\Asset_Transfer_DataType $asset_Transfer_Data = null)
    {
        $this->Asset_Transfer_Data = $asset_Transfer_Data;
        return $this;
    }
}
