<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Timesheet_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Timesheet information to be included in the response.
 * @subpackage Structs
 */
class Timesheet_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Boolean to include/exclude the Timesheet Reference information in the response for Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Worker_Time_Card_Data
     * Meta information extracted from the WSDL
     * - documentation: Boolean to include/exclude the Worker Time Card (Timesheet) information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Worker_Time_Card_Data;
    /**
     * The Include_Time_Card_Daily_Data
     * Meta information extracted from the WSDL
     * - documentation: Boolean to include/exclude time card line details.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Time_Card_Daily_Data;
    /**
     * The Include_Time_In_Time_Out_Data
     * Meta information extracted from the WSDL
     * - documentation: Boolean to include/exclude Time In Time Out details.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Time_In_Time_Out_Data;
    /**
     * Constructor method for Timesheet_Response_GroupType
     * @uses Timesheet_Response_GroupType::setInclude_Reference()
     * @uses Timesheet_Response_GroupType::setInclude_Worker_Time_Card_Data()
     * @uses Timesheet_Response_GroupType::setInclude_Time_Card_Daily_Data()
     * @uses Timesheet_Response_GroupType::setInclude_Time_In_Time_Out_Data()
     * @param bool $include_Reference
     * @param bool $include_Worker_Time_Card_Data
     * @param bool $include_Time_Card_Daily_Data
     * @param bool $include_Time_In_Time_Out_Data
     */
    public function __construct($include_Reference = null, $include_Worker_Time_Card_Data = null, $include_Time_Card_Daily_Data = null, $include_Time_In_Time_Out_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Worker_Time_Card_Data($include_Worker_Time_Card_Data)
            ->setInclude_Time_Card_Daily_Data($include_Time_Card_Daily_Data)
            ->setInclude_Time_In_Time_Out_Data($include_Time_In_Time_Out_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Timesheet_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Worker_Time_Card_Data value
     * @return bool|null
     */
    public function getInclude_Worker_Time_Card_Data()
    {
        return $this->Include_Worker_Time_Card_Data;
    }
    /**
     * Set Include_Worker_Time_Card_Data value
     * @param bool $include_Worker_Time_Card_Data
     * @return \StructType\Timesheet_Response_GroupType
     */
    public function setInclude_Worker_Time_Card_Data($include_Worker_Time_Card_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Worker_Time_Card_Data) && !is_bool($include_Worker_Time_Card_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Worker_Time_Card_Data, true), gettype($include_Worker_Time_Card_Data)), __LINE__);
        }
        $this->Include_Worker_Time_Card_Data = $include_Worker_Time_Card_Data;
        return $this;
    }
    /**
     * Get Include_Time_Card_Daily_Data value
     * @return bool|null
     */
    public function getInclude_Time_Card_Daily_Data()
    {
        return $this->Include_Time_Card_Daily_Data;
    }
    /**
     * Set Include_Time_Card_Daily_Data value
     * @param bool $include_Time_Card_Daily_Data
     * @return \StructType\Timesheet_Response_GroupType
     */
    public function setInclude_Time_Card_Daily_Data($include_Time_Card_Daily_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Time_Card_Daily_Data) && !is_bool($include_Time_Card_Daily_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Time_Card_Daily_Data, true), gettype($include_Time_Card_Daily_Data)), __LINE__);
        }
        $this->Include_Time_Card_Daily_Data = $include_Time_Card_Daily_Data;
        return $this;
    }
    /**
     * Get Include_Time_In_Time_Out_Data value
     * @return bool|null
     */
    public function getInclude_Time_In_Time_Out_Data()
    {
        return $this->Include_Time_In_Time_Out_Data;
    }
    /**
     * Set Include_Time_In_Time_Out_Data value
     * @param bool $include_Time_In_Time_Out_Data
     * @return \StructType\Timesheet_Response_GroupType
     */
    public function setInclude_Time_In_Time_Out_Data($include_Time_In_Time_Out_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Time_In_Time_Out_Data) && !is_bool($include_Time_In_Time_Out_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Time_In_Time_Out_Data, true), gettype($include_Time_In_Time_Out_Data)), __LINE__);
        }
        $this->Include_Time_In_Time_Out_Data = $include_Time_In_Time_Out_Data;
        return $this;
    }
}
