<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxable_Code_Application_NO_INPUT_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing Tax Details data
 * @subpackage Structs
 */
class Taxable_Code_Application_NO_INPUT_DataType extends AbstractStructBase
{
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax applicability.If this is blank and there invoice line has a sales item, Workday will default tax applicability from the sales item. If the invoice line has a tax code then tax applicability
     * is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax code.If this is blank, Workday will default in the default tax code from the invoice header if there is one. If the invoice line has a tax applicability value, Workday will validate that the
     * invoice line also has a tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Tax_Rate_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing Tax Rate data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Application_DataType[]
     */
    public $Tax_Rate_Data;
    /**
     * Constructor method for Taxable_Code_Application_NO_INPUT_DataType
     * @uses Taxable_Code_Application_NO_INPUT_DataType::setTax_Applicability_Reference()
     * @uses Taxable_Code_Application_NO_INPUT_DataType::setTax_Code_Reference()
     * @uses Taxable_Code_Application_NO_INPUT_DataType::setTax_Amount()
     * @uses Taxable_Code_Application_NO_INPUT_DataType::setTax_Rate_Data()
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param float $tax_Amount
     * @param \StructType\Tax_Rate_Application_DataType[] $tax_Rate_Data
     */
    public function __construct(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, $tax_Amount = null, array $tax_Rate_Data = array())
    {
        $this
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Amount($tax_Amount)
            ->setTax_Rate_Data($tax_Rate_Data);
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Taxable_Code_Application_NO_INPUT_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Taxable_Code_Application_NO_INPUT_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Taxable_Code_Application_NO_INPUT_DataType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Tax_Rate_Data value
     * @return \StructType\Tax_Rate_Application_DataType[]|null
     */
    public function getTax_Rate_Data()
    {
        return $this->Tax_Rate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Rate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Rate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Rate_DataForArrayConstraintsFromSetTax_Rate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxable_Code_Application_NO_INPUT_DataTypeTax_Rate_DataItem) {
            // validation for constraint: itemType
            if (!$taxable_Code_Application_NO_INPUT_DataTypeTax_Rate_DataItem instanceof \StructType\Tax_Rate_Application_DataType) {
                $invalidValues[] = is_object($taxable_Code_Application_NO_INPUT_DataTypeTax_Rate_DataItem) ? get_class($taxable_Code_Application_NO_INPUT_DataTypeTax_Rate_DataItem) : sprintf('%s(%s)', gettype($taxable_Code_Application_NO_INPUT_DataTypeTax_Rate_DataItem), var_export($taxable_Code_Application_NO_INPUT_DataTypeTax_Rate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Rate_Data property can only contain items of type \StructType\Tax_Rate_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Rate_Application_DataType[] $tax_Rate_Data
     * @return \StructType\Taxable_Code_Application_NO_INPUT_DataType
     */
    public function setTax_Rate_Data(array $tax_Rate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Rate_DataArrayErrorMessage = self::validateTax_Rate_DataForArrayConstraintsFromSetTax_Rate_Data($tax_Rate_Data))) {
            throw new \InvalidArgumentException($tax_Rate_DataArrayErrorMessage, __LINE__);
        }
        $this->Tax_Rate_Data = $tax_Rate_Data;
        return $this;
    }
    /**
     * Add item to Tax_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Rate_Application_DataType $item
     * @return \StructType\Taxable_Code_Application_NO_INPUT_DataType
     */
    public function addToTax_Rate_Data(\StructType\Tax_Rate_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Rate_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Rate_Data property can only contain items of type \StructType\Tax_Rate_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Rate_Data[] = $item;
        return $this;
    }
}
