<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_Status_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: If Delete is set to true, existing Country for Tax Status must be included. | Tax Status Data WWS element to specify 1 or more Tax Statuses for a company.
 * @subpackage Structs
 */
class Tax_Status_WWS_DataType extends AbstractStructBase
{
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Country for Tax Status
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Transaction_Tax_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company's Transaction Tax Status for the country.
     * - minOccurs: 0
     * @var \StructType\Transaction_Tax_StatusObjectType
     */
    public $Transaction_Tax_Status_Reference;
    /**
     * The Withholding_Tax_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company's Withholding Tax Status for the country.
     * - minOccurs: 0
     * @var \StructType\Withholding_Tax_StatusObjectType
     */
    public $Withholding_Tax_Status_Reference;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to true in order to delete Tax Status.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Tax_Status_WWS_DataType
     * @uses Tax_Status_WWS_DataType::setCountry_Reference()
     * @uses Tax_Status_WWS_DataType::setTransaction_Tax_Status_Reference()
     * @uses Tax_Status_WWS_DataType::setWithholding_Tax_Status_Reference()
     * @uses Tax_Status_WWS_DataType::setDelete()
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\Transaction_Tax_StatusObjectType $transaction_Tax_Status_Reference
     * @param \StructType\Withholding_Tax_StatusObjectType $withholding_Tax_Status_Reference
     * @param bool $delete
     */
    public function __construct(\StructType\CountryObjectType $country_Reference = null, \StructType\Transaction_Tax_StatusObjectType $transaction_Tax_Status_Reference = null, \StructType\Withholding_Tax_StatusObjectType $withholding_Tax_Status_Reference = null, $delete = null)
    {
        $this
            ->setCountry_Reference($country_Reference)
            ->setTransaction_Tax_Status_Reference($transaction_Tax_Status_Reference)
            ->setWithholding_Tax_Status_Reference($withholding_Tax_Status_Reference)
            ->setDelete($delete);
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Tax_Status_WWS_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Transaction_Tax_Status_Reference value
     * @return \StructType\Transaction_Tax_StatusObjectType|null
     */
    public function getTransaction_Tax_Status_Reference()
    {
        return $this->Transaction_Tax_Status_Reference;
    }
    /**
     * Set Transaction_Tax_Status_Reference value
     * @param \StructType\Transaction_Tax_StatusObjectType $transaction_Tax_Status_Reference
     * @return \StructType\Tax_Status_WWS_DataType
     */
    public function setTransaction_Tax_Status_Reference(\StructType\Transaction_Tax_StatusObjectType $transaction_Tax_Status_Reference = null)
    {
        $this->Transaction_Tax_Status_Reference = $transaction_Tax_Status_Reference;
        return $this;
    }
    /**
     * Get Withholding_Tax_Status_Reference value
     * @return \StructType\Withholding_Tax_StatusObjectType|null
     */
    public function getWithholding_Tax_Status_Reference()
    {
        return $this->Withholding_Tax_Status_Reference;
    }
    /**
     * Set Withholding_Tax_Status_Reference value
     * @param \StructType\Withholding_Tax_StatusObjectType $withholding_Tax_Status_Reference
     * @return \StructType\Tax_Status_WWS_DataType
     */
    public function setWithholding_Tax_Status_Reference(\StructType\Withholding_Tax_StatusObjectType $withholding_Tax_Status_Reference = null)
    {
        $this->Withholding_Tax_Status_Reference = $withholding_Tax_Status_Reference;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Tax_Status_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
