<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_ID_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Tax ID Type used is mutually exclusive with other Tax ID Types in the set. Only one can be used for the country. | The Tax ID Type selected for this Tax ID cannot be used in this webservice. | Transaction Tax ID can only be
 * selected when the Tax ID Type is selected as a Transaction Tax ID. Otherwise it must be blank. | Enter the Identification # for the Transaction Tax ID. | If Delete is set to true, existing Tax ID Type must be included. | Tax ID Data WWS element to
 * specify 1 or more Tax IDs for a company.
 * @subpackage Structs
 */
class Tax_ID_WWS_DataType extends AbstractStructBase
{
    /**
     * The Tax_ID_Text
     * Meta information extracted from the WSDL
     * - documentation: Enter the Tax ID value for the respective Tax Type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tax_ID_Text;
    /**
     * The Tax_ID_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter the Tax Type tied to the Tax ID value entered.
     * @var \StructType\Tax_ID_TypeObjectType
     */
    public $Tax_ID_Type_Reference;
    /**
     * The Transaction_Tax_ID
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Tax ID is used as the Transaction Tax ID for the country.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Transaction_Tax_ID;
    /**
     * The Primary_Tax_ID
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Tax ID is used as the Primary Tax ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Primary_Tax_ID;
    /**
     * The Validation_Service_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Validation_Status_DataType[]
     */
    public $Validation_Service_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to true in order to delete Tax ID.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Tax_ID_WWS_DataType
     * @uses Tax_ID_WWS_DataType::setTax_ID_Text()
     * @uses Tax_ID_WWS_DataType::setTax_ID_Type_Reference()
     * @uses Tax_ID_WWS_DataType::setTransaction_Tax_ID()
     * @uses Tax_ID_WWS_DataType::setPrimary_Tax_ID()
     * @uses Tax_ID_WWS_DataType::setValidation_Service_Data()
     * @uses Tax_ID_WWS_DataType::setDelete()
     * @param string $tax_ID_Text
     * @param \StructType\Tax_ID_TypeObjectType $tax_ID_Type_Reference
     * @param bool $transaction_Tax_ID
     * @param bool $primary_Tax_ID
     * @param \StructType\Validation_Status_DataType[] $validation_Service_Data
     * @param bool $delete
     */
    public function __construct($tax_ID_Text = null, \StructType\Tax_ID_TypeObjectType $tax_ID_Type_Reference = null, $transaction_Tax_ID = null, $primary_Tax_ID = null, array $validation_Service_Data = array(), $delete = null)
    {
        $this
            ->setTax_ID_Text($tax_ID_Text)
            ->setTax_ID_Type_Reference($tax_ID_Type_Reference)
            ->setTransaction_Tax_ID($transaction_Tax_ID)
            ->setPrimary_Tax_ID($primary_Tax_ID)
            ->setValidation_Service_Data($validation_Service_Data)
            ->setDelete($delete);
    }
    /**
     * Get Tax_ID_Text value
     * @return string|null
     */
    public function getTax_ID_Text()
    {
        return $this->Tax_ID_Text;
    }
    /**
     * Set Tax_ID_Text value
     * @param string $tax_ID_Text
     * @return \StructType\Tax_ID_WWS_DataType
     */
    public function setTax_ID_Text($tax_ID_Text = null)
    {
        // validation for constraint: string
        if (!is_null($tax_ID_Text) && !is_string($tax_ID_Text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_ID_Text, true), gettype($tax_ID_Text)), __LINE__);
        }
        $this->Tax_ID_Text = $tax_ID_Text;
        return $this;
    }
    /**
     * Get Tax_ID_Type_Reference value
     * @return \StructType\Tax_ID_TypeObjectType|null
     */
    public function getTax_ID_Type_Reference()
    {
        return $this->Tax_ID_Type_Reference;
    }
    /**
     * Set Tax_ID_Type_Reference value
     * @param \StructType\Tax_ID_TypeObjectType $tax_ID_Type_Reference
     * @return \StructType\Tax_ID_WWS_DataType
     */
    public function setTax_ID_Type_Reference(\StructType\Tax_ID_TypeObjectType $tax_ID_Type_Reference = null)
    {
        $this->Tax_ID_Type_Reference = $tax_ID_Type_Reference;
        return $this;
    }
    /**
     * Get Transaction_Tax_ID value
     * @return bool|null
     */
    public function getTransaction_Tax_ID()
    {
        return $this->Transaction_Tax_ID;
    }
    /**
     * Set Transaction_Tax_ID value
     * @param bool $transaction_Tax_ID
     * @return \StructType\Tax_ID_WWS_DataType
     */
    public function setTransaction_Tax_ID($transaction_Tax_ID = null)
    {
        // validation for constraint: boolean
        if (!is_null($transaction_Tax_ID) && !is_bool($transaction_Tax_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($transaction_Tax_ID, true), gettype($transaction_Tax_ID)), __LINE__);
        }
        $this->Transaction_Tax_ID = $transaction_Tax_ID;
        return $this;
    }
    /**
     * Get Primary_Tax_ID value
     * @return bool|null
     */
    public function getPrimary_Tax_ID()
    {
        return $this->Primary_Tax_ID;
    }
    /**
     * Set Primary_Tax_ID value
     * @param bool $primary_Tax_ID
     * @return \StructType\Tax_ID_WWS_DataType
     */
    public function setPrimary_Tax_ID($primary_Tax_ID = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary_Tax_ID) && !is_bool($primary_Tax_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary_Tax_ID, true), gettype($primary_Tax_ID)), __LINE__);
        }
        $this->Primary_Tax_ID = $primary_Tax_ID;
        return $this;
    }
    /**
     * Get Validation_Service_Data value
     * @return \StructType\Validation_Status_DataType[]|null
     */
    public function getValidation_Service_Data()
    {
        return $this->Validation_Service_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setValidation_Service_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValidation_Service_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValidation_Service_DataForArrayConstraintsFromSetValidation_Service_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_ID_WWS_DataTypeValidation_Service_DataItem) {
            // validation for constraint: itemType
            if (!$tax_ID_WWS_DataTypeValidation_Service_DataItem instanceof \StructType\Validation_Status_DataType) {
                $invalidValues[] = is_object($tax_ID_WWS_DataTypeValidation_Service_DataItem) ? get_class($tax_ID_WWS_DataTypeValidation_Service_DataItem) : sprintf('%s(%s)', gettype($tax_ID_WWS_DataTypeValidation_Service_DataItem), var_export($tax_ID_WWS_DataTypeValidation_Service_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Validation_Service_Data property can only contain items of type \StructType\Validation_Status_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Validation_Service_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Validation_Status_DataType[] $validation_Service_Data
     * @return \StructType\Tax_ID_WWS_DataType
     */
    public function setValidation_Service_Data(array $validation_Service_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($validation_Service_DataArrayErrorMessage = self::validateValidation_Service_DataForArrayConstraintsFromSetValidation_Service_Data($validation_Service_Data))) {
            throw new \InvalidArgumentException($validation_Service_DataArrayErrorMessage, __LINE__);
        }
        $this->Validation_Service_Data = $validation_Service_Data;
        return $this;
    }
    /**
     * Add item to Validation_Service_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Validation_Status_DataType $item
     * @return \StructType\Tax_ID_WWS_DataType
     */
    public function addToValidation_Service_Data(\StructType\Validation_Status_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Validation_Status_DataType) {
            throw new \InvalidArgumentException(sprintf('The Validation_Service_Data property can only contain items of type \StructType\Validation_Status_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Validation_Service_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Tax_ID_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
