<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Order_Contract_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Order Contract Reference Instance and Supplier Order Contract Data
 * @subpackage Structs
 */
class Supplier_Order_Contract_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Order_Contract
     * Meta information extracted from the WSDL
     * - documentation: Contains data for adding a Supplier Order Contract
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Order_ContractType[]
     */
    public $Supplier_Order_Contract;
    /**
     * Constructor method for Supplier_Order_Contract_Response_DataType
     * @uses Supplier_Order_Contract_Response_DataType::setSupplier_Order_Contract()
     * @param \StructType\Supplier_Order_ContractType[] $supplier_Order_Contract
     */
    public function __construct(array $supplier_Order_Contract = array())
    {
        $this
            ->setSupplier_Order_Contract($supplier_Order_Contract);
    }
    /**
     * Get Supplier_Order_Contract value
     * @return \StructType\Supplier_Order_ContractType[]|null
     */
    public function getSupplier_Order_Contract()
    {
        return $this->Supplier_Order_Contract;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Order_Contract method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Order_Contract method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Order_ContractForArrayConstraintsFromSetSupplier_Order_Contract(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Order_Contract_Response_DataTypeSupplier_Order_ContractItem) {
            // validation for constraint: itemType
            if (!$supplier_Order_Contract_Response_DataTypeSupplier_Order_ContractItem instanceof \StructType\Supplier_Order_ContractType) {
                $invalidValues[] = is_object($supplier_Order_Contract_Response_DataTypeSupplier_Order_ContractItem) ? get_class($supplier_Order_Contract_Response_DataTypeSupplier_Order_ContractItem) : sprintf('%s(%s)', gettype($supplier_Order_Contract_Response_DataTypeSupplier_Order_ContractItem), var_export($supplier_Order_Contract_Response_DataTypeSupplier_Order_ContractItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Order_Contract property can only contain items of type \StructType\Supplier_Order_ContractType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Order_Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Order_ContractType[] $supplier_Order_Contract
     * @return \StructType\Supplier_Order_Contract_Response_DataType
     */
    public function setSupplier_Order_Contract(array $supplier_Order_Contract = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Order_ContractArrayErrorMessage = self::validateSupplier_Order_ContractForArrayConstraintsFromSetSupplier_Order_Contract($supplier_Order_Contract))) {
            throw new \InvalidArgumentException($supplier_Order_ContractArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Order_Contract = $supplier_Order_Contract;
        return $this;
    }
    /**
     * Add item to Supplier_Order_Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Order_ContractType $item
     * @return \StructType\Supplier_Order_Contract_Response_DataType
     */
    public function addToSupplier_Order_Contract(\StructType\Supplier_Order_ContractType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Order_ContractType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Order_Contract property can only contain items of type \StructType\Supplier_Order_ContractType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Order_Contract[] = $item;
        return $this;
    }
}
