<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Item_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing references to Supplier Item
 * @subpackage Structs
 */
class Supplier_Item_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to Supplier Item
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Item_Details_AbstractObjectType[]
     */
    public $Supplier_Item_Reference;
    /**
     * Constructor method for Supplier_Item_Request_ReferencesType
     * @uses Supplier_Item_Request_ReferencesType::setSupplier_Item_Reference()
     * @param \StructType\Supplier_Item_Details_AbstractObjectType[] $supplier_Item_Reference
     */
    public function __construct(array $supplier_Item_Reference = array())
    {
        $this
            ->setSupplier_Item_Reference($supplier_Item_Reference);
    }
    /**
     * Get Supplier_Item_Reference value
     * @return \StructType\Supplier_Item_Details_AbstractObjectType[]|null
     */
    public function getSupplier_Item_Reference()
    {
        return $this->Supplier_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Item_ReferenceForArrayConstraintsFromSetSupplier_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Request_ReferencesTypeSupplier_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Request_ReferencesTypeSupplier_Item_ReferenceItem instanceof \StructType\Supplier_Item_Details_AbstractObjectType) {
                $invalidValues[] = is_object($supplier_Item_Request_ReferencesTypeSupplier_Item_ReferenceItem) ? get_class($supplier_Item_Request_ReferencesTypeSupplier_Item_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Request_ReferencesTypeSupplier_Item_ReferenceItem), var_export($supplier_Item_Request_ReferencesTypeSupplier_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item_Reference property can only contain items of type \StructType\Supplier_Item_Details_AbstractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Details_AbstractObjectType[] $supplier_Item_Reference
     * @return \StructType\Supplier_Item_Request_ReferencesType
     */
    public function setSupplier_Item_Reference(array $supplier_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Item_ReferenceArrayErrorMessage = self::validateSupplier_Item_ReferenceForArrayConstraintsFromSetSupplier_Item_Reference($supplier_Item_Reference))) {
            throw new \InvalidArgumentException($supplier_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item_Reference = $supplier_Item_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Details_AbstractObjectType $item
     * @return \StructType\Supplier_Item_Request_ReferencesType
     */
    public function addToSupplier_Item_Reference(\StructType\Supplier_Item_Details_AbstractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Item_Details_AbstractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item_Reference property can only contain items of type \StructType\Supplier_Item_Details_AbstractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item_Reference[] = $item;
        return $this;
    }
}
