<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Item_Price_Update__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This validation is ignored if for a Catalog Item, since any Supplier Contracts entered in payload are ignored. | Element containing a Supplier Item Price Update data item.Notes on total inactivation or future dated inactivation of
 * Supplier Item pricing: 1. If you want to inactivate a Supplier Item's pricing across all dates, all of its Supplier Item Unit of Measure Data (the pricing related to Unit Of Measure, including historical and future dated) associated with the Supplier
 * Item must be marked Inactive=1 and Default=0 (not a default UOM). One row for each Effective Date, Unit of Measure, and Just In Time=(1 or 0) combination that exists.2. If you want to inactivate a Supplier Item for a specific date in the future, you
 * must send a Supplier Item Unit of Measure Data for every Unit of Measure used by that Supplier Item, using that same (future) Effective Date and marked Inactive=1 and default=0. If there are Just In Time Units of Measure, additional rows must be sent
 * to inactivate those as well.Similarly, if there is pricing data already saved for the Supplier Item for any other date(s) after that future date, you must send rows for those date(s), inactivating and setting them as non-default.3. You must also mark
 * all of its Advanced Pricing rules for the affected dates (if any) inactive, or else errors will occur.5. If you are not using the supplier item in the future, it is strongly recommended to also set the Sourcing Priority to 0 at that time so the
 * Sourcing Priority number is available for another Supplier.
 * @subpackage Structs
 */
class Supplier_Item_Price_Update__HV__DataType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Active Supplier from within Workday. If a supplier is also provided within the supplier item price update header, then this supplier must match the header's supplier.
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item ID for the supplier item. In order to uniquely identify the target item, either the Purchase Item ID, Catalog Item ID or Manufacturer Part Number (along with Manufacturer) must be supplied.
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Catalog_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: ID for the linked catalog item. In order to uniquely identify the target item, either the Purchase Item ID, Catalog Item ID or Manufacturer Part Number (along with Manufacturer) must be supplied.
     * - minOccurs: 0
     * @var \StructType\Catalog_ItemObjectType
     */
    public $Catalog_Item_Reference;
    /**
     * The Manufacturer_Part_Number
     * Meta information extracted from the WSDL
     * - documentation: Manufacturer Part Number (also know as Manufacturer Part ID or MPN). In order to uniquely identify the target item, either the Purchase Item ID, Catalog Item ID or Manufacturer Part Number (along with Manufacturer) must be supplied.
     * Manufacturer Part Number and Manufacturer are used to identify a Purchase Item. It is valid only for Import Supplier Item. Get Supplier Item will not return any value in this field since a Purchase Item reference is already provided.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Manufacturer_Part_Number;
    /**
     * The Manufacturer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Manufacturer. Used in association with Manufacturer Part Number to identify a Purchase Item.It is valid only for Import Supplier Item. Get Supplier Item will not return any value in this field since a Purchase Item reference is
     * already provided.
     * - minOccurs: 0
     * @var \StructType\ManufacturerObjectType
     */
    public $Manufacturer_Reference;
    /**
     * The Supplier_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Supplier item identifier
     * - maxOccurs: 1
     * @var string
     */
    public $Supplier_Item_Identifier;
    /**
     * The Item_Name
     * Meta information extracted from the WSDL
     * - documentation: Item name. Informational only. Any value entered here will be ignored. You can leave blank since this is derived directly from the Purchase Item reference or Catalog Item reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Name;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Supplier item description. Optional. If left blank, the description of the Catalog Item (if present) will be used. If blank and no Catalog Item, the Purchase Item description will be used. Any value set here will override the
     * Purchase Item's description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier contracts to be used as default on transactions where item is applied when a contract is not already entered. The contracts in this list should not overlap in date range with each other if they are for the same company,
     * since there can only be a single contract defaulted at a time. Note: for Import Supplier Items, Supplier Contracts are not used and contract specific error validations are skipped if there is a Catalog Item reference. You cannot modify any contract
     * information for a Catalog Item reference using this request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_AbstractObjectType[]
     */
    public $Supplier_Contract_Reference;
    /**
     * The Item_URL
     * Meta information extracted from the WSDL
     * - documentation: Item URL. Cannot be changed if there is a linked catalog item. Any value entered in this field will be ignored for Import with a linked catalog item, and the catalog item's URL will be unchanged. For other supplier item without a
     * linked catalog item, the URL can be changed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_URL;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency used by the supplier item
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Sourcing_Priority
     * Meta information extracted from the WSDL
     * - documentation: Sourcing Priority of the Catalog Item. | Sourcing priority for the supplier item
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 16
     * @var float
     */
    public $Sourcing_Priority;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Calculate_Price_based_on_Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: Select to calculate price for Ordering and Just in Time UOMs based on the price entered for the Default Unit of Measure. When advanced pricing applies to a transaction with an undefined UOM, we calculate the price based on the
     * conversion factor of the price rule. This enables you to load 1 price for 1 UOM.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Calculate_Price_based_on_Conversion_Factor;
    /**
     * The Supplier_Item_Unit_of_Measure_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier item UOM level data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType[]
     */
    public $Supplier_Item_Unit_of_Measure_Data;
    /**
     * The Advanced_Pricing_Data
     * Meta information extracted from the WSDL
     * - documentation: Advanced Pricing rule data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Item_Advanced_Pricing_DataType[]
     */
    public $Advanced_Pricing_Data;
    /**
     * Constructor method for Supplier_Item_Price_Update__HV__DataType
     * @uses Supplier_Item_Price_Update__HV__DataType::setSupplier_Reference()
     * @uses Supplier_Item_Price_Update__HV__DataType::setPurchase_Item_Reference()
     * @uses Supplier_Item_Price_Update__HV__DataType::setCatalog_Item_Reference()
     * @uses Supplier_Item_Price_Update__HV__DataType::setManufacturer_Part_Number()
     * @uses Supplier_Item_Price_Update__HV__DataType::setManufacturer_Reference()
     * @uses Supplier_Item_Price_Update__HV__DataType::setSupplier_Item_Identifier()
     * @uses Supplier_Item_Price_Update__HV__DataType::setItem_Name()
     * @uses Supplier_Item_Price_Update__HV__DataType::setItem_Description()
     * @uses Supplier_Item_Price_Update__HV__DataType::setSupplier_Contract_Reference()
     * @uses Supplier_Item_Price_Update__HV__DataType::setItem_URL()
     * @uses Supplier_Item_Price_Update__HV__DataType::setCurrency_Reference()
     * @uses Supplier_Item_Price_Update__HV__DataType::setSourcing_Priority()
     * @uses Supplier_Item_Price_Update__HV__DataType::setLead_Time()
     * @uses Supplier_Item_Price_Update__HV__DataType::setCalculate_Price_based_on_Conversion_Factor()
     * @uses Supplier_Item_Price_Update__HV__DataType::setSupplier_Item_Unit_of_Measure_Data()
     * @uses Supplier_Item_Price_Update__HV__DataType::setAdvanced_Pricing_Data()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @param string $manufacturer_Part_Number
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     * @param string $supplier_Item_Identifier
     * @param string $item_Name
     * @param string $item_Description
     * @param \StructType\Supplier_Contract_AbstractObjectType[] $supplier_Contract_Reference
     * @param string $item_URL
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $sourcing_Priority
     * @param float $lead_Time
     * @param bool $calculate_Price_based_on_Conversion_Factor
     * @param \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType[] $supplier_Item_Unit_of_Measure_Data
     * @param \StructType\Supplier_Item_Advanced_Pricing_DataType[] $advanced_Pricing_Data
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, \StructType\Catalog_ItemObjectType $catalog_Item_Reference = null, $manufacturer_Part_Number = null, \StructType\ManufacturerObjectType $manufacturer_Reference = null, $supplier_Item_Identifier = null, $item_Name = null, $item_Description = null, array $supplier_Contract_Reference = array(), $item_URL = null, \StructType\CurrencyObjectType $currency_Reference = null, $sourcing_Priority = null, $lead_Time = null, $calculate_Price_based_on_Conversion_Factor = null, array $supplier_Item_Unit_of_Measure_Data = array(), array $advanced_Pricing_Data = array())
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setCatalog_Item_Reference($catalog_Item_Reference)
            ->setManufacturer_Part_Number($manufacturer_Part_Number)
            ->setManufacturer_Reference($manufacturer_Reference)
            ->setSupplier_Item_Identifier($supplier_Item_Identifier)
            ->setItem_Name($item_Name)
            ->setItem_Description($item_Description)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setItem_URL($item_URL)
            ->setCurrency_Reference($currency_Reference)
            ->setSourcing_Priority($sourcing_Priority)
            ->setLead_Time($lead_Time)
            ->setCalculate_Price_based_on_Conversion_Factor($calculate_Price_based_on_Conversion_Factor)
            ->setSupplier_Item_Unit_of_Measure_Data($supplier_Item_Unit_of_Measure_Data)
            ->setAdvanced_Pricing_Data($advanced_Pricing_Data);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Catalog_Item_Reference value
     * @return \StructType\Catalog_ItemObjectType|null
     */
    public function getCatalog_Item_Reference()
    {
        return $this->Catalog_Item_Reference;
    }
    /**
     * Set Catalog_Item_Reference value
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setCatalog_Item_Reference(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null)
    {
        $this->Catalog_Item_Reference = $catalog_Item_Reference;
        return $this;
    }
    /**
     * Get Manufacturer_Part_Number value
     * @return string|null
     */
    public function getManufacturer_Part_Number()
    {
        return $this->Manufacturer_Part_Number;
    }
    /**
     * Set Manufacturer_Part_Number value
     * @param string $manufacturer_Part_Number
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setManufacturer_Part_Number($manufacturer_Part_Number = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer_Part_Number) && !is_string($manufacturer_Part_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer_Part_Number, true), gettype($manufacturer_Part_Number)), __LINE__);
        }
        $this->Manufacturer_Part_Number = $manufacturer_Part_Number;
        return $this;
    }
    /**
     * Get Manufacturer_Reference value
     * @return \StructType\ManufacturerObjectType|null
     */
    public function getManufacturer_Reference()
    {
        return $this->Manufacturer_Reference;
    }
    /**
     * Set Manufacturer_Reference value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setManufacturer_Reference(\StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this->Manufacturer_Reference = $manufacturer_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Identifier value
     * @return string|null
     */
    public function getSupplier_Item_Identifier()
    {
        return $this->Supplier_Item_Identifier;
    }
    /**
     * Set Supplier_Item_Identifier value
     * @param string $supplier_Item_Identifier
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setSupplier_Item_Identifier($supplier_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Identifier) && !is_string($supplier_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Identifier, true), gettype($supplier_Item_Identifier)), __LINE__);
        }
        $this->Supplier_Item_Identifier = $supplier_Item_Identifier;
        return $this;
    }
    /**
     * Get Item_Name value
     * @return string|null
     */
    public function getItem_Name()
    {
        return $this->Item_Name;
    }
    /**
     * Set Item_Name value
     * @param string $item_Name
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setItem_Name($item_Name = null)
    {
        // validation for constraint: string
        if (!is_null($item_Name) && !is_string($item_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Name, true), gettype($item_Name)), __LINE__);
        }
        $this->Item_Name = $item_Name;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_Contract_AbstractObjectType[]|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Price_Update_HV_DataTypeSupplier_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Price_Update_HV_DataTypeSupplier_Contract_ReferenceItem instanceof \StructType\Supplier_Contract_AbstractObjectType) {
                $invalidValues[] = is_object($supplier_Item_Price_Update_HV_DataTypeSupplier_Contract_ReferenceItem) ? get_class($supplier_Item_Price_Update_HV_DataTypeSupplier_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Price_Update_HV_DataTypeSupplier_Contract_ReferenceItem), var_export($supplier_Item_Price_Update_HV_DataTypeSupplier_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_Contract_AbstractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_AbstractObjectType[] $supplier_Contract_Reference
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setSupplier_Contract_Reference(array $supplier_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_ReferenceArrayErrorMessage = self::validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference($supplier_Contract_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_AbstractObjectType $item
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function addToSupplier_Contract_Reference(\StructType\Supplier_Contract_AbstractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_AbstractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_Contract_AbstractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Reference[] = $item;
        return $this;
    }
    /**
     * Get Item_URL value
     * @return string|null
     */
    public function getItem_URL()
    {
        return $this->Item_URL;
    }
    /**
     * Set Item_URL value
     * @param string $item_URL
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setItem_URL($item_URL = null)
    {
        // validation for constraint: string
        if (!is_null($item_URL) && !is_string($item_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_URL, true), gettype($item_URL)), __LINE__);
        }
        $this->Item_URL = $item_URL;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Sourcing_Priority value
     * @return float|null
     */
    public function getSourcing_Priority()
    {
        return $this->Sourcing_Priority;
    }
    /**
     * Set Sourcing_Priority value
     * @param float $sourcing_Priority
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setSourcing_Priority($sourcing_Priority = null)
    {
        // validation for constraint: float
        if (!is_null($sourcing_Priority) && !(is_float($sourcing_Priority) || is_numeric($sourcing_Priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sourcing_Priority, true), gettype($sourcing_Priority)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($sourcing_Priority) && mb_strlen(mb_substr($sourcing_Priority, false !== mb_strpos($sourcing_Priority, '.') ? mb_strpos($sourcing_Priority, '.') + 1 : mb_strlen($sourcing_Priority))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($sourcing_Priority, true), mb_strlen(mb_substr($sourcing_Priority, mb_strpos($sourcing_Priority, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sourcing_Priority) && $sourcing_Priority < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sourcing_Priority, true)), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($sourcing_Priority) && mb_strlen(preg_replace('/(\D)/', '', $sourcing_Priority)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($sourcing_Priority, true), mb_strlen(preg_replace('/(\D)/', '', $sourcing_Priority))), __LINE__);
        }
        $this->Sourcing_Priority = $sourcing_Priority;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Calculate_Price_based_on_Conversion_Factor value
     * @return bool|null
     */
    public function getCalculate_Price_based_on_Conversion_Factor()
    {
        return $this->Calculate_Price_based_on_Conversion_Factor;
    }
    /**
     * Set Calculate_Price_based_on_Conversion_Factor value
     * @param bool $calculate_Price_based_on_Conversion_Factor
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setCalculate_Price_based_on_Conversion_Factor($calculate_Price_based_on_Conversion_Factor = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculate_Price_based_on_Conversion_Factor) && !is_bool($calculate_Price_based_on_Conversion_Factor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculate_Price_based_on_Conversion_Factor, true), gettype($calculate_Price_based_on_Conversion_Factor)), __LINE__);
        }
        $this->Calculate_Price_based_on_Conversion_Factor = $calculate_Price_based_on_Conversion_Factor;
        return $this;
    }
    /**
     * Get Supplier_Item_Unit_of_Measure_Data value
     * @return \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType[]|null
     */
    public function getSupplier_Item_Unit_of_Measure_Data()
    {
        return $this->Supplier_Item_Unit_of_Measure_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item_Unit_of_Measure_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item_Unit_of_Measure_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Item_Unit_of_Measure_DataForArrayConstraintsFromSetSupplier_Item_Unit_of_Measure_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Price_Update_HV_DataTypeSupplier_Item_Unit_of_Measure_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Price_Update_HV_DataTypeSupplier_Item_Unit_of_Measure_DataItem instanceof \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType) {
                $invalidValues[] = is_object($supplier_Item_Price_Update_HV_DataTypeSupplier_Item_Unit_of_Measure_DataItem) ? get_class($supplier_Item_Price_Update_HV_DataTypeSupplier_Item_Unit_of_Measure_DataItem) : sprintf('%s(%s)', gettype($supplier_Item_Price_Update_HV_DataTypeSupplier_Item_Unit_of_Measure_DataItem), var_export($supplier_Item_Price_Update_HV_DataTypeSupplier_Item_Unit_of_Measure_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item_Unit_of_Measure_Data property can only contain items of type \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item_Unit_of_Measure_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType[] $supplier_Item_Unit_of_Measure_Data
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setSupplier_Item_Unit_of_Measure_Data(array $supplier_Item_Unit_of_Measure_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Item_Unit_of_Measure_DataArrayErrorMessage = self::validateSupplier_Item_Unit_of_Measure_DataForArrayConstraintsFromSetSupplier_Item_Unit_of_Measure_Data($supplier_Item_Unit_of_Measure_Data))) {
            throw new \InvalidArgumentException($supplier_Item_Unit_of_Measure_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item_Unit_of_Measure_Data = $supplier_Item_Unit_of_Measure_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Item_Unit_of_Measure_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType $item
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function addToSupplier_Item_Unit_of_Measure_Data(\StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item_Unit_of_Measure_Data property can only contain items of type \StructType\Supplier_Item_Price_Update_Unit_of_Measure_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item_Unit_of_Measure_Data[] = $item;
        return $this;
    }
    /**
     * Get Advanced_Pricing_Data value
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType[]|null
     */
    public function getAdvanced_Pricing_Data()
    {
        return $this->Advanced_Pricing_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdvanced_Pricing_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdvanced_Pricing_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdvanced_Pricing_DataForArrayConstraintsFromSetAdvanced_Pricing_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Price_Update_HV_DataTypeAdvanced_Pricing_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Price_Update_HV_DataTypeAdvanced_Pricing_DataItem instanceof \StructType\Supplier_Item_Advanced_Pricing_DataType) {
                $invalidValues[] = is_object($supplier_Item_Price_Update_HV_DataTypeAdvanced_Pricing_DataItem) ? get_class($supplier_Item_Price_Update_HV_DataTypeAdvanced_Pricing_DataItem) : sprintf('%s(%s)', gettype($supplier_Item_Price_Update_HV_DataTypeAdvanced_Pricing_DataItem), var_export($supplier_Item_Price_Update_HV_DataTypeAdvanced_Pricing_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Advanced_Pricing_Data property can only contain items of type \StructType\Supplier_Item_Advanced_Pricing_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Advanced_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Advanced_Pricing_DataType[] $advanced_Pricing_Data
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function setAdvanced_Pricing_Data(array $advanced_Pricing_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($advanced_Pricing_DataArrayErrorMessage = self::validateAdvanced_Pricing_DataForArrayConstraintsFromSetAdvanced_Pricing_Data($advanced_Pricing_Data))) {
            throw new \InvalidArgumentException($advanced_Pricing_DataArrayErrorMessage, __LINE__);
        }
        $this->Advanced_Pricing_Data = $advanced_Pricing_Data;
        return $this;
    }
    /**
     * Add item to Advanced_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Advanced_Pricing_DataType $item
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType
     */
    public function addToAdvanced_Pricing_Data(\StructType\Supplier_Item_Advanced_Pricing_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Item_Advanced_Pricing_DataType) {
            throw new \InvalidArgumentException(sprintf('The Advanced_Pricing_Data property can only contain items of type \StructType\Supplier_Item_Advanced_Pricing_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Advanced_Pricing_Data[] = $item;
        return $this;
    }
}
