<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing criteria for Supplier Invoice Work Queue Tag Request
 * @subpackage Structs
 */
class Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name for the supplier invoice work queue tag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Urgent
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier invoice work queue tag should appear at the top of the supplier invoice work queue
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Urgent;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier invoice work queue tag is inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType
     * @uses Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType::setName()
     * @uses Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType::setUrgent()
     * @uses Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType::setInactive()
     * @param string $name
     * @param bool $urgent
     * @param bool $inactive
     */
    public function __construct($name = null, $urgent = null, $inactive = null)
    {
        $this
            ->setName($name)
            ->setUrgent($urgent)
            ->setInactive($inactive);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Urgent value
     * @return bool|null
     */
    public function getUrgent()
    {
        return $this->Urgent;
    }
    /**
     * Set Urgent value
     * @param bool $urgent
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType
     */
    public function setUrgent($urgent = null)
    {
        // validation for constraint: boolean
        if (!is_null($urgent) && !is_bool($urgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($urgent, true), gettype($urgent)), __LINE__);
        }
        $this->Urgent = $urgent;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Request_CriteriaType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
