<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Supplier_Invoice_System_Validation_Configuration_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for Supplier Invoice System Validation Configurations
 * @subpackage Structs
 */
class Supplier_Invoice_System_Validation_Configuration_ReferencesType extends AbstractStructBase
{
    /**
     * The Request_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice System Validation Configuration Reference
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType[]
     */
    public $Request_Reference;
    /**
     * Constructor method for
     * Supplier_Invoice_System_Validation_Configuration_ReferencesType
     * @uses Supplier_Invoice_System_Validation_Configuration_ReferencesType::setRequest_Reference()
     * @param \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType[] $request_Reference
     */
    public function __construct(array $request_Reference = array())
    {
        $this
            ->setRequest_Reference($request_Reference);
    }
    /**
     * Get Request_Reference value
     * @return \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType[]|null
     */
    public function getRequest_Reference()
    {
        return $this->Request_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_ReferenceForArrayConstraintsFromSetRequest_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_System_Validation_Configuration_ReferencesTypeRequest_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_System_Validation_Configuration_ReferencesTypeRequest_ReferenceItem instanceof \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_System_Validation_Configuration_ReferencesTypeRequest_ReferenceItem) ? get_class($supplier_Invoice_System_Validation_Configuration_ReferencesTypeRequest_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_System_Validation_Configuration_ReferencesTypeRequest_ReferenceItem), var_export($supplier_Invoice_System_Validation_Configuration_ReferencesTypeRequest_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_Reference property can only contain items of type \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType[] $request_Reference
     * @return \StructType\Supplier_Invoice_System_Validation_Configuration_ReferencesType
     */
    public function setRequest_Reference(array $request_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($request_ReferenceArrayErrorMessage = self::validateRequest_ReferenceForArrayConstraintsFromSetRequest_Reference($request_Reference))) {
            throw new \InvalidArgumentException($request_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Request_Reference = $request_Reference;
        return $this;
    }
    /**
     * Add item to Request_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType $item
     * @return \StructType\Supplier_Invoice_System_Validation_Configuration_ReferencesType
     */
    public function addToRequest_Reference(\StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Request_Reference property can only contain items of type \StructType\Supplier_Invoice_System_Validation_ConfigurationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_Reference[] = $item;
        return $this;
    }
}
