<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Schedule_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains request reference, criteria, filter for getting Supplier Invoice Schedule data.
 * @subpackage Structs
 */
class Supplier_Invoice_Schedule_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Contract
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType[]
     */
    public $Supplier_Contract_Reference;
    /**
     * The Schedule_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Schedule Status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Schedule_Status_Reference;
    /**
     * The Frequency_Behavior_Reference
     * Meta information extracted from the WSDL
     * - documentation: A mapping to the internal Workday frequencies functionality. The values for this reference can be found using the "Integration IDs" task within the Workday application (Business Object = Frequency Behavior)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Frequency_BehaviorObjectType[]
     */
    public $Frequency_Behavior_Reference;
    /**
     * The Schedule_Distribution_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supplier Contract type Schedule Distribution Method. Valid values are: - Custom (CUSTOM). - Defined Installment (RECURRING). - Spread Even (EVEN).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Schedule_Distribution_MethodObjectType[]
     */
    public $Schedule_Distribution_Method_Reference;
    /**
     * Constructor method for Supplier_Invoice_Schedule_Request_CriteriaType
     * @uses Supplier_Invoice_Schedule_Request_CriteriaType::setCompany_Reference()
     * @uses Supplier_Invoice_Schedule_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Invoice_Schedule_Request_CriteriaType::setSupplier_Contract_Reference()
     * @uses Supplier_Invoice_Schedule_Request_CriteriaType::setSchedule_Status_Reference()
     * @uses Supplier_Invoice_Schedule_Request_CriteriaType::setFrequency_Behavior_Reference()
     * @uses Supplier_Invoice_Schedule_Request_CriteriaType::setSchedule_Distribution_Method_Reference()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @param \StructType\Document_StatusObjectType[] $schedule_Status_Reference
     * @param \StructType\Frequency_BehaviorObjectType[] $frequency_Behavior_Reference
     * @param \StructType\Schedule_Distribution_MethodObjectType[] $schedule_Distribution_Method_Reference
     */
    public function __construct(array $company_Reference = array(), array $supplier_Reference = array(), array $supplier_Contract_Reference = array(), array $schedule_Status_Reference = array(), array $frequency_Behavior_Reference = array(), array $schedule_Distribution_Method_Reference = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setSchedule_Status_Reference($schedule_Status_Reference)
            ->setFrequency_Behavior_Reference($frequency_Behavior_Reference)
            ->setSchedule_Distribution_Method_Reference($schedule_Distribution_Method_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($supplier_Invoice_Schedule_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Request_CriteriaTypeCompany_ReferenceItem), var_export($supplier_Invoice_Schedule_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType[]|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_Contract_ReferenceItem instanceof \StructType\Supplier_ContractObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_Contract_ReferenceItem) ? get_class($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_Contract_ReferenceItem), var_export($supplier_Invoice_Schedule_Request_CriteriaTypeSupplier_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function setSupplier_Contract_Reference(array $supplier_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_ReferenceArrayErrorMessage = self::validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference($supplier_Contract_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function addToSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ContractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Reference[] = $item;
        return $this;
    }
    /**
     * Get Schedule_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getSchedule_Status_Reference()
    {
        return $this->Schedule_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSchedule_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchedule_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchedule_Status_ReferenceForArrayConstraintsFromSetSchedule_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Status_ReferenceItem) ? get_class($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Status_ReferenceItem), var_export($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $schedule_Status_Reference
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function setSchedule_Status_Reference(array $schedule_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($schedule_Status_ReferenceArrayErrorMessage = self::validateSchedule_Status_ReferenceForArrayConstraintsFromSetSchedule_Status_Reference($schedule_Status_Reference))) {
            throw new \InvalidArgumentException($schedule_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Schedule_Status_Reference = $schedule_Status_Reference;
        return $this;
    }
    /**
     * Add item to Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function addToSchedule_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schedule_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Frequency_Behavior_Reference value
     * @return \StructType\Frequency_BehaviorObjectType[]|null
     */
    public function getFrequency_Behavior_Reference()
    {
        return $this->Frequency_Behavior_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setFrequency_Behavior_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFrequency_Behavior_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFrequency_Behavior_ReferenceForArrayConstraintsFromSetFrequency_Behavior_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Request_CriteriaTypeFrequency_Behavior_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Request_CriteriaTypeFrequency_Behavior_ReferenceItem instanceof \StructType\Frequency_BehaviorObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Request_CriteriaTypeFrequency_Behavior_ReferenceItem) ? get_class($supplier_Invoice_Schedule_Request_CriteriaTypeFrequency_Behavior_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Request_CriteriaTypeFrequency_Behavior_ReferenceItem), var_export($supplier_Invoice_Schedule_Request_CriteriaTypeFrequency_Behavior_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Frequency_Behavior_Reference property can only contain items of type \StructType\Frequency_BehaviorObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Frequency_Behavior_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Frequency_BehaviorObjectType[] $frequency_Behavior_Reference
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function setFrequency_Behavior_Reference(array $frequency_Behavior_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($frequency_Behavior_ReferenceArrayErrorMessage = self::validateFrequency_Behavior_ReferenceForArrayConstraintsFromSetFrequency_Behavior_Reference($frequency_Behavior_Reference))) {
            throw new \InvalidArgumentException($frequency_Behavior_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Frequency_Behavior_Reference = $frequency_Behavior_Reference;
        return $this;
    }
    /**
     * Add item to Frequency_Behavior_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Frequency_BehaviorObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function addToFrequency_Behavior_Reference(\StructType\Frequency_BehaviorObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Frequency_BehaviorObjectType) {
            throw new \InvalidArgumentException(sprintf('The Frequency_Behavior_Reference property can only contain items of type \StructType\Frequency_BehaviorObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Frequency_Behavior_Reference[] = $item;
        return $this;
    }
    /**
     * Get Schedule_Distribution_Method_Reference value
     * @return \StructType\Schedule_Distribution_MethodObjectType[]|null
     */
    public function getSchedule_Distribution_Method_Reference()
    {
        return $this->Schedule_Distribution_Method_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSchedule_Distribution_Method_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchedule_Distribution_Method_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchedule_Distribution_Method_ReferenceForArrayConstraintsFromSetSchedule_Distribution_Method_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Distribution_Method_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Distribution_Method_ReferenceItem instanceof \StructType\Schedule_Distribution_MethodObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Distribution_Method_ReferenceItem) ? get_class($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Distribution_Method_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Distribution_Method_ReferenceItem), var_export($supplier_Invoice_Schedule_Request_CriteriaTypeSchedule_Distribution_Method_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schedule_Distribution_Method_Reference property can only contain items of type \StructType\Schedule_Distribution_MethodObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schedule_Distribution_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Schedule_Distribution_MethodObjectType[] $schedule_Distribution_Method_Reference
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function setSchedule_Distribution_Method_Reference(array $schedule_Distribution_Method_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($schedule_Distribution_Method_ReferenceArrayErrorMessage = self::validateSchedule_Distribution_Method_ReferenceForArrayConstraintsFromSetSchedule_Distribution_Method_Reference($schedule_Distribution_Method_Reference))) {
            throw new \InvalidArgumentException($schedule_Distribution_Method_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Schedule_Distribution_Method_Reference = $schedule_Distribution_Method_Reference;
        return $this;
    }
    /**
     * Add item to Schedule_Distribution_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Schedule_Distribution_MethodObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_Request_CriteriaType
     */
    public function addToSchedule_Distribution_Method_Reference(\StructType\Schedule_Distribution_MethodObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Schedule_Distribution_MethodObjectType) {
            throw new \InvalidArgumentException(sprintf('The Schedule_Distribution_Method_Reference property can only contain items of type \StructType\Schedule_Distribution_MethodObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schedule_Distribution_Method_Reference[] = $item;
        return $this;
    }
}
