<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Invoice Instance and Data
 * @subpackage Structs
 */
class Supplier_Invoice_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceType[]
     */
    public $Supplier_Invoice;
    /**
     * Constructor method for Supplier_Invoice_Response_DataType
     * @uses Supplier_Invoice_Response_DataType::setSupplier_Invoice()
     * @param \StructType\Supplier_InvoiceType[] $supplier_Invoice
     */
    public function __construct(array $supplier_Invoice = array())
    {
        $this
            ->setSupplier_Invoice($supplier_Invoice);
    }
    /**
     * Get Supplier_Invoice value
     * @return \StructType\Supplier_InvoiceType[]|null
     */
    public function getSupplier_Invoice()
    {
        return $this->Supplier_Invoice;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_InvoiceForArrayConstraintsFromSetSupplier_Invoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Response_DataTypeSupplier_InvoiceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Response_DataTypeSupplier_InvoiceItem instanceof \StructType\Supplier_InvoiceType) {
                $invalidValues[] = is_object($supplier_Invoice_Response_DataTypeSupplier_InvoiceItem) ? get_class($supplier_Invoice_Response_DataTypeSupplier_InvoiceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Response_DataTypeSupplier_InvoiceItem), var_export($supplier_Invoice_Response_DataTypeSupplier_InvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice property can only contain items of type \StructType\Supplier_InvoiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_InvoiceType[] $supplier_Invoice
     * @return \StructType\Supplier_Invoice_Response_DataType
     */
    public function setSupplier_Invoice(array $supplier_Invoice = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_InvoiceArrayErrorMessage = self::validateSupplier_InvoiceForArrayConstraintsFromSetSupplier_Invoice($supplier_Invoice))) {
            throw new \InvalidArgumentException($supplier_InvoiceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice = $supplier_Invoice;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_InvoiceType $item
     * @return \StructType\Supplier_Invoice_Response_DataType
     */
    public function addToSupplier_Invoice(\StructType\Supplier_InvoiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_InvoiceType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice property can only contain items of type \StructType\Supplier_InvoiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice[] = $item;
        return $this;
    }
}
