<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Request_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Topmost Response Element that represents the Reference to the Supplier Invoice Request along with its content
 * @subpackage Structs
 */
class Supplier_Invoice_Request_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Request
     * Meta information extracted from the WSDL
     * - documentation: Element that represents the Reference to the Supplier Invoice Request along with its content
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Request_OutboundType[]
     */
    public $Supplier_Invoice_Request;
    /**
     * Constructor method for Supplier_Invoice_Request_Response_DataType
     * @uses Supplier_Invoice_Request_Response_DataType::setSupplier_Invoice_Request()
     * @param \StructType\Supplier_Invoice_Request_OutboundType[] $supplier_Invoice_Request
     */
    public function __construct(array $supplier_Invoice_Request = array())
    {
        $this
            ->setSupplier_Invoice_Request($supplier_Invoice_Request);
    }
    /**
     * Get Supplier_Invoice_Request value
     * @return \StructType\Supplier_Invoice_Request_OutboundType[]|null
     */
    public function getSupplier_Invoice_Request()
    {
        return $this->Supplier_Invoice_Request;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Request method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Request method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_RequestForArrayConstraintsFromSetSupplier_Invoice_Request(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Response_DataTypeSupplier_Invoice_RequestItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Response_DataTypeSupplier_Invoice_RequestItem instanceof \StructType\Supplier_Invoice_Request_OutboundType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Response_DataTypeSupplier_Invoice_RequestItem) ? get_class($supplier_Invoice_Request_Response_DataTypeSupplier_Invoice_RequestItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Response_DataTypeSupplier_Invoice_RequestItem), var_export($supplier_Invoice_Request_Response_DataTypeSupplier_Invoice_RequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Request property can only contain items of type \StructType\Supplier_Invoice_Request_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_OutboundType[] $supplier_Invoice_Request
     * @return \StructType\Supplier_Invoice_Request_Response_DataType
     */
    public function setSupplier_Invoice_Request(array $supplier_Invoice_Request = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_RequestArrayErrorMessage = self::validateSupplier_Invoice_RequestForArrayConstraintsFromSetSupplier_Invoice_Request($supplier_Invoice_Request))) {
            throw new \InvalidArgumentException($supplier_Invoice_RequestArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Request = $supplier_Invoice_Request;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_OutboundType $item
     * @return \StructType\Supplier_Invoice_Request_Response_DataType
     */
    public function addToSupplier_Invoice_Request(\StructType\Supplier_Invoice_Request_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Request_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Request property can only contain items of type \StructType\Supplier_Invoice_Request_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Request[] = $item;
        return $this;
    }
}
