<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Request_Data_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of the entire Supplier Invoice Request, including Lines (with and without splits) and Attachments.
 * @subpackage Structs
 */
class Supplier_Invoice_Request_Data_OutboundType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Request_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Request_ID;
    /**
     * The Invoice_Request_Number
     * Meta information extracted from the WSDL
     * - documentation: A unique Workday system generated Supplier Invoice Request Number. This value cannot be updated, but it can be used to reference the instance of the Supplier Invoice Request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Request_Number;
    /**
     * The Invoice_Request_Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Status of the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Request_Document_Status_Reference;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date on the Supplier Invoice Request
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date;
    /**
     * The Invoice_Received_Date
     * Meta information extracted from the WSDL
     * - documentation: Field to store the Invoice Received Date value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Received_Date;
    /**
     * The Canceled_On_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the Supplier Invoice Request was Canceled. Will not show if the request is not canceled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Canceled_On_Date;
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Creator of the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\ContactObjectType
     */
    public $Requester_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company on the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier on the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Business Connection.
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Control_Total_Amount
     * Meta information extracted from the WSDL
     * - documentation: This is the expected invoice total including tax. It is optional. An invoice cannot be submittted for approval if it has a non-zero control total that does not equal the sum of the extended amount for all invoice lines plus tax. |
     * Expected total amount for Supplier Invoice Request. It is optional. | This is the expected supplier invoice request total including freight amount. It is optional. A supplier invoice request cannot be submittted for approval if it has a non-zero
     * control total that does not equal the sum of the extended amount for all supplier invoice request lines plus freight and tax amount. | The total invoice request amount does not match the control total amount.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Control_Total_Amount;
    /**
     * The Suppliers_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference text field on the Supplier Invoice Request
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Suppliers_Invoice_Number;
    /**
     * The Invoice_Request_Total_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total Amount for the Supplier Invoice Request. Includes Tax Amount, Freight Amount and the sum of the Extended Amount of the Lines
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Invoice_Request_Total_Amount;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Terms for the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Additional_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The type of reference used to encode key payment information on the invoice document.
     * - minOccurs: 0
     * @var \StructType\Additional_Reference_TypeObjectType
     */
    public $Additional_Type_Reference;
    /**
     * The Additional_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: The reference number that is encoded with key payment information on the invoice document.
     * - base: xsd:string
     * - maxLength: 140
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional_Reference_Number;
    /**
     * The Due_Date
     * Meta information extracted from the WSDL
     * - documentation: Due Date for the Supplier Invoice Request. Format is MM/DD/YYYY.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Handling_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference code of the payment handling instructions for the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\Payment_Handling_InstructionObjectType
     */
    public $Handling_Code_Reference;
    /**
     * The Statutory_Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Class for Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Statutory_Invoice_Type_Reference;
    /**
     * The Freight_Amount
     * Meta information extracted from the WSDL
     * - documentation: An optional addition of Freight Amount for the Requisition. | Freight charges incurred. | Freight Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Freight_Amount;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: This transaction header memo will print on the delivered transaction. It is optional freeform text
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice for the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Additional_Fields_Data_Reference
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing additional fields data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Configurable_Attributes_DataType[]
     */
    public $Additional_Fields_Data_Reference;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Supplier_Invoice_Request_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Request Line Data. A Supplier Invoice Request may have multiple lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Request_Line_Data_OutboundType[]
     */
    public $Supplier_Invoice_Request_Line_Data;
    /**
     * Constructor method for Supplier_Invoice_Request_Data_OutboundType
     * @uses Supplier_Invoice_Request_Data_OutboundType::setSupplier_Invoice_Request_ID()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setInvoice_Request_Number()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setInvoice_Request_Document_Status_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setInvoice_Date()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setInvoice_Received_Date()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setCanceled_On_Date()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setRequester_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setCompany_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setSupplier_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setSupplier_Connection_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setCurrency_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setControl_Total_Amount()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setSuppliers_Invoice_Number()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setInvoice_Request_Total_Amount()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setShip_To_Address_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setPayment_Terms_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setAdditional_Type_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setAdditional_Reference_Number()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setDue_Date()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setTax_Amount()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setHandling_Code_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setStatutory_Invoice_Type_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setFreight_Amount()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setMemo()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setSupplier_Invoice_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setAdditional_Fields_Data_Reference()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setAttachment_Data()
     * @uses Supplier_Invoice_Request_Data_OutboundType::setSupplier_Invoice_Request_Line_Data()
     * @param string $supplier_Invoice_Request_ID
     * @param string $invoice_Request_Number
     * @param \StructType\Document_StatusObjectType $invoice_Request_Document_Status_Reference
     * @param string $invoice_Date
     * @param string $invoice_Received_Date
     * @param string $canceled_On_Date
     * @param \StructType\ContactObjectType $requester_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $control_Total_Amount
     * @param string $suppliers_Invoice_Number
     * @param float $invoice_Request_Total_Amount
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference
     * @param string $additional_Reference_Number
     * @param string $due_Date
     * @param float $tax_Amount
     * @param \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @param float $freight_Amount
     * @param string $memo
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data_Reference
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param \StructType\Supplier_Invoice_Request_Line_Data_OutboundType[] $supplier_Invoice_Request_Line_Data
     */
    public function __construct($supplier_Invoice_Request_ID = null, $invoice_Request_Number = null, \StructType\Document_StatusObjectType $invoice_Request_Document_Status_Reference = null, $invoice_Date = null, $invoice_Received_Date = null, $canceled_On_Date = null, \StructType\ContactObjectType $requester_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $control_Total_Amount = null, $suppliers_Invoice_Number = null, $invoice_Request_Total_Amount = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference = null, $additional_Reference_Number = null, $due_Date = null, $tax_Amount = null, \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference = null, \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null, $freight_Amount = null, $memo = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, array $additional_Fields_Data_Reference = array(), array $attachment_Data = array(), array $supplier_Invoice_Request_Line_Data = array())
    {
        $this
            ->setSupplier_Invoice_Request_ID($supplier_Invoice_Request_ID)
            ->setInvoice_Request_Number($invoice_Request_Number)
            ->setInvoice_Request_Document_Status_Reference($invoice_Request_Document_Status_Reference)
            ->setInvoice_Date($invoice_Date)
            ->setInvoice_Received_Date($invoice_Received_Date)
            ->setCanceled_On_Date($canceled_On_Date)
            ->setRequester_Reference($requester_Reference)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Connection_Reference($supplier_Connection_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setControl_Total_Amount($control_Total_Amount)
            ->setSuppliers_Invoice_Number($suppliers_Invoice_Number)
            ->setInvoice_Request_Total_Amount($invoice_Request_Total_Amount)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setAdditional_Type_Reference($additional_Type_Reference)
            ->setAdditional_Reference_Number($additional_Reference_Number)
            ->setDue_Date($due_Date)
            ->setTax_Amount($tax_Amount)
            ->setHandling_Code_Reference($handling_Code_Reference)
            ->setStatutory_Invoice_Type_Reference($statutory_Invoice_Type_Reference)
            ->setFreight_Amount($freight_Amount)
            ->setMemo($memo)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setAdditional_Fields_Data_Reference($additional_Fields_Data_Reference)
            ->setAttachment_Data($attachment_Data)
            ->setSupplier_Invoice_Request_Line_Data($supplier_Invoice_Request_Line_Data);
    }
    /**
     * Get Supplier_Invoice_Request_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Request_ID()
    {
        return $this->Supplier_Invoice_Request_ID;
    }
    /**
     * Set Supplier_Invoice_Request_ID value
     * @param string $supplier_Invoice_Request_ID
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setSupplier_Invoice_Request_ID($supplier_Invoice_Request_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Request_ID) && !is_string($supplier_Invoice_Request_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Request_ID, true), gettype($supplier_Invoice_Request_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Request_ID = $supplier_Invoice_Request_ID;
        return $this;
    }
    /**
     * Get Invoice_Request_Number value
     * @return string|null
     */
    public function getInvoice_Request_Number()
    {
        return $this->Invoice_Request_Number;
    }
    /**
     * Set Invoice_Request_Number value
     * @param string $invoice_Request_Number
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setInvoice_Request_Number($invoice_Request_Number = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Request_Number) && !is_string($invoice_Request_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Request_Number, true), gettype($invoice_Request_Number)), __LINE__);
        }
        $this->Invoice_Request_Number = $invoice_Request_Number;
        return $this;
    }
    /**
     * Get Invoice_Request_Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Request_Document_Status_Reference()
    {
        return $this->Invoice_Request_Document_Status_Reference;
    }
    /**
     * Set Invoice_Request_Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Request_Document_Status_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setInvoice_Request_Document_Status_Reference(\StructType\Document_StatusObjectType $invoice_Request_Document_Status_Reference = null)
    {
        $this->Invoice_Request_Document_Status_Reference = $invoice_Request_Document_Status_Reference;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get Invoice_Received_Date value
     * @return string|null
     */
    public function getInvoice_Received_Date()
    {
        return $this->Invoice_Received_Date;
    }
    /**
     * Set Invoice_Received_Date value
     * @param string $invoice_Received_Date
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setInvoice_Received_Date($invoice_Received_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Received_Date) && !is_string($invoice_Received_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Received_Date, true), gettype($invoice_Received_Date)), __LINE__);
        }
        $this->Invoice_Received_Date = $invoice_Received_Date;
        return $this;
    }
    /**
     * Get Canceled_On_Date value
     * @return string|null
     */
    public function getCanceled_On_Date()
    {
        return $this->Canceled_On_Date;
    }
    /**
     * Set Canceled_On_Date value
     * @param string $canceled_On_Date
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setCanceled_On_Date($canceled_On_Date = null)
    {
        // validation for constraint: string
        if (!is_null($canceled_On_Date) && !is_string($canceled_On_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canceled_On_Date, true), gettype($canceled_On_Date)), __LINE__);
        }
        $this->Canceled_On_Date = $canceled_On_Date;
        return $this;
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\ContactObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\ContactObjectType $requester_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setRequester_Reference(\StructType\ContactObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Connection_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_Reference()
    {
        return $this->Supplier_Connection_Reference;
    }
    /**
     * Set Supplier_Connection_Reference value
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setSupplier_Connection_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null)
    {
        $this->Supplier_Connection_Reference = $supplier_Connection_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Control_Total_Amount value
     * @return float|null
     */
    public function getControl_Total_Amount()
    {
        return $this->Control_Total_Amount;
    }
    /**
     * Set Control_Total_Amount value
     * @param float $control_Total_Amount
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setControl_Total_Amount($control_Total_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($control_Total_Amount) && !(is_float($control_Total_Amount) || is_numeric($control_Total_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($control_Total_Amount, true), gettype($control_Total_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($control_Total_Amount) && mb_strlen(mb_substr($control_Total_Amount, false !== mb_strpos($control_Total_Amount, '.') ? mb_strpos($control_Total_Amount, '.') + 1 : mb_strlen($control_Total_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($control_Total_Amount, true), mb_strlen(mb_substr($control_Total_Amount, mb_strpos($control_Total_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($control_Total_Amount) && mb_strlen(preg_replace('/(\D)/', '', $control_Total_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($control_Total_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $control_Total_Amount))), __LINE__);
        }
        $this->Control_Total_Amount = $control_Total_Amount;
        return $this;
    }
    /**
     * Get Suppliers_Invoice_Number value
     * @return string|null
     */
    public function getSuppliers_Invoice_Number()
    {
        return $this->Suppliers_Invoice_Number;
    }
    /**
     * Set Suppliers_Invoice_Number value
     * @param string $suppliers_Invoice_Number
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setSuppliers_Invoice_Number($suppliers_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($suppliers_Invoice_Number) && !is_string($suppliers_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suppliers_Invoice_Number, true), gettype($suppliers_Invoice_Number)), __LINE__);
        }
        $this->Suppliers_Invoice_Number = $suppliers_Invoice_Number;
        return $this;
    }
    /**
     * Get Invoice_Request_Total_Amount value
     * @return float|null
     */
    public function getInvoice_Request_Total_Amount()
    {
        return $this->Invoice_Request_Total_Amount;
    }
    /**
     * Set Invoice_Request_Total_Amount value
     * @param float $invoice_Request_Total_Amount
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setInvoice_Request_Total_Amount($invoice_Request_Total_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($invoice_Request_Total_Amount) && !(is_float($invoice_Request_Total_Amount) || is_numeric($invoice_Request_Total_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoice_Request_Total_Amount, true), gettype($invoice_Request_Total_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($invoice_Request_Total_Amount) && mb_strlen(mb_substr($invoice_Request_Total_Amount, false !== mb_strpos($invoice_Request_Total_Amount, '.') ? mb_strpos($invoice_Request_Total_Amount, '.') + 1 : mb_strlen($invoice_Request_Total_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($invoice_Request_Total_Amount, true), mb_strlen(mb_substr($invoice_Request_Total_Amount, mb_strpos($invoice_Request_Total_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($invoice_Request_Total_Amount) && mb_strlen(preg_replace('/(\D)/', '', $invoice_Request_Total_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($invoice_Request_Total_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $invoice_Request_Total_Amount))), __LINE__);
        }
        $this->Invoice_Request_Total_Amount = $invoice_Request_Total_Amount;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Additional_Type_Reference value
     * @return \StructType\Additional_Reference_TypeObjectType|null
     */
    public function getAdditional_Type_Reference()
    {
        return $this->Additional_Type_Reference;
    }
    /**
     * Set Additional_Type_Reference value
     * @param \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setAdditional_Type_Reference(\StructType\Additional_Reference_TypeObjectType $additional_Type_Reference = null)
    {
        $this->Additional_Type_Reference = $additional_Type_Reference;
        return $this;
    }
    /**
     * Get Additional_Reference_Number value
     * @return string|null
     */
    public function getAdditional_Reference_Number()
    {
        return $this->Additional_Reference_Number;
    }
    /**
     * Set Additional_Reference_Number value
     * @param string $additional_Reference_Number
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setAdditional_Reference_Number($additional_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($additional_Reference_Number) && !is_string($additional_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_Reference_Number, true), gettype($additional_Reference_Number)), __LINE__);
        }
        // validation for constraint: maxLength(140)
        if (!is_null($additional_Reference_Number) && mb_strlen($additional_Reference_Number) > 140) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 140', mb_strlen($additional_Reference_Number)), __LINE__);
        }
        $this->Additional_Reference_Number = $additional_Reference_Number;
        return $this;
    }
    /**
     * Get Due_Date value
     * @return string|null
     */
    public function getDue_Date()
    {
        return $this->Due_Date;
    }
    /**
     * Set Due_Date value
     * @param string $due_Date
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setDue_Date($due_Date = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date) && !is_string($due_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date, true), gettype($due_Date)), __LINE__);
        }
        $this->Due_Date = $due_Date;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Handling_Code_Reference value
     * @return \StructType\Payment_Handling_InstructionObjectType|null
     */
    public function getHandling_Code_Reference()
    {
        return $this->Handling_Code_Reference;
    }
    /**
     * Set Handling_Code_Reference value
     * @param \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setHandling_Code_Reference(\StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference = null)
    {
        $this->Handling_Code_Reference = $handling_Code_Reference;
        return $this;
    }
    /**
     * Get Statutory_Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getStatutory_Invoice_Type_Reference()
    {
        return $this->Statutory_Invoice_Type_Reference;
    }
    /**
     * Set Statutory_Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setStatutory_Invoice_Type_Reference(\StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null)
    {
        $this->Statutory_Invoice_Type_Reference = $statutory_Invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Freight_Amount value
     * @return float|null
     */
    public function getFreight_Amount()
    {
        return $this->Freight_Amount;
    }
    /**
     * Set Freight_Amount value
     * @param float $freight_Amount
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setFreight_Amount($freight_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($freight_Amount) && !(is_float($freight_Amount) || is_numeric($freight_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freight_Amount, true), gettype($freight_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($freight_Amount) && mb_strlen(mb_substr($freight_Amount, false !== mb_strpos($freight_Amount, '.') ? mb_strpos($freight_Amount, '.') + 1 : mb_strlen($freight_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($freight_Amount, true), mb_strlen(mb_substr($freight_Amount, mb_strpos($freight_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($freight_Amount) && mb_strlen(preg_replace('/(\D)/', '', $freight_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($freight_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $freight_Amount))), __LINE__);
        }
        $this->Freight_Amount = $freight_Amount;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Additional_Fields_Data_Reference value
     * @return \StructType\Configurable_Attributes_DataType[]|null
     */
    public function getAdditional_Fields_Data_Reference()
    {
        return $this->Additional_Fields_Data_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Fields_Data_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Fields_Data_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Fields_Data_ReferenceForArrayConstraintsFromSetAdditional_Fields_Data_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Data_OutboundTypeAdditional_Fields_Data_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Data_OutboundTypeAdditional_Fields_Data_ReferenceItem instanceof \StructType\Configurable_Attributes_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Data_OutboundTypeAdditional_Fields_Data_ReferenceItem) ? get_class($supplier_Invoice_Request_Data_OutboundTypeAdditional_Fields_Data_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Data_OutboundTypeAdditional_Fields_Data_ReferenceItem), var_export($supplier_Invoice_Request_Data_OutboundTypeAdditional_Fields_Data_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Fields_Data_Reference property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Fields_Data_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data_Reference
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setAdditional_Fields_Data_Reference(array $additional_Fields_Data_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Fields_Data_ReferenceArrayErrorMessage = self::validateAdditional_Fields_Data_ReferenceForArrayConstraintsFromSetAdditional_Fields_Data_Reference($additional_Fields_Data_Reference))) {
            throw new \InvalidArgumentException($additional_Fields_Data_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Fields_Data_Reference = $additional_Fields_Data_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Fields_Data_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType $item
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function addToAdditional_Fields_Data_Reference(\StructType\Configurable_Attributes_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Configurable_Attributes_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Fields_Data_Reference property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Fields_Data_Reference[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Data_OutboundTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Data_OutboundTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Data_OutboundTypeAttachment_DataItem) ? get_class($supplier_Invoice_Request_Data_OutboundTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Data_OutboundTypeAttachment_DataItem), var_export($supplier_Invoice_Request_Data_OutboundTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Request_Line_Data value
     * @return \StructType\Supplier_Invoice_Request_Line_Data_OutboundType[]|null
     */
    public function getSupplier_Invoice_Request_Line_Data()
    {
        return $this->Supplier_Invoice_Request_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Request_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Request_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Request_Line_DataForArrayConstraintsFromSetSupplier_Invoice_Request_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Data_OutboundTypeSupplier_Invoice_Request_Line_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Data_OutboundTypeSupplier_Invoice_Request_Line_DataItem instanceof \StructType\Supplier_Invoice_Request_Line_Data_OutboundType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Data_OutboundTypeSupplier_Invoice_Request_Line_DataItem) ? get_class($supplier_Invoice_Request_Data_OutboundTypeSupplier_Invoice_Request_Line_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Data_OutboundTypeSupplier_Invoice_Request_Line_DataItem), var_export($supplier_Invoice_Request_Data_OutboundTypeSupplier_Invoice_Request_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Request_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Request_Line_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Request_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_Line_Data_OutboundType[] $supplier_Invoice_Request_Line_Data
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function setSupplier_Invoice_Request_Line_Data(array $supplier_Invoice_Request_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Request_Line_DataArrayErrorMessage = self::validateSupplier_Invoice_Request_Line_DataForArrayConstraintsFromSetSupplier_Invoice_Request_Line_Data($supplier_Invoice_Request_Line_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Request_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Request_Line_Data = $supplier_Invoice_Request_Line_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Request_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_Line_Data_OutboundType $item
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType
     */
    public function addToSupplier_Invoice_Request_Line_Data(\StructType\Supplier_Invoice_Request_Line_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Request_Line_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Request_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Request_Line_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Request_Line_Data[] = $item;
        return $this;
    }
}
