<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Lines_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Invoice Date On or After must be before Invoice Date On or Before. | PO Type Reference should be of type External Warehouse | Supplier Invoice Lines Request Criteria
 * @subpackage Structs
 */
class Supplier_Invoice_Lines_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The Invoice_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date on or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date_On_or_After;
    /**
     * The Invoice_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date on or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date_On_or_Before;
    /**
     * The Last_Updated_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Last Updated Moment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated_On_or_After;
    /**
     * The Supplier_Invoice_Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Document
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_DocumentObjectType[]
     */
    public $Supplier_Invoice_Document_Reference;
    /**
     * The Supplier_Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing instance of Business Entity Status Value
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Supplier_Invoice_Status_Reference;
    /**
     * The PO_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing External PO Type
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType
     */
    public $PO_Type_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * Constructor method for Supplier_Invoice_Lines_Request_CriteriaType
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setCompany_Reference()
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setInvoice_Date_On_or_After()
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setInvoice_Date_On_or_Before()
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setLast_Updated_On_or_After()
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setSupplier_Invoice_Document_Reference()
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setSupplier_Invoice_Status_Reference()
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setPO_Type_Reference()
     * @uses Supplier_Invoice_Lines_Request_CriteriaType::setPurchase_Order_Reference()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param string $invoice_Date_On_or_After
     * @param string $invoice_Date_On_or_Before
     * @param string $last_Updated_On_or_After
     * @param \StructType\Supplier_Invoice_DocumentObjectType[] $supplier_Invoice_Document_Reference
     * @param \StructType\Document_StatusObjectType[] $supplier_Invoice_Status_Reference
     * @param \StructType\Order_TypeObjectType $pO_Type_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     */
    public function __construct(array $company_Reference = array(), $invoice_Date_On_or_After = null, $invoice_Date_On_or_Before = null, $last_Updated_On_or_After = null, array $supplier_Invoice_Document_Reference = array(), array $supplier_Invoice_Status_Reference = array(), \StructType\Order_TypeObjectType $pO_Type_Reference = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setInvoice_Date_On_or_After($invoice_Date_On_or_After)
            ->setInvoice_Date_On_or_Before($invoice_Date_On_or_Before)
            ->setLast_Updated_On_or_After($last_Updated_On_or_After)
            ->setSupplier_Invoice_Document_Reference($supplier_Invoice_Document_Reference)
            ->setSupplier_Invoice_Status_Reference($supplier_Invoice_Status_Reference)
            ->setPO_Type_Reference($pO_Type_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Lines_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Lines_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Lines_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($supplier_Invoice_Lines_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Lines_Request_CriteriaTypeCompany_ReferenceItem), var_export($supplier_Invoice_Lines_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Date_On_or_After value
     * @return string|null
     */
    public function getInvoice_Date_On_or_After()
    {
        return $this->Invoice_Date_On_or_After;
    }
    /**
     * Set Invoice_Date_On_or_After value
     * @param string $invoice_Date_On_or_After
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setInvoice_Date_On_or_After($invoice_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date_On_or_After) && !is_string($invoice_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date_On_or_After, true), gettype($invoice_Date_On_or_After)), __LINE__);
        }
        $this->Invoice_Date_On_or_After = $invoice_Date_On_or_After;
        return $this;
    }
    /**
     * Get Invoice_Date_On_or_Before value
     * @return string|null
     */
    public function getInvoice_Date_On_or_Before()
    {
        return $this->Invoice_Date_On_or_Before;
    }
    /**
     * Set Invoice_Date_On_or_Before value
     * @param string $invoice_Date_On_or_Before
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setInvoice_Date_On_or_Before($invoice_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date_On_or_Before) && !is_string($invoice_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date_On_or_Before, true), gettype($invoice_Date_On_or_Before)), __LINE__);
        }
        $this->Invoice_Date_On_or_Before = $invoice_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Last_Updated_On_or_After value
     * @return string|null
     */
    public function getLast_Updated_On_or_After()
    {
        return $this->Last_Updated_On_or_After;
    }
    /**
     * Set Last_Updated_On_or_After value
     * @param string $last_Updated_On_or_After
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setLast_Updated_On_or_After($last_Updated_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated_On_or_After) && !is_string($last_Updated_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated_On_or_After, true), gettype($last_Updated_On_or_After)), __LINE__);
        }
        $this->Last_Updated_On_or_After = $last_Updated_On_or_After;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Document_Reference value
     * @return \StructType\Supplier_Invoice_DocumentObjectType[]|null
     */
    public function getSupplier_Invoice_Document_Reference()
    {
        return $this->Supplier_Invoice_Document_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Document_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Document_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Document_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Document_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Document_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Document_ReferenceItem instanceof \StructType\Supplier_Invoice_DocumentObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Document_ReferenceItem) ? get_class($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Document_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Document_ReferenceItem), var_export($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Document_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Document_Reference property can only contain items of type \StructType\Supplier_Invoice_DocumentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Document_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_DocumentObjectType[] $supplier_Invoice_Document_Reference
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setSupplier_Invoice_Document_Reference(array $supplier_Invoice_Document_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Document_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Document_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Document_Reference($supplier_Invoice_Document_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Document_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Document_Reference = $supplier_Invoice_Document_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Document_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_DocumentObjectType $item
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function addToSupplier_Invoice_Document_Reference(\StructType\Supplier_Invoice_DocumentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_DocumentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Document_Reference property can only contain items of type \StructType\Supplier_Invoice_DocumentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Document_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getSupplier_Invoice_Status_Reference()
    {
        return $this->Supplier_Invoice_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Status_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Status_ReferenceItem) ? get_class($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Status_ReferenceItem), var_export($supplier_Invoice_Lines_Request_CriteriaTypeSupplier_Invoice_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $supplier_Invoice_Status_Reference
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setSupplier_Invoice_Status_Reference(array $supplier_Invoice_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Status_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Status_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Status_Reference($supplier_Invoice_Status_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Status_Reference = $supplier_Invoice_Status_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function addToSupplier_Invoice_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get PO_Type_Reference value
     * @return \StructType\Order_TypeObjectType|null
     */
    public function getPO_Type_Reference()
    {
        return $this->PO_Type_Reference;
    }
    /**
     * Set PO_Type_Reference value
     * @param \StructType\Order_TypeObjectType $pO_Type_Reference
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setPO_Type_Reference(\StructType\Order_TypeObjectType $pO_Type_Reference = null)
    {
        $this->PO_Type_Reference = $pO_Type_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Supplier_Invoice_Lines_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
}
