<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Line_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Suppler Invoice Line Response Data
 * @subpackage Structs
 */
class Supplier_Invoice_Line_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Line
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_LineType[]
     */
    public $Supplier_Invoice_Line;
    /**
     * Constructor method for Supplier_Invoice_Line_Response_DataType
     * @uses Supplier_Invoice_Line_Response_DataType::setSupplier_Invoice_Line()
     * @param \StructType\Supplier_Invoice_LineType[] $supplier_Invoice_Line
     */
    public function __construct(array $supplier_Invoice_Line = array())
    {
        $this
            ->setSupplier_Invoice_Line($supplier_Invoice_Line);
    }
    /**
     * Get Supplier_Invoice_Line value
     * @return \StructType\Supplier_Invoice_LineType[]|null
     */
    public function getSupplier_Invoice_Line()
    {
        return $this->Supplier_Invoice_Line;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Line method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_LineForArrayConstraintsFromSetSupplier_Invoice_Line(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Line_Response_DataTypeSupplier_Invoice_LineItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Line_Response_DataTypeSupplier_Invoice_LineItem instanceof \StructType\Supplier_Invoice_LineType) {
                $invalidValues[] = is_object($supplier_Invoice_Line_Response_DataTypeSupplier_Invoice_LineItem) ? get_class($supplier_Invoice_Line_Response_DataTypeSupplier_Invoice_LineItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Line_Response_DataTypeSupplier_Invoice_LineItem), var_export($supplier_Invoice_Line_Response_DataTypeSupplier_Invoice_LineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Line property can only contain items of type \StructType\Supplier_Invoice_LineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_LineType[] $supplier_Invoice_Line
     * @return \StructType\Supplier_Invoice_Line_Response_DataType
     */
    public function setSupplier_Invoice_Line(array $supplier_Invoice_Line = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_LineArrayErrorMessage = self::validateSupplier_Invoice_LineForArrayConstraintsFromSetSupplier_Invoice_Line($supplier_Invoice_Line))) {
            throw new \InvalidArgumentException($supplier_Invoice_LineArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Line = $supplier_Invoice_Line;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_LineType $item
     * @return \StructType\Supplier_Invoice_Line_Response_DataType
     */
    public function addToSupplier_Invoice_Line(\StructType\Supplier_Invoice_LineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_LineType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Line property can only contain items of type \StructType\Supplier_Invoice_LineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Line[] = $item;
        return $this;
    }
}
