<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Installment_Replacement_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't specify a third party tax code in the transaction tax code reference. | You may not update installments with status Canceled, Completed, or In Progress. | Element containing Supplier Invoice Installment Data
 * @subpackage Structs
 */
class Supplier_Invoice_Installment_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Installment_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Installment Reference ID. This is the Supplier Invoice Installment unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Installment_ID;
    /**
     * The Supplier_Invoice_Installment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Installment.
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_InstallmentObjectType
     */
    public $Supplier_Invoice_Installment_Reference;
    /**
     * The Installment_Number
     * Meta information extracted from the WSDL
     * - documentation: Installment Number for Schedule.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Installment_Number;
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Installment status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Status_Reference;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Installment Date. This will be the Supplier Invoice Date for the Installment.
     * - maxOccurs: 1
     * @var string
     */
    public $Invoice_Date;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: Installment From date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Date;
    /**
     * The To_Date
     * Meta information extracted from the WSDL
     * - documentation: Installment To date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To_Date;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Supplier Invoice created from this Installment.
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Installment On Hold flag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $On_Hold;
    /**
     * The Use_Installment_Overrides
     * Meta information extracted from the WSDL
     * - documentation: Override Line flag. Use this to specify values on the installment line instead of using values derived from either the installment, the schedule, or the contract line. This must be on to specify overrides.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Installment_Overrides;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't submit a Tax Code when the Company has a third party tax integration enabled for Supplier Invoices. | Reference to an existing Tax Code to be use as an override.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Payment Terms to be use as an override.
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Payment Type to be use as an override.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Override Installment Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Supplier_Invoice_Installment_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Installment_Line_DataType[]
     */
    public $Supplier_Invoice_Installment_Line_Data;
    /**
     * Constructor method for Supplier_Invoice_Installment_Replacement_DataType
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setSupplier_Invoice_Installment_ID()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setSupplier_Invoice_Installment_Reference()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setInstallment_Number()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setStatus_Reference()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setInvoice_Date()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setFrom_Date()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setTo_Date()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setSupplier_Invoice_Reference()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setOn_Hold()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setUse_Installment_Overrides()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setTax_Code_Reference()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setPayment_Terms_Reference()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setPayment_Type_Reference()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setMemo()
     * @uses Supplier_Invoice_Installment_Replacement_DataType::setSupplier_Invoice_Installment_Line_Data()
     * @param string $supplier_Invoice_Installment_ID
     * @param \StructType\Supplier_Invoice_InstallmentObjectType $supplier_Invoice_Installment_Reference
     * @param float $installment_Number
     * @param \StructType\Document_StatusObjectType[] $status_Reference
     * @param string $invoice_Date
     * @param string $from_Date
     * @param string $to_Date
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param bool $on_Hold
     * @param bool $use_Installment_Overrides
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param string $memo
     * @param \StructType\Supplier_Contract_Installment_Line_DataType[] $supplier_Invoice_Installment_Line_Data
     */
    public function __construct($supplier_Invoice_Installment_ID = null, \StructType\Supplier_Invoice_InstallmentObjectType $supplier_Invoice_Installment_Reference = null, $installment_Number = null, array $status_Reference = array(), $invoice_Date = null, $from_Date = null, $to_Date = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, $on_Hold = null, $use_Installment_Overrides = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, $memo = null, array $supplier_Invoice_Installment_Line_Data = array())
    {
        $this
            ->setSupplier_Invoice_Installment_ID($supplier_Invoice_Installment_ID)
            ->setSupplier_Invoice_Installment_Reference($supplier_Invoice_Installment_Reference)
            ->setInstallment_Number($installment_Number)
            ->setStatus_Reference($status_Reference)
            ->setInvoice_Date($invoice_Date)
            ->setFrom_Date($from_Date)
            ->setTo_Date($to_Date)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setOn_Hold($on_Hold)
            ->setUse_Installment_Overrides($use_Installment_Overrides)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setMemo($memo)
            ->setSupplier_Invoice_Installment_Line_Data($supplier_Invoice_Installment_Line_Data);
    }
    /**
     * Get Supplier_Invoice_Installment_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Installment_ID()
    {
        return $this->Supplier_Invoice_Installment_ID;
    }
    /**
     * Set Supplier_Invoice_Installment_ID value
     * @param string $supplier_Invoice_Installment_ID
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setSupplier_Invoice_Installment_ID($supplier_Invoice_Installment_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Installment_ID) && !is_string($supplier_Invoice_Installment_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Installment_ID, true), gettype($supplier_Invoice_Installment_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Installment_ID = $supplier_Invoice_Installment_ID;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Installment_Reference value
     * @return \StructType\Supplier_Invoice_InstallmentObjectType|null
     */
    public function getSupplier_Invoice_Installment_Reference()
    {
        return $this->Supplier_Invoice_Installment_Reference;
    }
    /**
     * Set Supplier_Invoice_Installment_Reference value
     * @param \StructType\Supplier_Invoice_InstallmentObjectType $supplier_Invoice_Installment_Reference
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setSupplier_Invoice_Installment_Reference(\StructType\Supplier_Invoice_InstallmentObjectType $supplier_Invoice_Installment_Reference = null)
    {
        $this->Supplier_Invoice_Installment_Reference = $supplier_Invoice_Installment_Reference;
        return $this;
    }
    /**
     * Get Installment_Number value
     * @return float|null
     */
    public function getInstallment_Number()
    {
        return $this->Installment_Number;
    }
    /**
     * Set Installment_Number value
     * @param float $installment_Number
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setInstallment_Number($installment_Number = null)
    {
        // validation for constraint: float
        if (!is_null($installment_Number) && !(is_float($installment_Number) || is_numeric($installment_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installment_Number, true), gettype($installment_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($installment_Number) && mb_strlen(mb_substr($installment_Number, false !== mb_strpos($installment_Number, '.') ? mb_strpos($installment_Number, '.') + 1 : mb_strlen($installment_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($installment_Number, true), mb_strlen(mb_substr($installment_Number, mb_strpos($installment_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($installment_Number) && mb_strlen(preg_replace('/(\D)/', '', $installment_Number)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($installment_Number, true), mb_strlen(preg_replace('/(\D)/', '', $installment_Number))), __LINE__);
        }
        $this->Installment_Number = $installment_Number;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatus_ReferenceForArrayConstraintsFromSetStatus_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Installment_Replacement_DataTypeStatus_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Installment_Replacement_DataTypeStatus_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Installment_Replacement_DataTypeStatus_ReferenceItem) ? get_class($supplier_Invoice_Installment_Replacement_DataTypeStatus_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Installment_Replacement_DataTypeStatus_ReferenceItem), var_export($supplier_Invoice_Installment_Replacement_DataTypeStatus_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $status_Reference
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setStatus_Reference(array $status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($status_ReferenceArrayErrorMessage = self::validateStatus_ReferenceForArrayConstraintsFromSetStatus_Reference($status_Reference))) {
            throw new \InvalidArgumentException($status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Add item to Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function addToStatus_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return $this->From_Date;
    }
    /**
     * Set From_Date value
     * @param string $from_Date
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        $this->From_Date = $from_Date;
        return $this;
    }
    /**
     * Get To_Date value
     * @return string|null
     */
    public function getTo_Date()
    {
        return $this->To_Date;
    }
    /**
     * Set To_Date value
     * @param string $to_Date
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setTo_Date($to_Date = null)
    {
        // validation for constraint: string
        if (!is_null($to_Date) && !is_string($to_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_Date, true), gettype($to_Date)), __LINE__);
        }
        $this->To_Date = $to_Date;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get On_Hold value
     * @return bool|null
     */
    public function getOn_Hold()
    {
        return $this->On_Hold;
    }
    /**
     * Set On_Hold value
     * @param bool $on_Hold
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setOn_Hold($on_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($on_Hold) && !is_bool($on_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($on_Hold, true), gettype($on_Hold)), __LINE__);
        }
        $this->On_Hold = $on_Hold;
        return $this;
    }
    /**
     * Get Use_Installment_Overrides value
     * @return bool|null
     */
    public function getUse_Installment_Overrides()
    {
        return $this->Use_Installment_Overrides;
    }
    /**
     * Set Use_Installment_Overrides value
     * @param bool $use_Installment_Overrides
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setUse_Installment_Overrides($use_Installment_Overrides = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Installment_Overrides) && !is_bool($use_Installment_Overrides)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Installment_Overrides, true), gettype($use_Installment_Overrides)), __LINE__);
        }
        $this->Use_Installment_Overrides = $use_Installment_Overrides;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Installment_Line_Data value
     * @return \StructType\Supplier_Contract_Installment_Line_DataType[]|null
     */
    public function getSupplier_Invoice_Installment_Line_Data()
    {
        return $this->Supplier_Invoice_Installment_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Installment_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Installment_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Installment_Line_DataForArrayConstraintsFromSetSupplier_Invoice_Installment_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Installment_Replacement_DataTypeSupplier_Invoice_Installment_Line_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Installment_Replacement_DataTypeSupplier_Invoice_Installment_Line_DataItem instanceof \StructType\Supplier_Contract_Installment_Line_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Installment_Replacement_DataTypeSupplier_Invoice_Installment_Line_DataItem) ? get_class($supplier_Invoice_Installment_Replacement_DataTypeSupplier_Invoice_Installment_Line_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Installment_Replacement_DataTypeSupplier_Invoice_Installment_Line_DataItem), var_export($supplier_Invoice_Installment_Replacement_DataTypeSupplier_Invoice_Installment_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Installment_Line_Data property can only contain items of type \StructType\Supplier_Contract_Installment_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Installment_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Installment_Line_DataType[] $supplier_Invoice_Installment_Line_Data
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function setSupplier_Invoice_Installment_Line_Data(array $supplier_Invoice_Installment_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Installment_Line_DataArrayErrorMessage = self::validateSupplier_Invoice_Installment_Line_DataForArrayConstraintsFromSetSupplier_Invoice_Installment_Line_Data($supplier_Invoice_Installment_Line_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Installment_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Installment_Line_Data = $supplier_Invoice_Installment_Line_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Installment_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Installment_Line_DataType $item
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType
     */
    public function addToSupplier_Invoice_Installment_Line_Data(\StructType\Supplier_Contract_Installment_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Installment_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Installment_Line_Data property can only contain items of type \StructType\Supplier_Contract_Installment_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Installment_Line_Data[] = $item;
        return $this;
    }
}
