<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_History_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper for all the Supplier Invoice Histories being returned in the "Get" operation response.
 * @subpackage Structs
 */
class Supplier_Invoice_History_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_History
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_HistoryType[]
     */
    public $Supplier_Invoice_History;
    /**
     * Constructor method for Supplier_Invoice_History_Response_DataType
     * @uses Supplier_Invoice_History_Response_DataType::setSupplier_Invoice_History()
     * @param \StructType\Supplier_Invoice_HistoryType[] $supplier_Invoice_History
     */
    public function __construct(array $supplier_Invoice_History = array())
    {
        $this
            ->setSupplier_Invoice_History($supplier_Invoice_History);
    }
    /**
     * Get Supplier_Invoice_History value
     * @return \StructType\Supplier_Invoice_HistoryType[]|null
     */
    public function getSupplier_Invoice_History()
    {
        return $this->Supplier_Invoice_History;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_History method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_History method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_HistoryForArrayConstraintsFromSetSupplier_Invoice_History(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_History_Response_DataTypeSupplier_Invoice_HistoryItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_History_Response_DataTypeSupplier_Invoice_HistoryItem instanceof \StructType\Supplier_Invoice_HistoryType) {
                $invalidValues[] = is_object($supplier_Invoice_History_Response_DataTypeSupplier_Invoice_HistoryItem) ? get_class($supplier_Invoice_History_Response_DataTypeSupplier_Invoice_HistoryItem) : sprintf('%s(%s)', gettype($supplier_Invoice_History_Response_DataTypeSupplier_Invoice_HistoryItem), var_export($supplier_Invoice_History_Response_DataTypeSupplier_Invoice_HistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_History property can only contain items of type \StructType\Supplier_Invoice_HistoryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_HistoryType[] $supplier_Invoice_History
     * @return \StructType\Supplier_Invoice_History_Response_DataType
     */
    public function setSupplier_Invoice_History(array $supplier_Invoice_History = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_HistoryArrayErrorMessage = self::validateSupplier_Invoice_HistoryForArrayConstraintsFromSetSupplier_Invoice_History($supplier_Invoice_History))) {
            throw new \InvalidArgumentException($supplier_Invoice_HistoryArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_History = $supplier_Invoice_History;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_HistoryType $item
     * @return \StructType\Supplier_Invoice_History_Response_DataType
     */
    public function addToSupplier_Invoice_History(\StructType\Supplier_Invoice_HistoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_HistoryType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_History property can only contain items of type \StructType\Supplier_Invoice_HistoryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_History[] = $item;
        return $this;
    }
}
