<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_History_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier reference is for a supplier that can be used as a basic worktag only. | The Request Criteria is a wrapper element around a list of elements representing the operation specific criteria needed to search for Supplier Invoice
 * History instances.
 * @subpackage Structs
 */
class Supplier_Invoice_History_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to one or more Companies to use as search criteria to find Supplier Invoice Histories.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to one or more Suppliers to use as search criteria to find Supplier Invoice Histories.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Text value for Supplier Reference Number to use as search criteria to find Supplier Invoice Histories.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_Number;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Date value to use to search for Supplier Invoice Histories with an Invoice Date matching this date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date;
    /**
     * The Total_Invoice_Amount
     * Meta information extracted from the WSDL
     * - documentation: Currency amount for the Total Invoice Amount to use as search criteria to find Supplier Invoice Histories. | Currency amount for the Total Invoice Amount. This amount corresponds with the Currency in Supplier Invoice History Currency
     * Reference.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Invoice_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Currency to use as search criteria to find Supplier Invoice Histories.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The External_PO_Number
     * Meta information extracted from the WSDL
     * - documentation: Text value for an External PO Number to use as search criteria to find Supplier Invoice Histories.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_PO_Number;
    /**
     * The Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Text value for an Invoice Number to use as search criteria to find Supplier Invoice Histories.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Number;
    /**
     * The Source_Integration_System
     * Meta information extracted from the WSDL
     * - documentation: Text value for a Source Integration System to use as search criteria to find Supplier Invoice Histories.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source_Integration_System;
    /**
     * Constructor method for Supplier_Invoice_History_Request_CriteriaType
     * @uses Supplier_Invoice_History_Request_CriteriaType::setCompany_Reference()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setSupplier_Reference_Number()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setInvoice_Date()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setTotal_Invoice_Amount()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setCurrency_Reference()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setExternal_PO_Number()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setInvoice_Number()
     * @uses Supplier_Invoice_History_Request_CriteriaType::setSource_Integration_System()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param string $supplier_Reference_Number
     * @param string $invoice_Date
     * @param float $total_Invoice_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $external_PO_Number
     * @param string $invoice_Number
     * @param string $source_Integration_System
     */
    public function __construct(array $company_Reference = array(), array $supplier_Reference = array(), $supplier_Reference_Number = null, $invoice_Date = null, $total_Invoice_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, $external_PO_Number = null, $invoice_Number = null, $source_Integration_System = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Reference_Number($supplier_Reference_Number)
            ->setInvoice_Date($invoice_Date)
            ->setTotal_Invoice_Amount($total_Invoice_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setExternal_PO_Number($external_PO_Number)
            ->setInvoice_Number($invoice_Number)
            ->setSource_Integration_System($source_Integration_System);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_History_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_History_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_History_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($supplier_Invoice_History_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_History_Request_CriteriaTypeCompany_ReferenceItem), var_export($supplier_Invoice_History_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_History_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_History_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_History_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Invoice_History_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_History_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Invoice_History_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Reference_Number()
    {
        return $this->Supplier_Reference_Number;
    }
    /**
     * Set Supplier_Reference_Number value
     * @param string $supplier_Reference_Number
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setSupplier_Reference_Number($supplier_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_Number) && !is_string($supplier_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_Number, true), gettype($supplier_Reference_Number)), __LINE__);
        }
        $this->Supplier_Reference_Number = $supplier_Reference_Number;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get Total_Invoice_Amount value
     * @return float|null
     */
    public function getTotal_Invoice_Amount()
    {
        return $this->Total_Invoice_Amount;
    }
    /**
     * Set Total_Invoice_Amount value
     * @param float $total_Invoice_Amount
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setTotal_Invoice_Amount($total_Invoice_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Invoice_Amount) && !(is_float($total_Invoice_Amount) || is_numeric($total_Invoice_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Invoice_Amount, true), gettype($total_Invoice_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Invoice_Amount) && mb_strlen(mb_substr($total_Invoice_Amount, false !== mb_strpos($total_Invoice_Amount, '.') ? mb_strpos($total_Invoice_Amount, '.') + 1 : mb_strlen($total_Invoice_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Invoice_Amount, true), mb_strlen(mb_substr($total_Invoice_Amount, mb_strpos($total_Invoice_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Invoice_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Invoice_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Invoice_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Invoice_Amount))), __LINE__);
        }
        $this->Total_Invoice_Amount = $total_Invoice_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get External_PO_Number value
     * @return string|null
     */
    public function getExternal_PO_Number()
    {
        return $this->External_PO_Number;
    }
    /**
     * Set External_PO_Number value
     * @param string $external_PO_Number
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setExternal_PO_Number($external_PO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_PO_Number) && !is_string($external_PO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_PO_Number, true), gettype($external_PO_Number)), __LINE__);
        }
        $this->External_PO_Number = $external_PO_Number;
        return $this;
    }
    /**
     * Get Invoice_Number value
     * @return string|null
     */
    public function getInvoice_Number()
    {
        return $this->Invoice_Number;
    }
    /**
     * Set Invoice_Number value
     * @param string $invoice_Number
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setInvoice_Number($invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Number) && !is_string($invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Number, true), gettype($invoice_Number)), __LINE__);
        }
        $this->Invoice_Number = $invoice_Number;
        return $this;
    }
    /**
     * Get Source_Integration_System value
     * @return string|null
     */
    public function getSource_Integration_System()
    {
        return $this->Source_Integration_System;
    }
    /**
     * Set Source_Integration_System value
     * @param string $source_Integration_System
     * @return \StructType\Supplier_Invoice_History_Request_CriteriaType
     */
    public function setSource_Integration_System($source_Integration_System = null)
    {
        // validation for constraint: string
        if (!is_null($source_Integration_System) && !is_string($source_Integration_System)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source_Integration_System, true), gettype($source_Integration_System)), __LINE__);
        }
        $this->Source_Integration_System = $source_Integration_System;
        return $this;
    }
}
