<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Adjustment_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Invoice Adjustment Instance and Data
 * @subpackage Structs
 */
class Supplier_Invoice_Adjustment_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Adjustment
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Adjustment
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_AdjustmentType[]
     */
    public $Supplier_Invoice_Adjustment;
    /**
     * Constructor method for Supplier_Invoice_Adjustment_Response_DataType
     * @uses Supplier_Invoice_Adjustment_Response_DataType::setSupplier_Invoice_Adjustment()
     * @param \StructType\Supplier_Invoice_AdjustmentType[] $supplier_Invoice_Adjustment
     */
    public function __construct(array $supplier_Invoice_Adjustment = array())
    {
        $this
            ->setSupplier_Invoice_Adjustment($supplier_Invoice_Adjustment);
    }
    /**
     * Get Supplier_Invoice_Adjustment value
     * @return \StructType\Supplier_Invoice_AdjustmentType[]|null
     */
    public function getSupplier_Invoice_Adjustment()
    {
        return $this->Supplier_Invoice_Adjustment;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Adjustment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Adjustment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_AdjustmentForArrayConstraintsFromSetSupplier_Invoice_Adjustment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Response_DataTypeSupplier_Invoice_AdjustmentItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Response_DataTypeSupplier_Invoice_AdjustmentItem instanceof \StructType\Supplier_Invoice_AdjustmentType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Response_DataTypeSupplier_Invoice_AdjustmentItem) ? get_class($supplier_Invoice_Adjustment_Response_DataTypeSupplier_Invoice_AdjustmentItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Response_DataTypeSupplier_Invoice_AdjustmentItem), var_export($supplier_Invoice_Adjustment_Response_DataTypeSupplier_Invoice_AdjustmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Adjustment property can only contain items of type \StructType\Supplier_Invoice_AdjustmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Adjustment value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_AdjustmentType[] $supplier_Invoice_Adjustment
     * @return \StructType\Supplier_Invoice_Adjustment_Response_DataType
     */
    public function setSupplier_Invoice_Adjustment(array $supplier_Invoice_Adjustment = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_AdjustmentArrayErrorMessage = self::validateSupplier_Invoice_AdjustmentForArrayConstraintsFromSetSupplier_Invoice_Adjustment($supplier_Invoice_Adjustment))) {
            throw new \InvalidArgumentException($supplier_Invoice_AdjustmentArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Adjustment = $supplier_Invoice_Adjustment;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Adjustment value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_AdjustmentType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Response_DataType
     */
    public function addToSupplier_Invoice_Adjustment(\StructType\Supplier_Invoice_AdjustmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_AdjustmentType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Adjustment property can only contain items of type \StructType\Supplier_Invoice_AdjustmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Adjustment[] = $item;
        return $this;
    }
}
