<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This Contact Information Email is in use as a Default PO Issue Email. Delete the Default PO Issue Email before deleting the Contact Information Email. | The field phone number is required and must have a value. | If Report 1099 with
 * Parent is checked, a United States Tax ID should not be entered. | Only one active Settlement Bank Account can exist with no Payment Type selected. | All electronic payment types accepted for this Supplier must be assigned to an active Settlement
 * Bank Account, OR one active Settlement Bank Account must have no Payment Types assigned, which will become the default Settlement Bank Account. | Select a unique Payment Type for each active Settlement Bank Account for this supplier. | Specify an
 * item that isn't a Catalog Item for the Default Procurement Item for the Supplier. | When Do Not Replace All is False for all address elements, Delete can't be True. | To submit a supplier with a default procurement item, leave the default spend
 * category value blank. | To submit a supplier, specify a procurement item that is active. | Enter a valid URL or update link types on the Maintain External Link validation task. Links must have a valid Uniform Resource Identifier (URI) pattern defined
 * by your security administrator. | Required worktag type(s) are missing. | A Supplier Classification Change is currently in progress for this supplier by someone else. This Supplier Change cannot be created. Try again later after it is finished. |
 * Select a withholding tax code that does not have a realization point of Customer Invoice Self Withholding. | Business Entity Tax ID cannot be used as tax ID for Supplier | Can only submit new suppliers or supplier with Approval status in Draft or
 * Approved. | Can not add inactive Supplier as Child. | Assigning this Supplier as a child of the Supplier provided would create a circular reference. Only Suppliers that are not parents of the Supplier being processed may be assigned. | One or more of
 * the Supplier Children provided belong to another Supplier Hierarchy. A Supplier must be uniquely assigned to a hierarchy | The Customer, Financial Institution, Investor, or Tax Authority selected to create the Supplier from already exists as another
 * Supplier. | Can not create instance from a Business Entity for Customer where the Customer can be used as a basic worktag only. | Can not switch an existing non-basic, non-worktag only supplier to be a basic, worktag only. | Only Supplier Name and
 * Supplier Status Data can be entered when the Basic Worktag Only is true. | Business Entity Data is required. | Default Payment Type Reference is required. | Payment Types Accepted Reference is required. | Supplier Category Reference is required. |
 * Included children reference is for a supplier that can be used as a basic worktag only. | A Payment Type can not be selected for more than one active Settlement Bank Account. | Business Entity to create from is only applicable when creating a
 * Supplier, not updating an existing Supplier | Two Reference ID's have been provided that resolve to different instances. Please provide only one Reference ID or verify that both Reference ID's resolve to the same instance. | A specific alternate name
 * usage can only be used once per business entity | Default payment type is not an accepted payment type. | Supplier Name must match Business Entity Name. | This Element contains Supplier attributes.
 * @subpackage Structs
 */
class Supplier_DataType extends AbstractStructBase
{
    /**
     * The Supplier_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_ID;
    /**
     * The Supplier_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference ID. The Supplier Reference ID can be used to uniquely identify a Supplier Unlike Supplier ID, Workday will not automatically generate a Supplier Reference ID if one is not received. The recommended use for Supplier
     * Reference ID is where the Workday is not the source system of the Supplier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_ID;
    /**
     * The External_Sourceable_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier ID when object is coming from external source
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Sourceable_ID;
    /**
     * The Supplier_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Name
     * - maxOccurs: 1
     * @var string
     */
    public $Supplier_Name;
    /**
     * The Worktag_Only
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if supplier is used as a worktag only and not a complete supplier instance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Worktag_Only;
    /**
     * The Restricted_To_Companies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Restrict To Companies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Restricted_To_Companies_Reference;
    /**
     * The Approval_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Approval Status. This field is read only.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Approval_Status_Reference;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the Supplier is to be submitted or saved in draft mode. If this flag is set, the Supplier will be submitted, otherwise the Supplier is saved in draft. Default to 1 if the Submit
     * flag does not exist in the request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Create_Supplier_from_Customer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Customer from which this Supplier is to be associated.
     * - choice: Create_Supplier_from_Customer_Reference | Create_Supplier_from_Financial_Institution_Reference | Create_Supplier_from_Tax_Authority_Reference | Create_Supplier_from_Investor_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Billable_EntityObjectType
     */
    public $Create_Supplier_from_Customer_Reference;
    /**
     * The Create_Supplier_from_Financial_Institution_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Financial Institution from which this Supplier is to be associated.
     * - choice: Create_Supplier_from_Customer_Reference | Create_Supplier_from_Financial_Institution_Reference | Create_Supplier_from_Tax_Authority_Reference | Create_Supplier_from_Investor_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Financial_InstitutionObjectType
     */
    public $Create_Supplier_from_Financial_Institution_Reference;
    /**
     * The Create_Supplier_from_Tax_Authority_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Authority from which this Supplier is to be associated.
     * - choice: Create_Supplier_from_Customer_Reference | Create_Supplier_from_Financial_Institution_Reference | Create_Supplier_from_Tax_Authority_Reference | Create_Supplier_from_Investor_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Tax_AuthorityObjectType
     */
    public $Create_Supplier_from_Tax_Authority_Reference;
    /**
     * The Create_Supplier_from_Investor_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Investor from which this Supplier is to be associated.
     * - choice: Create_Supplier_from_Customer_Reference | Create_Supplier_from_Financial_Institution_Reference | Create_Supplier_from_Tax_Authority_Reference | Create_Supplier_from_Investor_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InvestorObjectType
     */
    public $Create_Supplier_from_Investor_Reference;
    /**
     * The Tax_Authority_Form_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax form used by the appropriate taxing authority for the Payee.
     * - minOccurs: 0
     * @var \StructType\Tax_Authority_Form_TypeObjectType
     */
    public $Tax_Authority_Form_Type_Reference;
    /**
     * The IRS_1099_Supplier
     * Meta information extracted from the WSDL
     * - documentation: Supplier is 1099
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IRS_1099_Supplier;
    /**
     * The Report_1099_with_Parent
     * Meta information extracted from the WSDL
     * - documentation: Supplier 1099 derived from parent
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Report_1099_with_Parent;
    /**
     * The Tax_ID_Widget_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_ID_Widget_DataType
     */
    public $Tax_ID_Widget_Data;
    /**
     * The Tax_Status_Widget_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Status_Widget_DataType
     */
    public $Tax_Status_Widget_Data;
    /**
     * The Supplier_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Category Reference is a reference to a specific Supplier Category.
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryObjectType
     */
    public $Supplier_Category_Reference;
    /**
     * The Supplier_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Group Reference is a reference to a specific Supplier Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_GroupObjectType[]
     */
    public $Supplier_Group_Reference;
    /**
     * The Document_Link
     * Meta information extracted from the WSDL
     * - documentation: The Document Link URL entered does not comply with URL restrictions set for this Field.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Link;
    /**
     * The Tax_Document_Date
     * Meta information extracted from the WSDL
     * - documentation: This is the date the Tax Document (e.g. W-9, etc) was received.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tax_Document_Date;
    /**
     * The Default_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Tax Code Reference
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Default_Tax_Code_Reference;
    /**
     * The Default_Withholding_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Withholding Tax Code Reference
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Default_Withholding_Tax_Code_Reference;
    /**
     * The Supplier_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Configures the Transaction Source for the supplier
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $Supplier_Source_Reference;
    /**
     * The Supplier_Change_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Configures the Transaction Source for the supplier change
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $Supplier_Change_Source_Reference;
    /**
     * The FATCA
     * Meta information extracted from the WSDL
     * - documentation: For 1099-MISC Reporting
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $FATCA;
    /**
     * The Certificate_of_Insurance_Date
     * Meta information extracted from the WSDL
     * - documentation: Date field for Certificate of Insurance Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Certificate_of_Insurance_Date;
    /**
     * The Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for Customer Account Number. This is not a Workday Customer Account or ID number, but a free form text for a Supplier to enter their own Customer Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer_Account_Number;
    /**
     * The DUNS_Number
     * Meta information extracted from the WSDL
     * - documentation: DUNS Number that uniquely identifies the Supplier. | DUNS Number
     * - base: xsd:string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DUNS_Number;
    /**
     * The Unique_Entity_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Contains the Unique Entity Identifier (UEI) assigned to the supplier by the US federal government.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unique_Entity_Identifier;
    /**
     * The Invoice_Any_Supplier
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the supplier can create invoices for any other supplier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Invoice_Any_Supplier;
    /**
     * The Edit_Portal_Taxes
     * Meta information extracted from the WSDL
     * - documentation: Enable your supplier contacts to enter or change the tax information on supplier invoices created from a purchase order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Edit_Portal_Taxes;
    /**
     * The Restricted_Companies_for_Supplier_Contacts_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enables Invoice Requests on the Supplier Portal for these companies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Restricted_Companies_for_Supplier_Contacts_Reference;
    /**
     * The Enable_Global_Location_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier enabled for GLN use
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_Global_Location_Number;
    /**
     * The Disable_Change_Order
     * Meta information extracted from the WSDL
     * - documentation: When Disable Change Order is True, a Change Order cannot be created from any Purchase Order for this Supplier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Disable_Change_Order;
    /**
     * The Purchase_Order_Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Purchase Order Issue Option
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Purchase_Order_Issue_Option_Reference;
    /**
     * The Change_Order_Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: The default issue option on change orders for the supplier.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Change_Order_Issue_Option_Reference;
    /**
     * The Default_PO_Issue_Email_WWS_Widget_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Default_PO_Issue_Email_WWS_Widget_DataType
     */
    public $Default_PO_Issue_Email_WWS_Widget_Data;
    /**
     * The Multi_Supplier_Supplier_Link_for_PO_Issue_Reference
     * Meta information extracted from the WSDL
     * - documentation: Preferred multi-supplier supplier link to be used to issue purchase orders for the supplier
     * - minOccurs: 0
     * @var \StructType\Supplier_LinkObjectType
     */
    public $Multi_Supplier_Supplier_Link_for_PO_Issue_Reference;
    /**
     * The Shipping_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Terms for Supplier
     * - minOccurs: 0
     * @var \StructType\Shipping_TermsObjectType
     */
    public $Shipping_Terms_Reference;
    /**
     * The Shipping_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Method for Supplier
     * - minOccurs: 0
     * @var \StructType\Shipping_MethodObjectType
     */
    public $Shipping_Method_Reference;
    /**
     * The Acknowledgement_Expected
     * Meta information extracted from the WSDL
     * - documentation: Acknowledgement expected for this supplier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Acknowledgement_Expected;
    /**
     * The Supplier_Minimum_Order_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enable Supplier to send Supplier Minimum Order Amount.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Supplier_Minimum_Order_Amount;
    /**
     * The Minimum_Order_Amount_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enable Supplier to send the Currency for the Supplier Minimum Order Amount.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Minimum_Order_Amount_Currency_Reference;
    /**
     * The Enable_ASN
     * Meta information extracted from the WSDL
     * - documentation: Enable Supplier to send ASN
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_ASN;
    /**
     * The ASN_Due_In_Days
     * Meta information extracted from the WSDL
     * - documentation: The number of days the ASN is due.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $ASN_Due_In_Days;
    /**
     * The Overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion
     * Meta information extracted from the WSDL
     * - documentation: True if you select to override the settings at the supplier level and tenant level.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion;
    /**
     * The Exclude_Freight_Amount_from_Supplier_Invoice_Discount
     * Meta information extracted from the WSDL
     * - documentation: Set to true to indicate that you want to exclude Freight Amount from the supplier invoice discount calculation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Freight_Amount_from_Supplier_Invoice_Discount;
    /**
     * The Exclude_Other_Charges_from_Supplier_Invoice_Discount
     * Meta information extracted from the WSDL
     * - documentation: Set to true to indicate that you want to exclude Other Charges from the supplier invoice discount calculation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Other_Charges_from_Supplier_Invoice_Discount;
    /**
     * The Exclude_Tax_Amount_from_Supplier_Invoice_Discount
     * Meta information extracted from the WSDL
     * - documentation: Set to true to indicate that you want to exclude Tax Amount from the supplier invoice discount calculation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Tax_Amount_from_Supplier_Invoice_Discount;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Terms Reference is a reference to a specific Payment Term that is to be used as the default Payment Terms.
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Payment_Types_Accepted_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Types Accepted Reference is a reference to the accepted Payment Types by the Supplier.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType[]
     */
    public $Payment_Types_Accepted_Reference;
    /**
     * The Default_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Payment Type Reference is a reference to the specific Payment Type that is to be the default Payment Type.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Default_Payment_Type_Reference;
    /**
     * The Default_Additional_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Additional Type Reference
     * - minOccurs: 0
     * @var \StructType\Additional_Reference_TypeObjectType
     */
    public $Default_Additional_Type_Reference;
    /**
     * The Procurement_Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Procurement Credit Card provided must be associated with a Corporate Credit Card Account with an Usage of Procurement. | The Procurement Credit Card provided is not Active. | A Payment Type of Credit Card must be provided as one
     * of the valid payment types for the Supplier if a Procurement Credit Card is to be assigned. | Reference to the Procurement Credit Card used for Supplier payments. The Credit Card supplied must be Active and must be from a Corporate Credit Card
     * Account in the system with an Usage Indicator of Procurement.
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Procurement_Credit_Card_Reference;
    /**
     * The Included_Children_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Suppliers to be added as children. A child Supplier can only belong to one parent and a parent can not be self-referencing.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Included_Children_Reference;
    /**
     * The Proposed_Children_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Suppliers proposed Children of this supplier. if this field does not exist in the request, Included Children field will be used as the proposed ones.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Proposed_Children_Reference;
    /**
     * The Business_Entity_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Data is the name, taxid and contact data.
     * - minOccurs: 0
     * @var \StructType\Business_Entity_WWS_DataType
     */
    public $Business_Entity_Data;
    /**
     * The Settlement_Account_Widget_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element to enable "Replace All" option for Settlement Bank Account.
     * - minOccurs: 0
     * @var \StructType\Settlement_Account_WWS_Widget_DataType
     */
    public $Settlement_Account_Widget_Data;
    /**
     * The Do_not_pay_during_Bank_Account_updates
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate not to pay while Settlement Bank Account changes are in progress. Exclude Supplier Invoices from Settlement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_not_pay_during_Bank_Account_updates;
    /**
     * The Supplier_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Supplier Status data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Status_DataType[]
     */
    public $Supplier_Status_Data;
    /**
     * The Proposed_Supplier_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Proposed Supplier Status data. if this element does not exist in the request, Supplier Status Data element will be used as the proposed one.
     * - minOccurs: 0
     * @var \StructType\Proposed_Supplier_Status_DataType
     */
    public $Proposed_Supplier_Status_Data;
    /**
     * The Always_Separate_Payments
     * Meta information extracted from the WSDL
     * - documentation: Always Separate Payments
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Always_Separate_Payments;
    /**
     * The Text_for_Default_Supplier_Payment_Memo
     * Meta information extracted from the WSDL
     * - documentation: For Supplier Payments from this Supplier, use the Default Text
     * - choice: Text_for_Default_Supplier_Payment_Memo | Use_Supplier_Reference_as_Default_Supplier_Payment_Memo | Use_Invoice_Memo_as_Default_Supplier_Payment_Memo | Use_Supplier_Connection_Memo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text_for_Default_Supplier_Payment_Memo;
    /**
     * The Use_Supplier_Reference_as_Default_Supplier_Payment_Memo
     * Meta information extracted from the WSDL
     * - documentation: For Supplier Payments from this Supplier, use the Supplier Reference
     * - choice: Text_for_Default_Supplier_Payment_Memo | Use_Supplier_Reference_as_Default_Supplier_Payment_Memo | Use_Invoice_Memo_as_Default_Supplier_Payment_Memo | Use_Supplier_Connection_Memo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Supplier_Reference_as_Default_Supplier_Payment_Memo;
    /**
     * The Use_Invoice_Memo_as_Default_Supplier_Payment_Memo
     * Meta information extracted from the WSDL
     * - documentation: For Supplier Payments from this Supplier, use the Supplier Invoice Memo
     * - choice: Text_for_Default_Supplier_Payment_Memo | Use_Supplier_Reference_as_Default_Supplier_Payment_Memo | Use_Invoice_Memo_as_Default_Supplier_Payment_Memo | Use_Supplier_Connection_Memo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Invoice_Memo_as_Default_Supplier_Payment_Memo;
    /**
     * The Use_Supplier_Connection_Memo
     * Meta information extracted from the WSDL
     * - documentation: For Supplier Payments from this Supplier, use the Supplier Connection Memo
     * - choice: Text_for_Default_Supplier_Payment_Memo | Use_Supplier_Reference_as_Default_Supplier_Payment_Memo | Use_Invoice_Memo_as_Default_Supplier_Payment_Memo | Use_Supplier_Connection_Memo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Supplier_Connection_Memo;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Accepted_Currencies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Accepted Currencies Reference. When no accepted currencies are passed in the web service, the bank account will accept all currencies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType[]
     */
    public $Accepted_Currencies_Reference;
    /**
     * The Supplier_Classification_Widget_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplier_Classification_Widget_DataType
     */
    public $Supplier_Classification_Widget_Data;
    /**
     * The Integration_System_Reference
     * Meta information extracted from the WSDL
     * - documentation: Integration system to be used for remittance to this supplier
     * - minOccurs: 0
     * @var \StructType\Integration_System__Audited_ObjectType
     */
    public $Integration_System_Reference;
    /**
     * The Do_Not_Reimburse_Contingent_Worker_Expense_Reports
     * Meta information extracted from the WSDL
     * - documentation: If true, do not reimburse contingent worker expense reports for contingent workers supplied by the supplier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_Not_Reimburse_Contingent_Worker_Expense_Reports;
    /**
     * The Supplier_Security_Segment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Security Segment. If segmented security is implemented, this will control who has access to this Supplier.
     * - minOccurs: 0
     * @var \StructType\Supplier_Security_SegmentObjectType
     */
    public $Supplier_Security_Segment_Reference;
    /**
     * The Supplier_Note_Follow_Up_Date
     * Meta information extracted from the WSDL
     * - documentation: The follow-up date for the latest supplier note.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Note_Follow_Up_Date;
    /**
     * The Business_Entity_Alternate_Name_Widget_Data
     * Meta information extracted from the WSDL
     * - documentation: A wrapper element that contains information about the alternate name for the business entity.
     * - minOccurs: 0
     * @var \StructType\Business_Entity_Alternate_Name_Widget_DataType
     */
    public $Business_Entity_Alternate_Name_Widget_Data;
    /**
     * The Financials_Attachment_Widget_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_Widget_DataType
     */
    public $Financials_Attachment_Widget_Data;
    /**
     * The Note_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Note_WWS_DataType[]
     */
    public $Note_Data;
    /**
     * The Spend_Category_or_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Suppliers can be classified by a Spend Category or Hierarchy. This only represents the categories of goods and services they provide.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_or_Hierarchy_Reference;
    /**
     * The Default_Procurement_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: The default procurement item of the Supplier.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Default_Procurement_Item_Reference;
    /**
     * The Default_Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Default Spend Category of the Supplier.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Default_Spend_Category_Reference;
    /**
     * The Related_Worktag_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to the existing Allowed or Default Related Worktags.
     * - minOccurs: 0
     * @var \StructType\Related_Worktag_Widget_DataType
     */
    public $Related_Worktag_Data;
    /**
     * The Areas_Changed
     * Meta information extracted from the WSDL
     * - documentation: Areas Changed. These attributes indicate which areas have been updated by Supplier Data. Only applies to updating Suppliers after they have been fully approved.
     * - minOccurs: 0
     * @var \StructType\Areas_Changed_WWS_DataType
     */
    public $Areas_Changed;
    /**
     * Constructor method for Supplier_DataType
     * @uses Supplier_DataType::setSupplier_ID()
     * @uses Supplier_DataType::setSupplier_Reference_ID()
     * @uses Supplier_DataType::setExternal_Sourceable_ID()
     * @uses Supplier_DataType::setSupplier_Name()
     * @uses Supplier_DataType::setWorktag_Only()
     * @uses Supplier_DataType::setRestricted_To_Companies_Reference()
     * @uses Supplier_DataType::setApproval_Status_Reference()
     * @uses Supplier_DataType::setSubmit()
     * @uses Supplier_DataType::setCreate_Supplier_from_Customer_Reference()
     * @uses Supplier_DataType::setCreate_Supplier_from_Financial_Institution_Reference()
     * @uses Supplier_DataType::setCreate_Supplier_from_Tax_Authority_Reference()
     * @uses Supplier_DataType::setCreate_Supplier_from_Investor_Reference()
     * @uses Supplier_DataType::setTax_Authority_Form_Type_Reference()
     * @uses Supplier_DataType::setIRS_1099_Supplier()
     * @uses Supplier_DataType::setReport_1099_with_Parent()
     * @uses Supplier_DataType::setTax_ID_Widget_Data()
     * @uses Supplier_DataType::setTax_Status_Widget_Data()
     * @uses Supplier_DataType::setSupplier_Category_Reference()
     * @uses Supplier_DataType::setSupplier_Group_Reference()
     * @uses Supplier_DataType::setDocument_Link()
     * @uses Supplier_DataType::setTax_Document_Date()
     * @uses Supplier_DataType::setDefault_Tax_Code_Reference()
     * @uses Supplier_DataType::setDefault_Withholding_Tax_Code_Reference()
     * @uses Supplier_DataType::setSupplier_Source_Reference()
     * @uses Supplier_DataType::setSupplier_Change_Source_Reference()
     * @uses Supplier_DataType::setFATCA()
     * @uses Supplier_DataType::setCertificate_of_Insurance_Date()
     * @uses Supplier_DataType::setCustomer_Account_Number()
     * @uses Supplier_DataType::setDUNS_Number()
     * @uses Supplier_DataType::setUnique_Entity_Identifier()
     * @uses Supplier_DataType::setInvoice_Any_Supplier()
     * @uses Supplier_DataType::setEdit_Portal_Taxes()
     * @uses Supplier_DataType::setRestricted_Companies_for_Supplier_Contacts_Reference()
     * @uses Supplier_DataType::setEnable_Global_Location_Number()
     * @uses Supplier_DataType::setDisable_Change_Order()
     * @uses Supplier_DataType::setPurchase_Order_Issue_Option_Reference()
     * @uses Supplier_DataType::setChange_Order_Issue_Option_Reference()
     * @uses Supplier_DataType::setDefault_PO_Issue_Email_WWS_Widget_Data()
     * @uses Supplier_DataType::setMulti_Supplier_Supplier_Link_for_PO_Issue_Reference()
     * @uses Supplier_DataType::setShipping_Terms_Reference()
     * @uses Supplier_DataType::setShipping_Method_Reference()
     * @uses Supplier_DataType::setAcknowledgement_Expected()
     * @uses Supplier_DataType::setSupplier_Minimum_Order_Amount()
     * @uses Supplier_DataType::setMinimum_Order_Amount_Currency_Reference()
     * @uses Supplier_DataType::setEnable_ASN()
     * @uses Supplier_DataType::setASN_Due_In_Days()
     * @uses Supplier_DataType::setOverrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion()
     * @uses Supplier_DataType::setExclude_Freight_Amount_from_Supplier_Invoice_Discount()
     * @uses Supplier_DataType::setExclude_Other_Charges_from_Supplier_Invoice_Discount()
     * @uses Supplier_DataType::setExclude_Tax_Amount_from_Supplier_Invoice_Discount()
     * @uses Supplier_DataType::setPayment_Terms_Reference()
     * @uses Supplier_DataType::setPayment_Types_Accepted_Reference()
     * @uses Supplier_DataType::setDefault_Payment_Type_Reference()
     * @uses Supplier_DataType::setDefault_Additional_Type_Reference()
     * @uses Supplier_DataType::setProcurement_Credit_Card_Reference()
     * @uses Supplier_DataType::setIncluded_Children_Reference()
     * @uses Supplier_DataType::setProposed_Children_Reference()
     * @uses Supplier_DataType::setBusiness_Entity_Data()
     * @uses Supplier_DataType::setSettlement_Account_Widget_Data()
     * @uses Supplier_DataType::setDo_not_pay_during_Bank_Account_updates()
     * @uses Supplier_DataType::setSupplier_Status_Data()
     * @uses Supplier_DataType::setProposed_Supplier_Status_Data()
     * @uses Supplier_DataType::setAlways_Separate_Payments()
     * @uses Supplier_DataType::setText_for_Default_Supplier_Payment_Memo()
     * @uses Supplier_DataType::setUse_Supplier_Reference_as_Default_Supplier_Payment_Memo()
     * @uses Supplier_DataType::setUse_Invoice_Memo_as_Default_Supplier_Payment_Memo()
     * @uses Supplier_DataType::setUse_Supplier_Connection_Memo()
     * @uses Supplier_DataType::setCurrency_Reference()
     * @uses Supplier_DataType::setAccepted_Currencies_Reference()
     * @uses Supplier_DataType::setSupplier_Classification_Widget_Data()
     * @uses Supplier_DataType::setIntegration_System_Reference()
     * @uses Supplier_DataType::setDo_Not_Reimburse_Contingent_Worker_Expense_Reports()
     * @uses Supplier_DataType::setSupplier_Security_Segment_Reference()
     * @uses Supplier_DataType::setSupplier_Note_Follow_Up_Date()
     * @uses Supplier_DataType::setBusiness_Entity_Alternate_Name_Widget_Data()
     * @uses Supplier_DataType::setFinancials_Attachment_Widget_Data()
     * @uses Supplier_DataType::setNote_Data()
     * @uses Supplier_DataType::setSpend_Category_or_Hierarchy_Reference()
     * @uses Supplier_DataType::setDefault_Procurement_Item_Reference()
     * @uses Supplier_DataType::setDefault_Spend_Category_Reference()
     * @uses Supplier_DataType::setRelated_Worktag_Data()
     * @uses Supplier_DataType::setAreas_Changed()
     * @param string $supplier_ID
     * @param string $supplier_Reference_ID
     * @param string $external_Sourceable_ID
     * @param string $supplier_Name
     * @param bool $worktag_Only
     * @param \StructType\OrganizationObjectType[] $restricted_To_Companies_Reference
     * @param \StructType\Document_StatusObjectType $approval_Status_Reference
     * @param bool $submit
     * @param \StructType\Billable_EntityObjectType $create_Supplier_from_Customer_Reference
     * @param \StructType\Financial_InstitutionObjectType $create_Supplier_from_Financial_Institution_Reference
     * @param \StructType\Tax_AuthorityObjectType $create_Supplier_from_Tax_Authority_Reference
     * @param \StructType\InvestorObjectType $create_Supplier_from_Investor_Reference
     * @param \StructType\Tax_Authority_Form_TypeObjectType $tax_Authority_Form_Type_Reference
     * @param bool $iRS_1099_Supplier
     * @param bool $report_1099_with_Parent
     * @param \StructType\Tax_ID_Widget_DataType $tax_ID_Widget_Data
     * @param \StructType\Tax_Status_Widget_DataType $tax_Status_Widget_Data
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     * @param string $document_Link
     * @param string $tax_Document_Date
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @param \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference
     * @param \StructType\External_Transaction_Source__All_ObjectType $supplier_Source_Reference
     * @param \StructType\External_Transaction_Source__All_ObjectType $supplier_Change_Source_Reference
     * @param bool $fATCA
     * @param string $certificate_of_Insurance_Date
     * @param string $customer_Account_Number
     * @param string $dUNS_Number
     * @param string $unique_Entity_Identifier
     * @param bool $invoice_Any_Supplier
     * @param bool $edit_Portal_Taxes
     * @param \StructType\CompanyObjectType[] $restricted_Companies_for_Supplier_Contacts_Reference
     * @param bool $enable_Global_Location_Number
     * @param bool $disable_Change_Order
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $change_Order_Issue_Option_Reference
     * @param \StructType\Default_PO_Issue_Email_WWS_Widget_DataType $default_PO_Issue_Email_WWS_Widget_Data
     * @param \StructType\Supplier_LinkObjectType $multi_Supplier_Supplier_Link_for_PO_Issue_Reference
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @param bool $acknowledgement_Expected
     * @param float $supplier_Minimum_Order_Amount
     * @param \StructType\CurrencyObjectType $minimum_Order_Amount_Currency_Reference
     * @param bool $enable_ASN
     * @param float $aSN_Due_In_Days
     * @param bool $overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion
     * @param bool $exclude_Freight_Amount_from_Supplier_Invoice_Discount
     * @param bool $exclude_Other_Charges_from_Supplier_Invoice_Discount
     * @param bool $exclude_Tax_Amount_from_Supplier_Invoice_Discount
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Payment_TypeObjectType[] $payment_Types_Accepted_Reference
     * @param \StructType\Payment_TypeObjectType $default_Payment_Type_Reference
     * @param \StructType\Additional_Reference_TypeObjectType $default_Additional_Type_Reference
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference
     * @param \StructType\SupplierObjectType[] $included_Children_Reference
     * @param \StructType\SupplierObjectType[] $proposed_Children_Reference
     * @param \StructType\Business_Entity_WWS_DataType $business_Entity_Data
     * @param \StructType\Settlement_Account_WWS_Widget_DataType $settlement_Account_Widget_Data
     * @param bool $do_not_pay_during_Bank_Account_updates
     * @param \StructType\Supplier_Status_DataType[] $supplier_Status_Data
     * @param \StructType\Proposed_Supplier_Status_DataType $proposed_Supplier_Status_Data
     * @param bool $always_Separate_Payments
     * @param string $text_for_Default_Supplier_Payment_Memo
     * @param bool $use_Supplier_Reference_as_Default_Supplier_Payment_Memo
     * @param bool $use_Invoice_Memo_as_Default_Supplier_Payment_Memo
     * @param bool $use_Supplier_Connection_Memo
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\CurrencyObjectType[] $accepted_Currencies_Reference
     * @param \StructType\Supplier_Classification_Widget_DataType $supplier_Classification_Widget_Data
     * @param \StructType\Integration_System__Audited_ObjectType $integration_System_Reference
     * @param bool $do_Not_Reimburse_Contingent_Worker_Expense_Reports
     * @param \StructType\Supplier_Security_SegmentObjectType $supplier_Security_Segment_Reference
     * @param string $supplier_Note_Follow_Up_Date
     * @param \StructType\Business_Entity_Alternate_Name_Widget_DataType $business_Entity_Alternate_Name_Widget_Data
     * @param \StructType\Financials_Attachment_Widget_DataType $financials_Attachment_Widget_Data
     * @param \StructType\Note_WWS_DataType[] $note_Data
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @param \StructType\Procurement_ItemObjectType $default_Procurement_Item_Reference
     * @param \StructType\Spend_CategoryObjectType $default_Spend_Category_Reference
     * @param \StructType\Related_Worktag_Widget_DataType $related_Worktag_Data
     * @param \StructType\Areas_Changed_WWS_DataType $areas_Changed
     */
    public function __construct($supplier_ID = null, $supplier_Reference_ID = null, $external_Sourceable_ID = null, $supplier_Name = null, $worktag_Only = null, array $restricted_To_Companies_Reference = array(), \StructType\Document_StatusObjectType $approval_Status_Reference = null, $submit = null, \StructType\Billable_EntityObjectType $create_Supplier_from_Customer_Reference = null, \StructType\Financial_InstitutionObjectType $create_Supplier_from_Financial_Institution_Reference = null, \StructType\Tax_AuthorityObjectType $create_Supplier_from_Tax_Authority_Reference = null, \StructType\InvestorObjectType $create_Supplier_from_Investor_Reference = null, \StructType\Tax_Authority_Form_TypeObjectType $tax_Authority_Form_Type_Reference = null, $iRS_1099_Supplier = null, $report_1099_with_Parent = null, \StructType\Tax_ID_Widget_DataType $tax_ID_Widget_Data = null, \StructType\Tax_Status_Widget_DataType $tax_Status_Widget_Data = null, \StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null, array $supplier_Group_Reference = array(), $document_Link = null, $tax_Document_Date = null, \StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null, \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference = null, \StructType\External_Transaction_Source__All_ObjectType $supplier_Source_Reference = null, \StructType\External_Transaction_Source__All_ObjectType $supplier_Change_Source_Reference = null, $fATCA = null, $certificate_of_Insurance_Date = null, $customer_Account_Number = null, $dUNS_Number = null, $unique_Entity_Identifier = null, $invoice_Any_Supplier = null, $edit_Portal_Taxes = null, array $restricted_Companies_for_Supplier_Contacts_Reference = array(), $enable_Global_Location_Number = null, $disable_Change_Order = null, \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $change_Order_Issue_Option_Reference = null, \StructType\Default_PO_Issue_Email_WWS_Widget_DataType $default_PO_Issue_Email_WWS_Widget_Data = null, \StructType\Supplier_LinkObjectType $multi_Supplier_Supplier_Link_for_PO_Issue_Reference = null, \StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null, \StructType\Shipping_MethodObjectType $shipping_Method_Reference = null, $acknowledgement_Expected = null, $supplier_Minimum_Order_Amount = null, \StructType\CurrencyObjectType $minimum_Order_Amount_Currency_Reference = null, $enable_ASN = null, $aSN_Due_In_Days = null, $overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion = null, $exclude_Freight_Amount_from_Supplier_Invoice_Discount = null, $exclude_Other_Charges_from_Supplier_Invoice_Discount = null, $exclude_Tax_Amount_from_Supplier_Invoice_Discount = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, array $payment_Types_Accepted_Reference = array(), \StructType\Payment_TypeObjectType $default_Payment_Type_Reference = null, \StructType\Additional_Reference_TypeObjectType $default_Additional_Type_Reference = null, \StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference = null, array $included_Children_Reference = array(), array $proposed_Children_Reference = array(), \StructType\Business_Entity_WWS_DataType $business_Entity_Data = null, \StructType\Settlement_Account_WWS_Widget_DataType $settlement_Account_Widget_Data = null, $do_not_pay_during_Bank_Account_updates = null, array $supplier_Status_Data = array(), \StructType\Proposed_Supplier_Status_DataType $proposed_Supplier_Status_Data = null, $always_Separate_Payments = null, $text_for_Default_Supplier_Payment_Memo = null, $use_Supplier_Reference_as_Default_Supplier_Payment_Memo = null, $use_Invoice_Memo_as_Default_Supplier_Payment_Memo = null, $use_Supplier_Connection_Memo = null, \StructType\CurrencyObjectType $currency_Reference = null, array $accepted_Currencies_Reference = array(), \StructType\Supplier_Classification_Widget_DataType $supplier_Classification_Widget_Data = null, \StructType\Integration_System__Audited_ObjectType $integration_System_Reference = null, $do_Not_Reimburse_Contingent_Worker_Expense_Reports = null, \StructType\Supplier_Security_SegmentObjectType $supplier_Security_Segment_Reference = null, $supplier_Note_Follow_Up_Date = null, \StructType\Business_Entity_Alternate_Name_Widget_DataType $business_Entity_Alternate_Name_Widget_Data = null, \StructType\Financials_Attachment_Widget_DataType $financials_Attachment_Widget_Data = null, array $note_Data = array(), array $spend_Category_or_Hierarchy_Reference = array(), \StructType\Procurement_ItemObjectType $default_Procurement_Item_Reference = null, \StructType\Spend_CategoryObjectType $default_Spend_Category_Reference = null, \StructType\Related_Worktag_Widget_DataType $related_Worktag_Data = null, \StructType\Areas_Changed_WWS_DataType $areas_Changed = null)
    {
        $this
            ->setSupplier_ID($supplier_ID)
            ->setSupplier_Reference_ID($supplier_Reference_ID)
            ->setExternal_Sourceable_ID($external_Sourceable_ID)
            ->setSupplier_Name($supplier_Name)
            ->setWorktag_Only($worktag_Only)
            ->setRestricted_To_Companies_Reference($restricted_To_Companies_Reference)
            ->setApproval_Status_Reference($approval_Status_Reference)
            ->setSubmit($submit)
            ->setCreate_Supplier_from_Customer_Reference($create_Supplier_from_Customer_Reference)
            ->setCreate_Supplier_from_Financial_Institution_Reference($create_Supplier_from_Financial_Institution_Reference)
            ->setCreate_Supplier_from_Tax_Authority_Reference($create_Supplier_from_Tax_Authority_Reference)
            ->setCreate_Supplier_from_Investor_Reference($create_Supplier_from_Investor_Reference)
            ->setTax_Authority_Form_Type_Reference($tax_Authority_Form_Type_Reference)
            ->setIRS_1099_Supplier($iRS_1099_Supplier)
            ->setReport_1099_with_Parent($report_1099_with_Parent)
            ->setTax_ID_Widget_Data($tax_ID_Widget_Data)
            ->setTax_Status_Widget_Data($tax_Status_Widget_Data)
            ->setSupplier_Category_Reference($supplier_Category_Reference)
            ->setSupplier_Group_Reference($supplier_Group_Reference)
            ->setDocument_Link($document_Link)
            ->setTax_Document_Date($tax_Document_Date)
            ->setDefault_Tax_Code_Reference($default_Tax_Code_Reference)
            ->setDefault_Withholding_Tax_Code_Reference($default_Withholding_Tax_Code_Reference)
            ->setSupplier_Source_Reference($supplier_Source_Reference)
            ->setSupplier_Change_Source_Reference($supplier_Change_Source_Reference)
            ->setFATCA($fATCA)
            ->setCertificate_of_Insurance_Date($certificate_of_Insurance_Date)
            ->setCustomer_Account_Number($customer_Account_Number)
            ->setDUNS_Number($dUNS_Number)
            ->setUnique_Entity_Identifier($unique_Entity_Identifier)
            ->setInvoice_Any_Supplier($invoice_Any_Supplier)
            ->setEdit_Portal_Taxes($edit_Portal_Taxes)
            ->setRestricted_Companies_for_Supplier_Contacts_Reference($restricted_Companies_for_Supplier_Contacts_Reference)
            ->setEnable_Global_Location_Number($enable_Global_Location_Number)
            ->setDisable_Change_Order($disable_Change_Order)
            ->setPurchase_Order_Issue_Option_Reference($purchase_Order_Issue_Option_Reference)
            ->setChange_Order_Issue_Option_Reference($change_Order_Issue_Option_Reference)
            ->setDefault_PO_Issue_Email_WWS_Widget_Data($default_PO_Issue_Email_WWS_Widget_Data)
            ->setMulti_Supplier_Supplier_Link_for_PO_Issue_Reference($multi_Supplier_Supplier_Link_for_PO_Issue_Reference)
            ->setShipping_Terms_Reference($shipping_Terms_Reference)
            ->setShipping_Method_Reference($shipping_Method_Reference)
            ->setAcknowledgement_Expected($acknowledgement_Expected)
            ->setSupplier_Minimum_Order_Amount($supplier_Minimum_Order_Amount)
            ->setMinimum_Order_Amount_Currency_Reference($minimum_Order_Amount_Currency_Reference)
            ->setEnable_ASN($enable_ASN)
            ->setASN_Due_In_Days($aSN_Due_In_Days)
            ->setOverrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion($overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion)
            ->setExclude_Freight_Amount_from_Supplier_Invoice_Discount($exclude_Freight_Amount_from_Supplier_Invoice_Discount)
            ->setExclude_Other_Charges_from_Supplier_Invoice_Discount($exclude_Other_Charges_from_Supplier_Invoice_Discount)
            ->setExclude_Tax_Amount_from_Supplier_Invoice_Discount($exclude_Tax_Amount_from_Supplier_Invoice_Discount)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setPayment_Types_Accepted_Reference($payment_Types_Accepted_Reference)
            ->setDefault_Payment_Type_Reference($default_Payment_Type_Reference)
            ->setDefault_Additional_Type_Reference($default_Additional_Type_Reference)
            ->setProcurement_Credit_Card_Reference($procurement_Credit_Card_Reference)
            ->setIncluded_Children_Reference($included_Children_Reference)
            ->setProposed_Children_Reference($proposed_Children_Reference)
            ->setBusiness_Entity_Data($business_Entity_Data)
            ->setSettlement_Account_Widget_Data($settlement_Account_Widget_Data)
            ->setDo_not_pay_during_Bank_Account_updates($do_not_pay_during_Bank_Account_updates)
            ->setSupplier_Status_Data($supplier_Status_Data)
            ->setProposed_Supplier_Status_Data($proposed_Supplier_Status_Data)
            ->setAlways_Separate_Payments($always_Separate_Payments)
            ->setText_for_Default_Supplier_Payment_Memo($text_for_Default_Supplier_Payment_Memo)
            ->setUse_Supplier_Reference_as_Default_Supplier_Payment_Memo($use_Supplier_Reference_as_Default_Supplier_Payment_Memo)
            ->setUse_Invoice_Memo_as_Default_Supplier_Payment_Memo($use_Invoice_Memo_as_Default_Supplier_Payment_Memo)
            ->setUse_Supplier_Connection_Memo($use_Supplier_Connection_Memo)
            ->setCurrency_Reference($currency_Reference)
            ->setAccepted_Currencies_Reference($accepted_Currencies_Reference)
            ->setSupplier_Classification_Widget_Data($supplier_Classification_Widget_Data)
            ->setIntegration_System_Reference($integration_System_Reference)
            ->setDo_Not_Reimburse_Contingent_Worker_Expense_Reports($do_Not_Reimburse_Contingent_Worker_Expense_Reports)
            ->setSupplier_Security_Segment_Reference($supplier_Security_Segment_Reference)
            ->setSupplier_Note_Follow_Up_Date($supplier_Note_Follow_Up_Date)
            ->setBusiness_Entity_Alternate_Name_Widget_Data($business_Entity_Alternate_Name_Widget_Data)
            ->setFinancials_Attachment_Widget_Data($financials_Attachment_Widget_Data)
            ->setNote_Data($note_Data)
            ->setSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference)
            ->setDefault_Procurement_Item_Reference($default_Procurement_Item_Reference)
            ->setDefault_Spend_Category_Reference($default_Spend_Category_Reference)
            ->setRelated_Worktag_Data($related_Worktag_Data)
            ->setAreas_Changed($areas_Changed);
    }
    /**
     * Get Supplier_ID value
     * @return string|null
     */
    public function getSupplier_ID()
    {
        return $this->Supplier_ID;
    }
    /**
     * Set Supplier_ID value
     * @param string $supplier_ID
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_ID($supplier_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_ID) && !is_string($supplier_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_ID, true), gettype($supplier_ID)), __LINE__);
        }
        $this->Supplier_ID = $supplier_ID;
        return $this;
    }
    /**
     * Get Supplier_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Reference_ID()
    {
        return $this->Supplier_Reference_ID;
    }
    /**
     * Set Supplier_Reference_ID value
     * @param string $supplier_Reference_ID
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Reference_ID($supplier_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_ID) && !is_string($supplier_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_ID, true), gettype($supplier_Reference_ID)), __LINE__);
        }
        $this->Supplier_Reference_ID = $supplier_Reference_ID;
        return $this;
    }
    /**
     * Get External_Sourceable_ID value
     * @return string|null
     */
    public function getExternal_Sourceable_ID()
    {
        return $this->External_Sourceable_ID;
    }
    /**
     * Set External_Sourceable_ID value
     * @param string $external_Sourceable_ID
     * @return \StructType\Supplier_DataType
     */
    public function setExternal_Sourceable_ID($external_Sourceable_ID = null)
    {
        // validation for constraint: string
        if (!is_null($external_Sourceable_ID) && !is_string($external_Sourceable_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Sourceable_ID, true), gettype($external_Sourceable_ID)), __LINE__);
        }
        $this->External_Sourceable_ID = $external_Sourceable_ID;
        return $this;
    }
    /**
     * Get Supplier_Name value
     * @return string|null
     */
    public function getSupplier_Name()
    {
        return $this->Supplier_Name;
    }
    /**
     * Set Supplier_Name value
     * @param string $supplier_Name
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Name($supplier_Name = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Name) && !is_string($supplier_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Name, true), gettype($supplier_Name)), __LINE__);
        }
        $this->Supplier_Name = $supplier_Name;
        return $this;
    }
    /**
     * Get Worktag_Only value
     * @return bool|null
     */
    public function getWorktag_Only()
    {
        return $this->Worktag_Only;
    }
    /**
     * Set Worktag_Only value
     * @param bool $worktag_Only
     * @return \StructType\Supplier_DataType
     */
    public function setWorktag_Only($worktag_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($worktag_Only) && !is_bool($worktag_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($worktag_Only, true), gettype($worktag_Only)), __LINE__);
        }
        $this->Worktag_Only = $worktag_Only;
        return $this;
    }
    /**
     * Get Restricted_To_Companies_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getRestricted_To_Companies_Reference()
    {
        return $this->Restricted_To_Companies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_To_Companies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_To_Companies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_To_Companies_ReferenceForArrayConstraintsFromSetRestricted_To_Companies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeRestricted_To_Companies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeRestricted_To_Companies_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_DataTypeRestricted_To_Companies_ReferenceItem) ? get_class($supplier_DataTypeRestricted_To_Companies_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypeRestricted_To_Companies_ReferenceItem), var_export($supplier_DataTypeRestricted_To_Companies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_To_Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_To_Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $restricted_To_Companies_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setRestricted_To_Companies_Reference(array $restricted_To_Companies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_To_Companies_ReferenceArrayErrorMessage = self::validateRestricted_To_Companies_ReferenceForArrayConstraintsFromSetRestricted_To_Companies_Reference($restricted_To_Companies_Reference))) {
            throw new \InvalidArgumentException($restricted_To_Companies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_To_Companies_Reference = $restricted_To_Companies_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_To_Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToRestricted_To_Companies_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_To_Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_To_Companies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Approval_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getApproval_Status_Reference()
    {
        return $this->Approval_Status_Reference;
    }
    /**
     * Set Approval_Status_Reference value
     * @param \StructType\Document_StatusObjectType $approval_Status_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setApproval_Status_Reference(\StructType\Document_StatusObjectType $approval_Status_Reference = null)
    {
        $this->Approval_Status_Reference = $approval_Status_Reference;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Supplier_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Create_Supplier_from_Customer_Reference value
     * @return \StructType\Billable_EntityObjectType|null
     */
    public function getCreate_Supplier_from_Customer_Reference()
    {
        return isset($this->Create_Supplier_from_Customer_Reference) ? $this->Create_Supplier_from_Customer_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCreate_Supplier_from_Customer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreate_Supplier_from_Customer_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCreate_Supplier_from_Customer_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Customer_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Create_Supplier_from_Financial_Institution_Reference',
            'Create_Supplier_from_Tax_Authority_Reference',
            'Create_Supplier_from_Investor_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Create_Supplier_from_Customer_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Create_Supplier_from_Customer_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Create_Supplier_from_Customer_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Billable_EntityObjectType $create_Supplier_from_Customer_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setCreate_Supplier_from_Customer_Reference(\StructType\Billable_EntityObjectType $create_Supplier_from_Customer_Reference = null)
    {
        // validation for constraint: choice(Create_Supplier_from_Customer_Reference, Create_Supplier_from_Financial_Institution_Reference, Create_Supplier_from_Tax_Authority_Reference, Create_Supplier_from_Investor_Reference)
        if ('' !== ($create_Supplier_from_Customer_ReferenceChoiceErrorMessage = self::validateCreate_Supplier_from_Customer_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Customer_Reference($create_Supplier_from_Customer_Reference))) {
            throw new \InvalidArgumentException($create_Supplier_from_Customer_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($create_Supplier_from_Customer_Reference) || (is_array($create_Supplier_from_Customer_Reference) && empty($create_Supplier_from_Customer_Reference))) {
            unset($this->Create_Supplier_from_Customer_Reference);
        } else {
            $this->Create_Supplier_from_Customer_Reference = $create_Supplier_from_Customer_Reference;
        }
        return $this;
    }
    /**
     * Get Create_Supplier_from_Financial_Institution_Reference value
     * @return \StructType\Financial_InstitutionObjectType|null
     */
    public function getCreate_Supplier_from_Financial_Institution_Reference()
    {
        return isset($this->Create_Supplier_from_Financial_Institution_Reference) ? $this->Create_Supplier_from_Financial_Institution_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCreate_Supplier_from_Financial_Institution_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreate_Supplier_from_Financial_Institution_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCreate_Supplier_from_Financial_Institution_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Financial_Institution_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Create_Supplier_from_Customer_Reference',
            'Create_Supplier_from_Tax_Authority_Reference',
            'Create_Supplier_from_Investor_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Create_Supplier_from_Financial_Institution_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Create_Supplier_from_Financial_Institution_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Create_Supplier_from_Financial_Institution_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Financial_InstitutionObjectType $create_Supplier_from_Financial_Institution_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setCreate_Supplier_from_Financial_Institution_Reference(\StructType\Financial_InstitutionObjectType $create_Supplier_from_Financial_Institution_Reference = null)
    {
        // validation for constraint: choice(Create_Supplier_from_Customer_Reference, Create_Supplier_from_Financial_Institution_Reference, Create_Supplier_from_Tax_Authority_Reference, Create_Supplier_from_Investor_Reference)
        if ('' !== ($create_Supplier_from_Financial_Institution_ReferenceChoiceErrorMessage = self::validateCreate_Supplier_from_Financial_Institution_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Financial_Institution_Reference($create_Supplier_from_Financial_Institution_Reference))) {
            throw new \InvalidArgumentException($create_Supplier_from_Financial_Institution_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($create_Supplier_from_Financial_Institution_Reference) || (is_array($create_Supplier_from_Financial_Institution_Reference) && empty($create_Supplier_from_Financial_Institution_Reference))) {
            unset($this->Create_Supplier_from_Financial_Institution_Reference);
        } else {
            $this->Create_Supplier_from_Financial_Institution_Reference = $create_Supplier_from_Financial_Institution_Reference;
        }
        return $this;
    }
    /**
     * Get Create_Supplier_from_Tax_Authority_Reference value
     * @return \StructType\Tax_AuthorityObjectType|null
     */
    public function getCreate_Supplier_from_Tax_Authority_Reference()
    {
        return isset($this->Create_Supplier_from_Tax_Authority_Reference) ? $this->Create_Supplier_from_Tax_Authority_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCreate_Supplier_from_Tax_Authority_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreate_Supplier_from_Tax_Authority_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCreate_Supplier_from_Tax_Authority_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Tax_Authority_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Create_Supplier_from_Customer_Reference',
            'Create_Supplier_from_Financial_Institution_Reference',
            'Create_Supplier_from_Investor_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Create_Supplier_from_Tax_Authority_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Create_Supplier_from_Tax_Authority_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Create_Supplier_from_Tax_Authority_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_AuthorityObjectType $create_Supplier_from_Tax_Authority_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setCreate_Supplier_from_Tax_Authority_Reference(\StructType\Tax_AuthorityObjectType $create_Supplier_from_Tax_Authority_Reference = null)
    {
        // validation for constraint: choice(Create_Supplier_from_Customer_Reference, Create_Supplier_from_Financial_Institution_Reference, Create_Supplier_from_Tax_Authority_Reference, Create_Supplier_from_Investor_Reference)
        if ('' !== ($create_Supplier_from_Tax_Authority_ReferenceChoiceErrorMessage = self::validateCreate_Supplier_from_Tax_Authority_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Tax_Authority_Reference($create_Supplier_from_Tax_Authority_Reference))) {
            throw new \InvalidArgumentException($create_Supplier_from_Tax_Authority_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($create_Supplier_from_Tax_Authority_Reference) || (is_array($create_Supplier_from_Tax_Authority_Reference) && empty($create_Supplier_from_Tax_Authority_Reference))) {
            unset($this->Create_Supplier_from_Tax_Authority_Reference);
        } else {
            $this->Create_Supplier_from_Tax_Authority_Reference = $create_Supplier_from_Tax_Authority_Reference;
        }
        return $this;
    }
    /**
     * Get Create_Supplier_from_Investor_Reference value
     * @return \StructType\InvestorObjectType|null
     */
    public function getCreate_Supplier_from_Investor_Reference()
    {
        return isset($this->Create_Supplier_from_Investor_Reference) ? $this->Create_Supplier_from_Investor_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCreate_Supplier_from_Investor_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreate_Supplier_from_Investor_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCreate_Supplier_from_Investor_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Investor_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Create_Supplier_from_Customer_Reference',
            'Create_Supplier_from_Financial_Institution_Reference',
            'Create_Supplier_from_Tax_Authority_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Create_Supplier_from_Investor_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Create_Supplier_from_Investor_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Create_Supplier_from_Investor_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvestorObjectType $create_Supplier_from_Investor_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setCreate_Supplier_from_Investor_Reference(\StructType\InvestorObjectType $create_Supplier_from_Investor_Reference = null)
    {
        // validation for constraint: choice(Create_Supplier_from_Customer_Reference, Create_Supplier_from_Financial_Institution_Reference, Create_Supplier_from_Tax_Authority_Reference, Create_Supplier_from_Investor_Reference)
        if ('' !== ($create_Supplier_from_Investor_ReferenceChoiceErrorMessage = self::validateCreate_Supplier_from_Investor_ReferenceForChoiceConstraintsFromSetCreate_Supplier_from_Investor_Reference($create_Supplier_from_Investor_Reference))) {
            throw new \InvalidArgumentException($create_Supplier_from_Investor_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($create_Supplier_from_Investor_Reference) || (is_array($create_Supplier_from_Investor_Reference) && empty($create_Supplier_from_Investor_Reference))) {
            unset($this->Create_Supplier_from_Investor_Reference);
        } else {
            $this->Create_Supplier_from_Investor_Reference = $create_Supplier_from_Investor_Reference;
        }
        return $this;
    }
    /**
     * Get Tax_Authority_Form_Type_Reference value
     * @return \StructType\Tax_Authority_Form_TypeObjectType|null
     */
    public function getTax_Authority_Form_Type_Reference()
    {
        return $this->Tax_Authority_Form_Type_Reference;
    }
    /**
     * Set Tax_Authority_Form_Type_Reference value
     * @param \StructType\Tax_Authority_Form_TypeObjectType $tax_Authority_Form_Type_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setTax_Authority_Form_Type_Reference(\StructType\Tax_Authority_Form_TypeObjectType $tax_Authority_Form_Type_Reference = null)
    {
        $this->Tax_Authority_Form_Type_Reference = $tax_Authority_Form_Type_Reference;
        return $this;
    }
    /**
     * Get iRS_Supplier value
     * @return iRS_Supplier
     */
    public function getIRS_1099_Supplier()
    {
        return $this->IRS_1099_Supplier;
    }
    /**
     * Set iRS_Supplier value
     * @param iRS_Supplier $iRS_Supplier
     * @return \StructType\Supplier_DataType
     */
    public function setIRS_1099_Supplier($iRS_1099_Supplier = null)
    {
        // validation for constraint: boolean
        if (!is_null($iRS_1099_Supplier) && !is_bool($iRS_1099_Supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iRS_1099_Supplier, true), gettype($iRS_1099_Supplier)), __LINE__);
        }
        $this->IRS_1099_Supplier = $iRS_1099_Supplier;
        return $this;
    }
    /**
     * Get report_with_Parent value
     * @return report_with_Parent
     */
    public function getReport_1099_with_Parent()
    {
        return $this->Report_1099_with_Parent;
    }
    /**
     * Set report_with_Parent value
     * @param report_with_Parent $report_with_Parent
     * @return \StructType\Supplier_DataType
     */
    public function setReport_1099_with_Parent($report_1099_with_Parent = null)
    {
        // validation for constraint: boolean
        if (!is_null($report_1099_with_Parent) && !is_bool($report_1099_with_Parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($report_1099_with_Parent, true), gettype($report_1099_with_Parent)), __LINE__);
        }
        $this->Report_1099_with_Parent = $report_1099_with_Parent;
        return $this;
    }
    /**
     * Get Tax_ID_Widget_Data value
     * @return \StructType\Tax_ID_Widget_DataType|null
     */
    public function getTax_ID_Widget_Data()
    {
        return $this->Tax_ID_Widget_Data;
    }
    /**
     * Set Tax_ID_Widget_Data value
     * @param \StructType\Tax_ID_Widget_DataType $tax_ID_Widget_Data
     * @return \StructType\Supplier_DataType
     */
    public function setTax_ID_Widget_Data(\StructType\Tax_ID_Widget_DataType $tax_ID_Widget_Data = null)
    {
        $this->Tax_ID_Widget_Data = $tax_ID_Widget_Data;
        return $this;
    }
    /**
     * Get Tax_Status_Widget_Data value
     * @return \StructType\Tax_Status_Widget_DataType|null
     */
    public function getTax_Status_Widget_Data()
    {
        return $this->Tax_Status_Widget_Data;
    }
    /**
     * Set Tax_Status_Widget_Data value
     * @param \StructType\Tax_Status_Widget_DataType $tax_Status_Widget_Data
     * @return \StructType\Supplier_DataType
     */
    public function setTax_Status_Widget_Data(\StructType\Tax_Status_Widget_DataType $tax_Status_Widget_Data = null)
    {
        $this->Tax_Status_Widget_Data = $tax_Status_Widget_Data;
        return $this;
    }
    /**
     * Get Supplier_Category_Reference value
     * @return \StructType\Supplier_CategoryObjectType|null
     */
    public function getSupplier_Category_Reference()
    {
        return $this->Supplier_Category_Reference;
    }
    /**
     * Set Supplier_Category_Reference value
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Category_Reference(\StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null)
    {
        $this->Supplier_Category_Reference = $supplier_Category_Reference;
        return $this;
    }
    /**
     * Get Supplier_Group_Reference value
     * @return \StructType\Supplier_GroupObjectType[]|null
     */
    public function getSupplier_Group_Reference()
    {
        return $this->Supplier_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeSupplier_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeSupplier_Group_ReferenceItem instanceof \StructType\Supplier_GroupObjectType) {
                $invalidValues[] = is_object($supplier_DataTypeSupplier_Group_ReferenceItem) ? get_class($supplier_DataTypeSupplier_Group_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypeSupplier_Group_ReferenceItem), var_export($supplier_DataTypeSupplier_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Group_Reference(array $supplier_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Group_ReferenceArrayErrorMessage = self::validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference($supplier_Group_Reference))) {
            throw new \InvalidArgumentException($supplier_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Group_Reference = $supplier_Group_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToSupplier_Group_Reference(\StructType\Supplier_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get Document_Link value
     * @return string|null
     */
    public function getDocument_Link()
    {
        return $this->Document_Link;
    }
    /**
     * Set Document_Link value
     * @param string $document_Link
     * @return \StructType\Supplier_DataType
     */
    public function setDocument_Link($document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($document_Link) && !is_string($document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Link, true), gettype($document_Link)), __LINE__);
        }
        $this->Document_Link = $document_Link;
        return $this;
    }
    /**
     * Get Tax_Document_Date value
     * @return string|null
     */
    public function getTax_Document_Date()
    {
        return $this->Tax_Document_Date;
    }
    /**
     * Set Tax_Document_Date value
     * @param string $tax_Document_Date
     * @return \StructType\Supplier_DataType
     */
    public function setTax_Document_Date($tax_Document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($tax_Document_Date) && !is_string($tax_Document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_Document_Date, true), gettype($tax_Document_Date)), __LINE__);
        }
        $this->Tax_Document_Date = $tax_Document_Date;
        return $this;
    }
    /**
     * Get Default_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getDefault_Tax_Code_Reference()
    {
        return $this->Default_Tax_Code_Reference;
    }
    /**
     * Set Default_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setDefault_Tax_Code_Reference(\StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null)
    {
        $this->Default_Tax_Code_Reference = $default_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Default_Withholding_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getDefault_Withholding_Tax_Code_Reference()
    {
        return $this->Default_Withholding_Tax_Code_Reference;
    }
    /**
     * Set Default_Withholding_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setDefault_Withholding_Tax_Code_Reference(\StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference = null)
    {
        $this->Default_Withholding_Tax_Code_Reference = $default_Withholding_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Supplier_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getSupplier_Source_Reference()
    {
        return $this->Supplier_Source_Reference;
    }
    /**
     * Set Supplier_Source_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $supplier_Source_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $supplier_Source_Reference = null)
    {
        $this->Supplier_Source_Reference = $supplier_Source_Reference;
        return $this;
    }
    /**
     * Get Supplier_Change_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getSupplier_Change_Source_Reference()
    {
        return $this->Supplier_Change_Source_Reference;
    }
    /**
     * Set Supplier_Change_Source_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $supplier_Change_Source_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Change_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $supplier_Change_Source_Reference = null)
    {
        $this->Supplier_Change_Source_Reference = $supplier_Change_Source_Reference;
        return $this;
    }
    /**
     * Get FATCA value
     * @return bool|null
     */
    public function getFATCA()
    {
        return $this->FATCA;
    }
    /**
     * Set FATCA value
     * @param bool $fATCA
     * @return \StructType\Supplier_DataType
     */
    public function setFATCA($fATCA = null)
    {
        // validation for constraint: boolean
        if (!is_null($fATCA) && !is_bool($fATCA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fATCA, true), gettype($fATCA)), __LINE__);
        }
        $this->FATCA = $fATCA;
        return $this;
    }
    /**
     * Get Certificate_of_Insurance_Date value
     * @return string|null
     */
    public function getCertificate_of_Insurance_Date()
    {
        return $this->Certificate_of_Insurance_Date;
    }
    /**
     * Set Certificate_of_Insurance_Date value
     * @param string $certificate_of_Insurance_Date
     * @return \StructType\Supplier_DataType
     */
    public function setCertificate_of_Insurance_Date($certificate_of_Insurance_Date = null)
    {
        // validation for constraint: string
        if (!is_null($certificate_of_Insurance_Date) && !is_string($certificate_of_Insurance_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificate_of_Insurance_Date, true), gettype($certificate_of_Insurance_Date)), __LINE__);
        }
        $this->Certificate_of_Insurance_Date = $certificate_of_Insurance_Date;
        return $this;
    }
    /**
     * Get Customer_Account_Number value
     * @return string|null
     */
    public function getCustomer_Account_Number()
    {
        return $this->Customer_Account_Number;
    }
    /**
     * Set Customer_Account_Number value
     * @param string $customer_Account_Number
     * @return \StructType\Supplier_DataType
     */
    public function setCustomer_Account_Number($customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($customer_Account_Number) && !is_string($customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_Account_Number, true), gettype($customer_Account_Number)), __LINE__);
        }
        $this->Customer_Account_Number = $customer_Account_Number;
        return $this;
    }
    /**
     * Get DUNS_Number value
     * @return string|null
     */
    public function getDUNS_Number()
    {
        return $this->DUNS_Number;
    }
    /**
     * Set DUNS_Number value
     * @param string $dUNS_Number
     * @return \StructType\Supplier_DataType
     */
    public function setDUNS_Number($dUNS_Number = null)
    {
        // validation for constraint: string
        if (!is_null($dUNS_Number) && !is_string($dUNS_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dUNS_Number, true), gettype($dUNS_Number)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($dUNS_Number) && mb_strlen($dUNS_Number) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($dUNS_Number)), __LINE__);
        }
        $this->DUNS_Number = $dUNS_Number;
        return $this;
    }
    /**
     * Get Unique_Entity_Identifier value
     * @return string|null
     */
    public function getUnique_Entity_Identifier()
    {
        return $this->Unique_Entity_Identifier;
    }
    /**
     * Set Unique_Entity_Identifier value
     * @param string $unique_Entity_Identifier
     * @return \StructType\Supplier_DataType
     */
    public function setUnique_Entity_Identifier($unique_Entity_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($unique_Entity_Identifier) && !is_string($unique_Entity_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unique_Entity_Identifier, true), gettype($unique_Entity_Identifier)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($unique_Entity_Identifier) && mb_strlen($unique_Entity_Identifier) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($unique_Entity_Identifier)), __LINE__);
        }
        $this->Unique_Entity_Identifier = $unique_Entity_Identifier;
        return $this;
    }
    /**
     * Get Invoice_Any_Supplier value
     * @return bool|null
     */
    public function getInvoice_Any_Supplier()
    {
        return $this->Invoice_Any_Supplier;
    }
    /**
     * Set Invoice_Any_Supplier value
     * @param bool $invoice_Any_Supplier
     * @return \StructType\Supplier_DataType
     */
    public function setInvoice_Any_Supplier($invoice_Any_Supplier = null)
    {
        // validation for constraint: boolean
        if (!is_null($invoice_Any_Supplier) && !is_bool($invoice_Any_Supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invoice_Any_Supplier, true), gettype($invoice_Any_Supplier)), __LINE__);
        }
        $this->Invoice_Any_Supplier = $invoice_Any_Supplier;
        return $this;
    }
    /**
     * Get Edit_Portal_Taxes value
     * @return bool|null
     */
    public function getEdit_Portal_Taxes()
    {
        return $this->Edit_Portal_Taxes;
    }
    /**
     * Set Edit_Portal_Taxes value
     * @param bool $edit_Portal_Taxes
     * @return \StructType\Supplier_DataType
     */
    public function setEdit_Portal_Taxes($edit_Portal_Taxes = null)
    {
        // validation for constraint: boolean
        if (!is_null($edit_Portal_Taxes) && !is_bool($edit_Portal_Taxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($edit_Portal_Taxes, true), gettype($edit_Portal_Taxes)), __LINE__);
        }
        $this->Edit_Portal_Taxes = $edit_Portal_Taxes;
        return $this;
    }
    /**
     * Get Restricted_Companies_for_Supplier_Contacts_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getRestricted_Companies_for_Supplier_Contacts_Reference()
    {
        return $this->Restricted_Companies_for_Supplier_Contacts_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_Companies_for_Supplier_Contacts_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_Companies_for_Supplier_Contacts_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_Companies_for_Supplier_Contacts_ReferenceForArrayConstraintsFromSetRestricted_Companies_for_Supplier_Contacts_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeRestricted_Companies_for_Supplier_Contacts_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeRestricted_Companies_for_Supplier_Contacts_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($supplier_DataTypeRestricted_Companies_for_Supplier_Contacts_ReferenceItem) ? get_class($supplier_DataTypeRestricted_Companies_for_Supplier_Contacts_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypeRestricted_Companies_for_Supplier_Contacts_ReferenceItem), var_export($supplier_DataTypeRestricted_Companies_for_Supplier_Contacts_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_Companies_for_Supplier_Contacts_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_Companies_for_Supplier_Contacts_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $restricted_Companies_for_Supplier_Contacts_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setRestricted_Companies_for_Supplier_Contacts_Reference(array $restricted_Companies_for_Supplier_Contacts_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_Companies_for_Supplier_Contacts_ReferenceArrayErrorMessage = self::validateRestricted_Companies_for_Supplier_Contacts_ReferenceForArrayConstraintsFromSetRestricted_Companies_for_Supplier_Contacts_Reference($restricted_Companies_for_Supplier_Contacts_Reference))) {
            throw new \InvalidArgumentException($restricted_Companies_for_Supplier_Contacts_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_Companies_for_Supplier_Contacts_Reference = $restricted_Companies_for_Supplier_Contacts_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_Companies_for_Supplier_Contacts_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToRestricted_Companies_for_Supplier_Contacts_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_Companies_for_Supplier_Contacts_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_Companies_for_Supplier_Contacts_Reference[] = $item;
        return $this;
    }
    /**
     * Get Enable_Global_Location_Number value
     * @return bool|null
     */
    public function getEnable_Global_Location_Number()
    {
        return $this->Enable_Global_Location_Number;
    }
    /**
     * Set Enable_Global_Location_Number value
     * @param bool $enable_Global_Location_Number
     * @return \StructType\Supplier_DataType
     */
    public function setEnable_Global_Location_Number($enable_Global_Location_Number = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_Global_Location_Number) && !is_bool($enable_Global_Location_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_Global_Location_Number, true), gettype($enable_Global_Location_Number)), __LINE__);
        }
        $this->Enable_Global_Location_Number = $enable_Global_Location_Number;
        return $this;
    }
    /**
     * Get Disable_Change_Order value
     * @return bool|null
     */
    public function getDisable_Change_Order()
    {
        return $this->Disable_Change_Order;
    }
    /**
     * Set Disable_Change_Order value
     * @param bool $disable_Change_Order
     * @return \StructType\Supplier_DataType
     */
    public function setDisable_Change_Order($disable_Change_Order = null)
    {
        // validation for constraint: boolean
        if (!is_null($disable_Change_Order) && !is_bool($disable_Change_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disable_Change_Order, true), gettype($disable_Change_Order)), __LINE__);
        }
        $this->Disable_Change_Order = $disable_Change_Order;
        return $this;
    }
    /**
     * Get Purchase_Order_Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getPurchase_Order_Issue_Option_Reference()
    {
        return $this->Purchase_Order_Issue_Option_Reference;
    }
    /**
     * Set Purchase_Order_Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setPurchase_Order_Issue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null)
    {
        $this->Purchase_Order_Issue_Option_Reference = $purchase_Order_Issue_Option_Reference;
        return $this;
    }
    /**
     * Get Change_Order_Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getChange_Order_Issue_Option_Reference()
    {
        return $this->Change_Order_Issue_Option_Reference;
    }
    /**
     * Set Change_Order_Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $change_Order_Issue_Option_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setChange_Order_Issue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $change_Order_Issue_Option_Reference = null)
    {
        $this->Change_Order_Issue_Option_Reference = $change_Order_Issue_Option_Reference;
        return $this;
    }
    /**
     * Get Default_PO_Issue_Email_WWS_Widget_Data value
     * @return \StructType\Default_PO_Issue_Email_WWS_Widget_DataType|null
     */
    public function getDefault_PO_Issue_Email_WWS_Widget_Data()
    {
        return $this->Default_PO_Issue_Email_WWS_Widget_Data;
    }
    /**
     * Set Default_PO_Issue_Email_WWS_Widget_Data value
     * @param \StructType\Default_PO_Issue_Email_WWS_Widget_DataType $default_PO_Issue_Email_WWS_Widget_Data
     * @return \StructType\Supplier_DataType
     */
    public function setDefault_PO_Issue_Email_WWS_Widget_Data(\StructType\Default_PO_Issue_Email_WWS_Widget_DataType $default_PO_Issue_Email_WWS_Widget_Data = null)
    {
        $this->Default_PO_Issue_Email_WWS_Widget_Data = $default_PO_Issue_Email_WWS_Widget_Data;
        return $this;
    }
    /**
     * Get Multi_Supplier_Supplier_Link_for_PO_Issue_Reference value
     * @return \StructType\Supplier_LinkObjectType|null
     */
    public function getMulti_Supplier_Supplier_Link_for_PO_Issue_Reference()
    {
        return $this->{'Multi-Supplier_Supplier_Link_for_PO_Issue_Reference'};
    }
    /**
     * Set Multi_Supplier_Supplier_Link_for_PO_Issue_Reference value
     * @param \StructType\Supplier_LinkObjectType $multi_Supplier_Supplier_Link_for_PO_Issue_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setMulti_Supplier_Supplier_Link_for_PO_Issue_Reference(\StructType\Supplier_LinkObjectType $multi_Supplier_Supplier_Link_for_PO_Issue_Reference = null)
    {
        $this->Multi_Supplier_Supplier_Link_for_PO_Issue_Reference = $this->{'Multi-Supplier_Supplier_Link_for_PO_Issue_Reference'} = $multi_Supplier_Supplier_Link_for_PO_Issue_Reference;
        return $this;
    }
    /**
     * Get Shipping_Terms_Reference value
     * @return \StructType\Shipping_TermsObjectType|null
     */
    public function getShipping_Terms_Reference()
    {
        return $this->Shipping_Terms_Reference;
    }
    /**
     * Set Shipping_Terms_Reference value
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setShipping_Terms_Reference(\StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null)
    {
        $this->Shipping_Terms_Reference = $shipping_Terms_Reference;
        return $this;
    }
    /**
     * Get Shipping_Method_Reference value
     * @return \StructType\Shipping_MethodObjectType|null
     */
    public function getShipping_Method_Reference()
    {
        return $this->Shipping_Method_Reference;
    }
    /**
     * Set Shipping_Method_Reference value
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setShipping_Method_Reference(\StructType\Shipping_MethodObjectType $shipping_Method_Reference = null)
    {
        $this->Shipping_Method_Reference = $shipping_Method_Reference;
        return $this;
    }
    /**
     * Get Acknowledgement_Expected value
     * @return bool|null
     */
    public function getAcknowledgement_Expected()
    {
        return $this->Acknowledgement_Expected;
    }
    /**
     * Set Acknowledgement_Expected value
     * @param bool $acknowledgement_Expected
     * @return \StructType\Supplier_DataType
     */
    public function setAcknowledgement_Expected($acknowledgement_Expected = null)
    {
        // validation for constraint: boolean
        if (!is_null($acknowledgement_Expected) && !is_bool($acknowledgement_Expected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acknowledgement_Expected, true), gettype($acknowledgement_Expected)), __LINE__);
        }
        $this->Acknowledgement_Expected = $acknowledgement_Expected;
        return $this;
    }
    /**
     * Get Supplier_Minimum_Order_Amount value
     * @return float|null
     */
    public function getSupplier_Minimum_Order_Amount()
    {
        return $this->Supplier_Minimum_Order_Amount;
    }
    /**
     * Set Supplier_Minimum_Order_Amount value
     * @param float $supplier_Minimum_Order_Amount
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Minimum_Order_Amount($supplier_Minimum_Order_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($supplier_Minimum_Order_Amount) && !(is_float($supplier_Minimum_Order_Amount) || is_numeric($supplier_Minimum_Order_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($supplier_Minimum_Order_Amount, true), gettype($supplier_Minimum_Order_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($supplier_Minimum_Order_Amount) && mb_strlen(mb_substr($supplier_Minimum_Order_Amount, false !== mb_strpos($supplier_Minimum_Order_Amount, '.') ? mb_strpos($supplier_Minimum_Order_Amount, '.') + 1 : mb_strlen($supplier_Minimum_Order_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($supplier_Minimum_Order_Amount, true), mb_strlen(mb_substr($supplier_Minimum_Order_Amount, mb_strpos($supplier_Minimum_Order_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($supplier_Minimum_Order_Amount) && $supplier_Minimum_Order_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($supplier_Minimum_Order_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($supplier_Minimum_Order_Amount) && mb_strlen(preg_replace('/(\D)/', '', $supplier_Minimum_Order_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($supplier_Minimum_Order_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $supplier_Minimum_Order_Amount))), __LINE__);
        }
        $this->Supplier_Minimum_Order_Amount = $supplier_Minimum_Order_Amount;
        return $this;
    }
    /**
     * Get Minimum_Order_Amount_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getMinimum_Order_Amount_Currency_Reference()
    {
        return $this->Minimum_Order_Amount_Currency_Reference;
    }
    /**
     * Set Minimum_Order_Amount_Currency_Reference value
     * @param \StructType\CurrencyObjectType $minimum_Order_Amount_Currency_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setMinimum_Order_Amount_Currency_Reference(\StructType\CurrencyObjectType $minimum_Order_Amount_Currency_Reference = null)
    {
        $this->Minimum_Order_Amount_Currency_Reference = $minimum_Order_Amount_Currency_Reference;
        return $this;
    }
    /**
     * Get Enable_ASN value
     * @return bool|null
     */
    public function getEnable_ASN()
    {
        return $this->Enable_ASN;
    }
    /**
     * Set Enable_ASN value
     * @param bool $enable_ASN
     * @return \StructType\Supplier_DataType
     */
    public function setEnable_ASN($enable_ASN = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_ASN) && !is_bool($enable_ASN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_ASN, true), gettype($enable_ASN)), __LINE__);
        }
        $this->Enable_ASN = $enable_ASN;
        return $this;
    }
    /**
     * Get ASN_Due_In_Days value
     * @return float|null
     */
    public function getASN_Due_In_Days()
    {
        return $this->ASN_Due_In_Days;
    }
    /**
     * Set ASN_Due_In_Days value
     * @param float $aSN_Due_In_Days
     * @return \StructType\Supplier_DataType
     */
    public function setASN_Due_In_Days($aSN_Due_In_Days = null)
    {
        // validation for constraint: float
        if (!is_null($aSN_Due_In_Days) && !(is_float($aSN_Due_In_Days) || is_numeric($aSN_Due_In_Days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aSN_Due_In_Days, true), gettype($aSN_Due_In_Days)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($aSN_Due_In_Days) && mb_strlen(mb_substr($aSN_Due_In_Days, false !== mb_strpos($aSN_Due_In_Days, '.') ? mb_strpos($aSN_Due_In_Days, '.') + 1 : mb_strlen($aSN_Due_In_Days))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($aSN_Due_In_Days, true), mb_strlen(mb_substr($aSN_Due_In_Days, mb_strpos($aSN_Due_In_Days, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($aSN_Due_In_Days) && $aSN_Due_In_Days < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($aSN_Due_In_Days, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($aSN_Due_In_Days) && mb_strlen(preg_replace('/(\D)/', '', $aSN_Due_In_Days)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($aSN_Due_In_Days, true), mb_strlen(preg_replace('/(\D)/', '', $aSN_Due_In_Days))), __LINE__);
        }
        $this->ASN_Due_In_Days = $aSN_Due_In_Days;
        return $this;
    }
    /**
     * Get Overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion value
     * @return bool|null
     */
    public function getOverrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion()
    {
        return $this->Overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion;
    }
    /**
     * Set Overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion value
     * @param bool $overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion
     * @return \StructType\Supplier_DataType
     */
    public function setOverrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion($overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion) && !is_bool($overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion, true), gettype($overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion)), __LINE__);
        }
        $this->Overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion = $overrides_Tenant_Setup_for_Supplier_Invoice_Discount_Exclusion;
        return $this;
    }
    /**
     * Get Exclude_Freight_Amount_from_Supplier_Invoice_Discount value
     * @return bool|null
     */
    public function getExclude_Freight_Amount_from_Supplier_Invoice_Discount()
    {
        return $this->Exclude_Freight_Amount_from_Supplier_Invoice_Discount;
    }
    /**
     * Set Exclude_Freight_Amount_from_Supplier_Invoice_Discount value
     * @param bool $exclude_Freight_Amount_from_Supplier_Invoice_Discount
     * @return \StructType\Supplier_DataType
     */
    public function setExclude_Freight_Amount_from_Supplier_Invoice_Discount($exclude_Freight_Amount_from_Supplier_Invoice_Discount = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Freight_Amount_from_Supplier_Invoice_Discount) && !is_bool($exclude_Freight_Amount_from_Supplier_Invoice_Discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Freight_Amount_from_Supplier_Invoice_Discount, true), gettype($exclude_Freight_Amount_from_Supplier_Invoice_Discount)), __LINE__);
        }
        $this->Exclude_Freight_Amount_from_Supplier_Invoice_Discount = $exclude_Freight_Amount_from_Supplier_Invoice_Discount;
        return $this;
    }
    /**
     * Get Exclude_Other_Charges_from_Supplier_Invoice_Discount value
     * @return bool|null
     */
    public function getExclude_Other_Charges_from_Supplier_Invoice_Discount()
    {
        return $this->Exclude_Other_Charges_from_Supplier_Invoice_Discount;
    }
    /**
     * Set Exclude_Other_Charges_from_Supplier_Invoice_Discount value
     * @param bool $exclude_Other_Charges_from_Supplier_Invoice_Discount
     * @return \StructType\Supplier_DataType
     */
    public function setExclude_Other_Charges_from_Supplier_Invoice_Discount($exclude_Other_Charges_from_Supplier_Invoice_Discount = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Other_Charges_from_Supplier_Invoice_Discount) && !is_bool($exclude_Other_Charges_from_Supplier_Invoice_Discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Other_Charges_from_Supplier_Invoice_Discount, true), gettype($exclude_Other_Charges_from_Supplier_Invoice_Discount)), __LINE__);
        }
        $this->Exclude_Other_Charges_from_Supplier_Invoice_Discount = $exclude_Other_Charges_from_Supplier_Invoice_Discount;
        return $this;
    }
    /**
     * Get Exclude_Tax_Amount_from_Supplier_Invoice_Discount value
     * @return bool|null
     */
    public function getExclude_Tax_Amount_from_Supplier_Invoice_Discount()
    {
        return $this->Exclude_Tax_Amount_from_Supplier_Invoice_Discount;
    }
    /**
     * Set Exclude_Tax_Amount_from_Supplier_Invoice_Discount value
     * @param bool $exclude_Tax_Amount_from_Supplier_Invoice_Discount
     * @return \StructType\Supplier_DataType
     */
    public function setExclude_Tax_Amount_from_Supplier_Invoice_Discount($exclude_Tax_Amount_from_Supplier_Invoice_Discount = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Tax_Amount_from_Supplier_Invoice_Discount) && !is_bool($exclude_Tax_Amount_from_Supplier_Invoice_Discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Tax_Amount_from_Supplier_Invoice_Discount, true), gettype($exclude_Tax_Amount_from_Supplier_Invoice_Discount)), __LINE__);
        }
        $this->Exclude_Tax_Amount_from_Supplier_Invoice_Discount = $exclude_Tax_Amount_from_Supplier_Invoice_Discount;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Payment_Types_Accepted_Reference value
     * @return \StructType\Payment_TypeObjectType[]|null
     */
    public function getPayment_Types_Accepted_Reference()
    {
        return $this->Payment_Types_Accepted_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment_Types_Accepted_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment_Types_Accepted_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayment_Types_Accepted_ReferenceForArrayConstraintsFromSetPayment_Types_Accepted_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypePayment_Types_Accepted_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypePayment_Types_Accepted_ReferenceItem instanceof \StructType\Payment_TypeObjectType) {
                $invalidValues[] = is_object($supplier_DataTypePayment_Types_Accepted_ReferenceItem) ? get_class($supplier_DataTypePayment_Types_Accepted_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypePayment_Types_Accepted_ReferenceItem), var_export($supplier_DataTypePayment_Types_Accepted_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payment_Types_Accepted_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payment_Types_Accepted_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType[] $payment_Types_Accepted_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setPayment_Types_Accepted_Reference(array $payment_Types_Accepted_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($payment_Types_Accepted_ReferenceArrayErrorMessage = self::validatePayment_Types_Accepted_ReferenceForArrayConstraintsFromSetPayment_Types_Accepted_Reference($payment_Types_Accepted_Reference))) {
            throw new \InvalidArgumentException($payment_Types_Accepted_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Payment_Types_Accepted_Reference = $payment_Types_Accepted_Reference;
        return $this;
    }
    /**
     * Add item to Payment_Types_Accepted_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToPayment_Types_Accepted_Reference(\StructType\Payment_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Payment_Types_Accepted_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payment_Types_Accepted_Reference[] = $item;
        return $this;
    }
    /**
     * Get Default_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getDefault_Payment_Type_Reference()
    {
        return $this->Default_Payment_Type_Reference;
    }
    /**
     * Set Default_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $default_Payment_Type_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setDefault_Payment_Type_Reference(\StructType\Payment_TypeObjectType $default_Payment_Type_Reference = null)
    {
        $this->Default_Payment_Type_Reference = $default_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Default_Additional_Type_Reference value
     * @return \StructType\Additional_Reference_TypeObjectType|null
     */
    public function getDefault_Additional_Type_Reference()
    {
        return $this->Default_Additional_Type_Reference;
    }
    /**
     * Set Default_Additional_Type_Reference value
     * @param \StructType\Additional_Reference_TypeObjectType $default_Additional_Type_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setDefault_Additional_Type_Reference(\StructType\Additional_Reference_TypeObjectType $default_Additional_Type_Reference = null)
    {
        $this->Default_Additional_Type_Reference = $default_Additional_Type_Reference;
        return $this;
    }
    /**
     * Get Procurement_Credit_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getProcurement_Credit_Card_Reference()
    {
        return $this->Procurement_Credit_Card_Reference;
    }
    /**
     * Set Procurement_Credit_Card_Reference value
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setProcurement_Credit_Card_Reference(\StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference = null)
    {
        $this->Procurement_Credit_Card_Reference = $procurement_Credit_Card_Reference;
        return $this;
    }
    /**
     * Get Included_Children_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getIncluded_Children_Reference()
    {
        return $this->Included_Children_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setIncluded_Children_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncluded_Children_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncluded_Children_ReferenceForArrayConstraintsFromSetIncluded_Children_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeIncluded_Children_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeIncluded_Children_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($supplier_DataTypeIncluded_Children_ReferenceItem) ? get_class($supplier_DataTypeIncluded_Children_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypeIncluded_Children_ReferenceItem), var_export($supplier_DataTypeIncluded_Children_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Included_Children_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Included_Children_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $included_Children_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setIncluded_Children_Reference(array $included_Children_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($included_Children_ReferenceArrayErrorMessage = self::validateIncluded_Children_ReferenceForArrayConstraintsFromSetIncluded_Children_Reference($included_Children_Reference))) {
            throw new \InvalidArgumentException($included_Children_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Included_Children_Reference = $included_Children_Reference;
        return $this;
    }
    /**
     * Add item to Included_Children_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToIncluded_Children_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Included_Children_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Included_Children_Reference[] = $item;
        return $this;
    }
    /**
     * Get Proposed_Children_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getProposed_Children_Reference()
    {
        return $this->Proposed_Children_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProposed_Children_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProposed_Children_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProposed_Children_ReferenceForArrayConstraintsFromSetProposed_Children_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeProposed_Children_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeProposed_Children_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($supplier_DataTypeProposed_Children_ReferenceItem) ? get_class($supplier_DataTypeProposed_Children_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypeProposed_Children_ReferenceItem), var_export($supplier_DataTypeProposed_Children_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Proposed_Children_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Proposed_Children_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $proposed_Children_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setProposed_Children_Reference(array $proposed_Children_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($proposed_Children_ReferenceArrayErrorMessage = self::validateProposed_Children_ReferenceForArrayConstraintsFromSetProposed_Children_Reference($proposed_Children_Reference))) {
            throw new \InvalidArgumentException($proposed_Children_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Proposed_Children_Reference = $proposed_Children_Reference;
        return $this;
    }
    /**
     * Add item to Proposed_Children_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToProposed_Children_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Proposed_Children_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Proposed_Children_Reference[] = $item;
        return $this;
    }
    /**
     * Get Business_Entity_Data value
     * @return \StructType\Business_Entity_WWS_DataType|null
     */
    public function getBusiness_Entity_Data()
    {
        return $this->Business_Entity_Data;
    }
    /**
     * Set Business_Entity_Data value
     * @param \StructType\Business_Entity_WWS_DataType $business_Entity_Data
     * @return \StructType\Supplier_DataType
     */
    public function setBusiness_Entity_Data(\StructType\Business_Entity_WWS_DataType $business_Entity_Data = null)
    {
        $this->Business_Entity_Data = $business_Entity_Data;
        return $this;
    }
    /**
     * Get Settlement_Account_Widget_Data value
     * @return \StructType\Settlement_Account_WWS_Widget_DataType|null
     */
    public function getSettlement_Account_Widget_Data()
    {
        return $this->Settlement_Account_Widget_Data;
    }
    /**
     * Set Settlement_Account_Widget_Data value
     * @param \StructType\Settlement_Account_WWS_Widget_DataType $settlement_Account_Widget_Data
     * @return \StructType\Supplier_DataType
     */
    public function setSettlement_Account_Widget_Data(\StructType\Settlement_Account_WWS_Widget_DataType $settlement_Account_Widget_Data = null)
    {
        $this->Settlement_Account_Widget_Data = $settlement_Account_Widget_Data;
        return $this;
    }
    /**
     * Get Do_not_pay_during_Bank_Account_updates value
     * @return bool|null
     */
    public function getDo_not_pay_during_Bank_Account_updates()
    {
        return $this->Do_not_pay_during_Bank_Account_updates;
    }
    /**
     * Set Do_not_pay_during_Bank_Account_updates value
     * @param bool $do_not_pay_during_Bank_Account_updates
     * @return \StructType\Supplier_DataType
     */
    public function setDo_not_pay_during_Bank_Account_updates($do_not_pay_during_Bank_Account_updates = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_not_pay_during_Bank_Account_updates) && !is_bool($do_not_pay_during_Bank_Account_updates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_not_pay_during_Bank_Account_updates, true), gettype($do_not_pay_during_Bank_Account_updates)), __LINE__);
        }
        $this->Do_not_pay_during_Bank_Account_updates = $do_not_pay_during_Bank_Account_updates;
        return $this;
    }
    /**
     * Get Supplier_Status_Data value
     * @return \StructType\Supplier_Status_DataType[]|null
     */
    public function getSupplier_Status_Data()
    {
        return $this->Supplier_Status_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Status_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Status_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Status_DataForArrayConstraintsFromSetSupplier_Status_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeSupplier_Status_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeSupplier_Status_DataItem instanceof \StructType\Supplier_Status_DataType) {
                $invalidValues[] = is_object($supplier_DataTypeSupplier_Status_DataItem) ? get_class($supplier_DataTypeSupplier_Status_DataItem) : sprintf('%s(%s)', gettype($supplier_DataTypeSupplier_Status_DataItem), var_export($supplier_DataTypeSupplier_Status_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Status_Data property can only contain items of type \StructType\Supplier_Status_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Status_DataType[] $supplier_Status_Data
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Status_Data(array $supplier_Status_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Status_DataArrayErrorMessage = self::validateSupplier_Status_DataForArrayConstraintsFromSetSupplier_Status_Data($supplier_Status_Data))) {
            throw new \InvalidArgumentException($supplier_Status_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Status_Data = $supplier_Status_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Status_DataType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToSupplier_Status_Data(\StructType\Supplier_Status_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Status_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Status_Data property can only contain items of type \StructType\Supplier_Status_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Status_Data[] = $item;
        return $this;
    }
    /**
     * Get Proposed_Supplier_Status_Data value
     * @return \StructType\Proposed_Supplier_Status_DataType|null
     */
    public function getProposed_Supplier_Status_Data()
    {
        return $this->Proposed_Supplier_Status_Data;
    }
    /**
     * Set Proposed_Supplier_Status_Data value
     * @param \StructType\Proposed_Supplier_Status_DataType $proposed_Supplier_Status_Data
     * @return \StructType\Supplier_DataType
     */
    public function setProposed_Supplier_Status_Data(\StructType\Proposed_Supplier_Status_DataType $proposed_Supplier_Status_Data = null)
    {
        $this->Proposed_Supplier_Status_Data = $proposed_Supplier_Status_Data;
        return $this;
    }
    /**
     * Get Always_Separate_Payments value
     * @return bool|null
     */
    public function getAlways_Separate_Payments()
    {
        return $this->Always_Separate_Payments;
    }
    /**
     * Set Always_Separate_Payments value
     * @param bool $always_Separate_Payments
     * @return \StructType\Supplier_DataType
     */
    public function setAlways_Separate_Payments($always_Separate_Payments = null)
    {
        // validation for constraint: boolean
        if (!is_null($always_Separate_Payments) && !is_bool($always_Separate_Payments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($always_Separate_Payments, true), gettype($always_Separate_Payments)), __LINE__);
        }
        $this->Always_Separate_Payments = $always_Separate_Payments;
        return $this;
    }
    /**
     * Get Text_for_Default_Supplier_Payment_Memo value
     * @return string|null
     */
    public function getText_for_Default_Supplier_Payment_Memo()
    {
        return isset($this->Text_for_Default_Supplier_Payment_Memo) ? $this->Text_for_Default_Supplier_Payment_Memo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setText_for_Default_Supplier_Payment_Memo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText_for_Default_Supplier_Payment_Memo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateText_for_Default_Supplier_Payment_MemoForChoiceConstraintsFromSetText_for_Default_Supplier_Payment_Memo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Supplier_Reference_as_Default_Supplier_Payment_Memo',
            'Use_Invoice_Memo_as_Default_Supplier_Payment_Memo',
            'Use_Supplier_Connection_Memo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Text_for_Default_Supplier_Payment_Memo can\'t be set as the property %s is already set. Only one property must be set among these properties: Text_for_Default_Supplier_Payment_Memo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Text_for_Default_Supplier_Payment_Memo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $text_for_Default_Supplier_Payment_Memo
     * @return \StructType\Supplier_DataType
     */
    public function setText_for_Default_Supplier_Payment_Memo($text_for_Default_Supplier_Payment_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($text_for_Default_Supplier_Payment_Memo) && !is_string($text_for_Default_Supplier_Payment_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text_for_Default_Supplier_Payment_Memo, true), gettype($text_for_Default_Supplier_Payment_Memo)), __LINE__);
        }
        // validation for constraint: choice(Text_for_Default_Supplier_Payment_Memo, Use_Supplier_Reference_as_Default_Supplier_Payment_Memo, Use_Invoice_Memo_as_Default_Supplier_Payment_Memo, Use_Supplier_Connection_Memo)
        if ('' !== ($text_for_Default_Supplier_Payment_MemoChoiceErrorMessage = self::validateText_for_Default_Supplier_Payment_MemoForChoiceConstraintsFromSetText_for_Default_Supplier_Payment_Memo($text_for_Default_Supplier_Payment_Memo))) {
            throw new \InvalidArgumentException($text_for_Default_Supplier_Payment_MemoChoiceErrorMessage, __LINE__);
        }
        if (is_null($text_for_Default_Supplier_Payment_Memo) || (is_array($text_for_Default_Supplier_Payment_Memo) && empty($text_for_Default_Supplier_Payment_Memo))) {
            unset($this->Text_for_Default_Supplier_Payment_Memo);
        } else {
            $this->Text_for_Default_Supplier_Payment_Memo = $text_for_Default_Supplier_Payment_Memo;
        }
        return $this;
    }
    /**
     * Get Use_Supplier_Reference_as_Default_Supplier_Payment_Memo value
     * @return bool|null
     */
    public function getUse_Supplier_Reference_as_Default_Supplier_Payment_Memo()
    {
        return isset($this->Use_Supplier_Reference_as_Default_Supplier_Payment_Memo) ? $this->Use_Supplier_Reference_as_Default_Supplier_Payment_Memo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Supplier_Reference_as_Default_Supplier_Payment_Memo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Supplier_Reference_as_Default_Supplier_Payment_Memo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Supplier_Reference_as_Default_Supplier_Payment_MemoForChoiceConstraintsFromSetUse_Supplier_Reference_as_Default_Supplier_Payment_Memo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Text_for_Default_Supplier_Payment_Memo',
            'Use_Invoice_Memo_as_Default_Supplier_Payment_Memo',
            'Use_Supplier_Connection_Memo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Supplier_Reference_as_Default_Supplier_Payment_Memo can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Supplier_Reference_as_Default_Supplier_Payment_Memo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Supplier_Reference_as_Default_Supplier_Payment_Memo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Supplier_Reference_as_Default_Supplier_Payment_Memo
     * @return \StructType\Supplier_DataType
     */
    public function setUse_Supplier_Reference_as_Default_Supplier_Payment_Memo($use_Supplier_Reference_as_Default_Supplier_Payment_Memo = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Supplier_Reference_as_Default_Supplier_Payment_Memo) && !is_bool($use_Supplier_Reference_as_Default_Supplier_Payment_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Supplier_Reference_as_Default_Supplier_Payment_Memo, true), gettype($use_Supplier_Reference_as_Default_Supplier_Payment_Memo)), __LINE__);
        }
        // validation for constraint: choice(Text_for_Default_Supplier_Payment_Memo, Use_Supplier_Reference_as_Default_Supplier_Payment_Memo, Use_Invoice_Memo_as_Default_Supplier_Payment_Memo, Use_Supplier_Connection_Memo)
        if ('' !== ($use_Supplier_Reference_as_Default_Supplier_Payment_MemoChoiceErrorMessage = self::validateUse_Supplier_Reference_as_Default_Supplier_Payment_MemoForChoiceConstraintsFromSetUse_Supplier_Reference_as_Default_Supplier_Payment_Memo($use_Supplier_Reference_as_Default_Supplier_Payment_Memo))) {
            throw new \InvalidArgumentException($use_Supplier_Reference_as_Default_Supplier_Payment_MemoChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Supplier_Reference_as_Default_Supplier_Payment_Memo) || (is_array($use_Supplier_Reference_as_Default_Supplier_Payment_Memo) && empty($use_Supplier_Reference_as_Default_Supplier_Payment_Memo))) {
            unset($this->Use_Supplier_Reference_as_Default_Supplier_Payment_Memo);
        } else {
            $this->Use_Supplier_Reference_as_Default_Supplier_Payment_Memo = $use_Supplier_Reference_as_Default_Supplier_Payment_Memo;
        }
        return $this;
    }
    /**
     * Get Use_Invoice_Memo_as_Default_Supplier_Payment_Memo value
     * @return bool|null
     */
    public function getUse_Invoice_Memo_as_Default_Supplier_Payment_Memo()
    {
        return isset($this->Use_Invoice_Memo_as_Default_Supplier_Payment_Memo) ? $this->Use_Invoice_Memo_as_Default_Supplier_Payment_Memo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Invoice_Memo_as_Default_Supplier_Payment_Memo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Invoice_Memo_as_Default_Supplier_Payment_Memo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Invoice_Memo_as_Default_Supplier_Payment_MemoForChoiceConstraintsFromSetUse_Invoice_Memo_as_Default_Supplier_Payment_Memo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Text_for_Default_Supplier_Payment_Memo',
            'Use_Supplier_Reference_as_Default_Supplier_Payment_Memo',
            'Use_Supplier_Connection_Memo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Invoice_Memo_as_Default_Supplier_Payment_Memo can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Invoice_Memo_as_Default_Supplier_Payment_Memo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Invoice_Memo_as_Default_Supplier_Payment_Memo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Invoice_Memo_as_Default_Supplier_Payment_Memo
     * @return \StructType\Supplier_DataType
     */
    public function setUse_Invoice_Memo_as_Default_Supplier_Payment_Memo($use_Invoice_Memo_as_Default_Supplier_Payment_Memo = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Invoice_Memo_as_Default_Supplier_Payment_Memo) && !is_bool($use_Invoice_Memo_as_Default_Supplier_Payment_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Invoice_Memo_as_Default_Supplier_Payment_Memo, true), gettype($use_Invoice_Memo_as_Default_Supplier_Payment_Memo)), __LINE__);
        }
        // validation for constraint: choice(Text_for_Default_Supplier_Payment_Memo, Use_Supplier_Reference_as_Default_Supplier_Payment_Memo, Use_Invoice_Memo_as_Default_Supplier_Payment_Memo, Use_Supplier_Connection_Memo)
        if ('' !== ($use_Invoice_Memo_as_Default_Supplier_Payment_MemoChoiceErrorMessage = self::validateUse_Invoice_Memo_as_Default_Supplier_Payment_MemoForChoiceConstraintsFromSetUse_Invoice_Memo_as_Default_Supplier_Payment_Memo($use_Invoice_Memo_as_Default_Supplier_Payment_Memo))) {
            throw new \InvalidArgumentException($use_Invoice_Memo_as_Default_Supplier_Payment_MemoChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Invoice_Memo_as_Default_Supplier_Payment_Memo) || (is_array($use_Invoice_Memo_as_Default_Supplier_Payment_Memo) && empty($use_Invoice_Memo_as_Default_Supplier_Payment_Memo))) {
            unset($this->Use_Invoice_Memo_as_Default_Supplier_Payment_Memo);
        } else {
            $this->Use_Invoice_Memo_as_Default_Supplier_Payment_Memo = $use_Invoice_Memo_as_Default_Supplier_Payment_Memo;
        }
        return $this;
    }
    /**
     * Get Use_Supplier_Connection_Memo value
     * @return bool|null
     */
    public function getUse_Supplier_Connection_Memo()
    {
        return isset($this->Use_Supplier_Connection_Memo) ? $this->Use_Supplier_Connection_Memo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Supplier_Connection_Memo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Supplier_Connection_Memo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Supplier_Connection_MemoForChoiceConstraintsFromSetUse_Supplier_Connection_Memo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Text_for_Default_Supplier_Payment_Memo',
            'Use_Supplier_Reference_as_Default_Supplier_Payment_Memo',
            'Use_Invoice_Memo_as_Default_Supplier_Payment_Memo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Supplier_Connection_Memo can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Supplier_Connection_Memo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Supplier_Connection_Memo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Supplier_Connection_Memo
     * @return \StructType\Supplier_DataType
     */
    public function setUse_Supplier_Connection_Memo($use_Supplier_Connection_Memo = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Supplier_Connection_Memo) && !is_bool($use_Supplier_Connection_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Supplier_Connection_Memo, true), gettype($use_Supplier_Connection_Memo)), __LINE__);
        }
        // validation for constraint: choice(Text_for_Default_Supplier_Payment_Memo, Use_Supplier_Reference_as_Default_Supplier_Payment_Memo, Use_Invoice_Memo_as_Default_Supplier_Payment_Memo, Use_Supplier_Connection_Memo)
        if ('' !== ($use_Supplier_Connection_MemoChoiceErrorMessage = self::validateUse_Supplier_Connection_MemoForChoiceConstraintsFromSetUse_Supplier_Connection_Memo($use_Supplier_Connection_Memo))) {
            throw new \InvalidArgumentException($use_Supplier_Connection_MemoChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Supplier_Connection_Memo) || (is_array($use_Supplier_Connection_Memo) && empty($use_Supplier_Connection_Memo))) {
            unset($this->Use_Supplier_Connection_Memo);
        } else {
            $this->Use_Supplier_Connection_Memo = $use_Supplier_Connection_Memo;
        }
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Accepted_Currencies_Reference value
     * @return \StructType\CurrencyObjectType[]|null
     */
    public function getAccepted_Currencies_Reference()
    {
        return $this->Accepted_Currencies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAccepted_Currencies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccepted_Currencies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccepted_Currencies_ReferenceForArrayConstraintsFromSetAccepted_Currencies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeAccepted_Currencies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeAccepted_Currencies_ReferenceItem instanceof \StructType\CurrencyObjectType) {
                $invalidValues[] = is_object($supplier_DataTypeAccepted_Currencies_ReferenceItem) ? get_class($supplier_DataTypeAccepted_Currencies_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypeAccepted_Currencies_ReferenceItem), var_export($supplier_DataTypeAccepted_Currencies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accepted_Currencies_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accepted_Currencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType[] $accepted_Currencies_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setAccepted_Currencies_Reference(array $accepted_Currencies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($accepted_Currencies_ReferenceArrayErrorMessage = self::validateAccepted_Currencies_ReferenceForArrayConstraintsFromSetAccepted_Currencies_Reference($accepted_Currencies_Reference))) {
            throw new \InvalidArgumentException($accepted_Currencies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Accepted_Currencies_Reference = $accepted_Currencies_Reference;
        return $this;
    }
    /**
     * Add item to Accepted_Currencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToAccepted_Currencies_Reference(\StructType\CurrencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Accepted_Currencies_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accepted_Currencies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Classification_Widget_Data value
     * @return \StructType\Supplier_Classification_Widget_DataType|null
     */
    public function getSupplier_Classification_Widget_Data()
    {
        return $this->Supplier_Classification_Widget_Data;
    }
    /**
     * Set Supplier_Classification_Widget_Data value
     * @param \StructType\Supplier_Classification_Widget_DataType $supplier_Classification_Widget_Data
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Classification_Widget_Data(\StructType\Supplier_Classification_Widget_DataType $supplier_Classification_Widget_Data = null)
    {
        $this->Supplier_Classification_Widget_Data = $supplier_Classification_Widget_Data;
        return $this;
    }
    /**
     * Get Integration_System_Reference value
     * @return \StructType\Integration_System__Audited_ObjectType|null
     */
    public function getIntegration_System_Reference()
    {
        return $this->Integration_System_Reference;
    }
    /**
     * Set Integration_System_Reference value
     * @param \StructType\Integration_System__Audited_ObjectType $integration_System_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setIntegration_System_Reference(\StructType\Integration_System__Audited_ObjectType $integration_System_Reference = null)
    {
        $this->Integration_System_Reference = $integration_System_Reference;
        return $this;
    }
    /**
     * Get Do_Not_Reimburse_Contingent_Worker_Expense_Reports value
     * @return bool|null
     */
    public function getDo_Not_Reimburse_Contingent_Worker_Expense_Reports()
    {
        return $this->Do_Not_Reimburse_Contingent_Worker_Expense_Reports;
    }
    /**
     * Set Do_Not_Reimburse_Contingent_Worker_Expense_Reports value
     * @param bool $do_Not_Reimburse_Contingent_Worker_Expense_Reports
     * @return \StructType\Supplier_DataType
     */
    public function setDo_Not_Reimburse_Contingent_Worker_Expense_Reports($do_Not_Reimburse_Contingent_Worker_Expense_Reports = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_Not_Reimburse_Contingent_Worker_Expense_Reports) && !is_bool($do_Not_Reimburse_Contingent_Worker_Expense_Reports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_Not_Reimburse_Contingent_Worker_Expense_Reports, true), gettype($do_Not_Reimburse_Contingent_Worker_Expense_Reports)), __LINE__);
        }
        $this->Do_Not_Reimburse_Contingent_Worker_Expense_Reports = $do_Not_Reimburse_Contingent_Worker_Expense_Reports;
        return $this;
    }
    /**
     * Get Supplier_Security_Segment_Reference value
     * @return \StructType\Supplier_Security_SegmentObjectType|null
     */
    public function getSupplier_Security_Segment_Reference()
    {
        return $this->Supplier_Security_Segment_Reference;
    }
    /**
     * Set Supplier_Security_Segment_Reference value
     * @param \StructType\Supplier_Security_SegmentObjectType $supplier_Security_Segment_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Security_Segment_Reference(\StructType\Supplier_Security_SegmentObjectType $supplier_Security_Segment_Reference = null)
    {
        $this->Supplier_Security_Segment_Reference = $supplier_Security_Segment_Reference;
        return $this;
    }
    /**
     * Get Supplier_Note_Follow_Up_Date value
     * @return string|null
     */
    public function getSupplier_Note_Follow_Up_Date()
    {
        return $this->{'Supplier_Note_Follow-Up_Date'};
    }
    /**
     * Set Supplier_Note_Follow_Up_Date value
     * @param string $supplier_Note_Follow_Up_Date
     * @return \StructType\Supplier_DataType
     */
    public function setSupplier_Note_Follow_Up_Date($supplier_Note_Follow_Up_Date = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Note_Follow_Up_Date) && !is_string($supplier_Note_Follow_Up_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Note_Follow_Up_Date, true), gettype($supplier_Note_Follow_Up_Date)), __LINE__);
        }
        $this->Supplier_Note_Follow_Up_Date = $this->{'Supplier_Note_Follow-Up_Date'} = $supplier_Note_Follow_Up_Date;
        return $this;
    }
    /**
     * Get Business_Entity_Alternate_Name_Widget_Data value
     * @return \StructType\Business_Entity_Alternate_Name_Widget_DataType|null
     */
    public function getBusiness_Entity_Alternate_Name_Widget_Data()
    {
        return $this->Business_Entity_Alternate_Name_Widget_Data;
    }
    /**
     * Set Business_Entity_Alternate_Name_Widget_Data value
     * @param \StructType\Business_Entity_Alternate_Name_Widget_DataType $business_Entity_Alternate_Name_Widget_Data
     * @return \StructType\Supplier_DataType
     */
    public function setBusiness_Entity_Alternate_Name_Widget_Data(\StructType\Business_Entity_Alternate_Name_Widget_DataType $business_Entity_Alternate_Name_Widget_Data = null)
    {
        $this->Business_Entity_Alternate_Name_Widget_Data = $business_Entity_Alternate_Name_Widget_Data;
        return $this;
    }
    /**
     * Get Financials_Attachment_Widget_Data value
     * @return \StructType\Financials_Attachment_Widget_DataType|null
     */
    public function getFinancials_Attachment_Widget_Data()
    {
        return $this->Financials_Attachment_Widget_Data;
    }
    /**
     * Set Financials_Attachment_Widget_Data value
     * @param \StructType\Financials_Attachment_Widget_DataType $financials_Attachment_Widget_Data
     * @return \StructType\Supplier_DataType
     */
    public function setFinancials_Attachment_Widget_Data(\StructType\Financials_Attachment_Widget_DataType $financials_Attachment_Widget_Data = null)
    {
        $this->Financials_Attachment_Widget_Data = $financials_Attachment_Widget_Data;
        return $this;
    }
    /**
     * Get Note_Data value
     * @return \StructType\Note_WWS_DataType[]|null
     */
    public function getNote_Data()
    {
        return $this->Note_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setNote_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNote_DataForArrayConstraintsFromSetNote_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeNote_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeNote_DataItem instanceof \StructType\Note_WWS_DataType) {
                $invalidValues[] = is_object($supplier_DataTypeNote_DataItem) ? get_class($supplier_DataTypeNote_DataItem) : sprintf('%s(%s)', gettype($supplier_DataTypeNote_DataItem), var_export($supplier_DataTypeNote_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note_Data property can only contain items of type \StructType\Note_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Note_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Note_WWS_DataType[] $note_Data
     * @return \StructType\Supplier_DataType
     */
    public function setNote_Data(array $note_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($note_DataArrayErrorMessage = self::validateNote_DataForArrayConstraintsFromSetNote_Data($note_Data))) {
            throw new \InvalidArgumentException($note_DataArrayErrorMessage, __LINE__);
        }
        $this->Note_Data = $note_Data;
        return $this;
    }
    /**
     * Add item to Note_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Note_WWS_DataType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToNote_Data(\StructType\Note_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Note_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Note_Data property can only contain items of type \StructType\Note_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note_Data[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_or_Hierarchy_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_or_Hierarchy_Reference()
    {
        return $this->Spend_Category_or_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_or_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_or_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_DataTypeSpend_Category_or_Hierarchy_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($supplier_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) ? get_class($supplier_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_DataTypeSpend_Category_or_Hierarchy_ReferenceItem), var_export($supplier_DataTypeSpend_Category_or_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setSpend_Category_or_Hierarchy_Reference(array $spend_Category_or_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage = self::validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference = $spend_Category_or_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Supplier_DataType
     */
    public function addToSpend_Category_or_Hierarchy_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Default_Procurement_Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getDefault_Procurement_Item_Reference()
    {
        return $this->Default_Procurement_Item_Reference;
    }
    /**
     * Set Default_Procurement_Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $default_Procurement_Item_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setDefault_Procurement_Item_Reference(\StructType\Procurement_ItemObjectType $default_Procurement_Item_Reference = null)
    {
        $this->Default_Procurement_Item_Reference = $default_Procurement_Item_Reference;
        return $this;
    }
    /**
     * Get Default_Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getDefault_Spend_Category_Reference()
    {
        return $this->Default_Spend_Category_Reference;
    }
    /**
     * Set Default_Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $default_Spend_Category_Reference
     * @return \StructType\Supplier_DataType
     */
    public function setDefault_Spend_Category_Reference(\StructType\Spend_CategoryObjectType $default_Spend_Category_Reference = null)
    {
        $this->Default_Spend_Category_Reference = $default_Spend_Category_Reference;
        return $this;
    }
    /**
     * Get Related_Worktag_Data value
     * @return \StructType\Related_Worktag_Widget_DataType|null
     */
    public function getRelated_Worktag_Data()
    {
        return $this->Related_Worktag_Data;
    }
    /**
     * Set Related_Worktag_Data value
     * @param \StructType\Related_Worktag_Widget_DataType $related_Worktag_Data
     * @return \StructType\Supplier_DataType
     */
    public function setRelated_Worktag_Data(\StructType\Related_Worktag_Widget_DataType $related_Worktag_Data = null)
    {
        $this->Related_Worktag_Data = $related_Worktag_Data;
        return $this;
    }
    /**
     * Get Areas_Changed value
     * @return \StructType\Areas_Changed_WWS_DataType|null
     */
    public function getAreas_Changed()
    {
        return $this->Areas_Changed;
    }
    /**
     * Set Areas_Changed value
     * @param \StructType\Areas_Changed_WWS_DataType $areas_Changed
     * @return \StructType\Supplier_DataType
     */
    public function setAreas_Changed(\StructType\Areas_Changed_WWS_DataType $areas_Changed = null)
    {
        $this->Areas_Changed = $areas_Changed;
        return $this;
    }
}
