<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Connection_LineType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Element contains individual Supplier Connection attributes
 * @subpackage Structs
 */
class Supplier_Connection_LineType extends AbstractStructBase
{
    /**
     * The Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Connection Reference
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_Reference;
    /**
     * The Supplier_Connection_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Connection ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Connection_ID;
    /**
     * The Supplier_Connection_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Connection Name
     * - maxOccurs: 1
     * @var string
     */
    public $Supplier_Connection_Name;
    /**
     * The Remit_To_Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Remit To Supplier Reference for the Supplier Connection
     * @var \StructType\SupplierObjectType
     */
    public $Remit_To_Supplier_Reference;
    /**
     * The Default_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Payment Type
     * @var \StructType\Payment_TypeObjectType
     */
    public $Default_Payment_Type_Reference;
    /**
     * The Accepted_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Accepted Payment Types
     * - maxOccurs: unbounded
     * @var \StructType\Payment_TypeObjectType[]
     */
    public $Accepted_Payment_Type_Reference;
    /**
     * The Settlement_Bank_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Settlement Bank Account for this Supplier Connection
     * - minOccurs: 0
     * @var \StructType\Settlement_Bank_AccountObjectType
     */
    public $Settlement_Bank_Account_Reference;
    /**
     * The Remit_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Remit To address Reference for the Supplier Connection
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Remit_To_Address_Reference;
    /**
     * The Remit_To_Email_Address
     * Meta information extracted from the WSDL
     * - documentation: Remit To Email for the Supplier Connection
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remit_To_Email_Address;
    /**
     * The Payee_Alternate_Name_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payee Alternate Name Reference for the Supplier Connection
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Payee_Alternate_Name_Reference;
    /**
     * The Payee_Alternate_Name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType[]
     */
    public $Payee_Alternate_Name;
    /**
     * The Payment_Memo
     * Meta information extracted from the WSDL
     * - documentation: Payment Memo for the Supplier Connection
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payment_Memo;
    /**
     * The Is_Default
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate if the Supplier Connection is the Default one
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Default;
    /**
     * The Default_Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Payment Terms for the Remit to Connection
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Default_Payment_Terms_Reference;
    /**
     * The Default_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Currency for the Remit to Connection
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Default_Currency_Reference;
    /**
     * The Always_Separate_Payments
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate if Always Separate Payments
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Always_Separate_Payments;
    /**
     * The Do_not_pay_during_Bank_Account_updates
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate Do not pay during Bank Account updates
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_not_pay_during_Bank_Account_updates;
    /**
     * The Remit_to_Supplier_Connection_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Remit to Supplier Connection Snapshot Status Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType[]
     */
    public $Remit_to_Supplier_Connection_Status_Data;
    /**
     * Constructor method for Supplier_Connection_LineType
     * @uses Supplier_Connection_LineType::setSupplier_Connection_Reference()
     * @uses Supplier_Connection_LineType::setSupplier_Connection_ID()
     * @uses Supplier_Connection_LineType::setSupplier_Connection_Name()
     * @uses Supplier_Connection_LineType::setRemit_To_Supplier_Reference()
     * @uses Supplier_Connection_LineType::setDefault_Payment_Type_Reference()
     * @uses Supplier_Connection_LineType::setAccepted_Payment_Type_Reference()
     * @uses Supplier_Connection_LineType::setSettlement_Bank_Account_Reference()
     * @uses Supplier_Connection_LineType::setRemit_To_Address_Reference()
     * @uses Supplier_Connection_LineType::setRemit_To_Email_Address()
     * @uses Supplier_Connection_LineType::setPayee_Alternate_Name_Reference()
     * @uses Supplier_Connection_LineType::setPayee_Alternate_Name()
     * @uses Supplier_Connection_LineType::setPayment_Memo()
     * @uses Supplier_Connection_LineType::setIs_Default()
     * @uses Supplier_Connection_LineType::setDefault_Payment_Terms_Reference()
     * @uses Supplier_Connection_LineType::setDefault_Currency_Reference()
     * @uses Supplier_Connection_LineType::setAlways_Separate_Payments()
     * @uses Supplier_Connection_LineType::setDo_not_pay_during_Bank_Account_updates()
     * @uses Supplier_Connection_LineType::setRemit_to_Supplier_Connection_Status_Data()
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @param string $supplier_Connection_ID
     * @param string $supplier_Connection_Name
     * @param \StructType\SupplierObjectType $remit_To_Supplier_Reference
     * @param \StructType\Payment_TypeObjectType $default_Payment_Type_Reference
     * @param \StructType\Payment_TypeObjectType[] $accepted_Payment_Type_Reference
     * @param \StructType\Settlement_Bank_AccountObjectType $settlement_Bank_Account_Reference
     * @param \StructType\Address_ReferenceObjectType $remit_To_Address_Reference
     * @param string $remit_To_Email_Address
     * @param \StructType\Unique_IdentifierObjectType[] $payee_Alternate_Name_Reference
     * @param \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType[] $payee_Alternate_Name
     * @param string $payment_Memo
     * @param bool $is_Default
     * @param \StructType\Payment_TermsObjectType $default_Payment_Terms_Reference
     * @param \StructType\CurrencyObjectType $default_Currency_Reference
     * @param bool $always_Separate_Payments
     * @param bool $do_not_pay_during_Bank_Account_updates
     * @param \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType[] $remit_to_Supplier_Connection_Status_Data
     */
    public function __construct(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null, $supplier_Connection_ID = null, $supplier_Connection_Name = null, \StructType\SupplierObjectType $remit_To_Supplier_Reference = null, \StructType\Payment_TypeObjectType $default_Payment_Type_Reference = null, array $accepted_Payment_Type_Reference = array(), \StructType\Settlement_Bank_AccountObjectType $settlement_Bank_Account_Reference = null, \StructType\Address_ReferenceObjectType $remit_To_Address_Reference = null, $remit_To_Email_Address = null, array $payee_Alternate_Name_Reference = array(), array $payee_Alternate_Name = array(), $payment_Memo = null, $is_Default = null, \StructType\Payment_TermsObjectType $default_Payment_Terms_Reference = null, \StructType\CurrencyObjectType $default_Currency_Reference = null, $always_Separate_Payments = null, $do_not_pay_during_Bank_Account_updates = null, array $remit_to_Supplier_Connection_Status_Data = array())
    {
        $this
            ->setSupplier_Connection_Reference($supplier_Connection_Reference)
            ->setSupplier_Connection_ID($supplier_Connection_ID)
            ->setSupplier_Connection_Name($supplier_Connection_Name)
            ->setRemit_To_Supplier_Reference($remit_To_Supplier_Reference)
            ->setDefault_Payment_Type_Reference($default_Payment_Type_Reference)
            ->setAccepted_Payment_Type_Reference($accepted_Payment_Type_Reference)
            ->setSettlement_Bank_Account_Reference($settlement_Bank_Account_Reference)
            ->setRemit_To_Address_Reference($remit_To_Address_Reference)
            ->setRemit_To_Email_Address($remit_To_Email_Address)
            ->setPayee_Alternate_Name_Reference($payee_Alternate_Name_Reference)
            ->setPayee_Alternate_Name($payee_Alternate_Name)
            ->setPayment_Memo($payment_Memo)
            ->setIs_Default($is_Default)
            ->setDefault_Payment_Terms_Reference($default_Payment_Terms_Reference)
            ->setDefault_Currency_Reference($default_Currency_Reference)
            ->setAlways_Separate_Payments($always_Separate_Payments)
            ->setDo_not_pay_during_Bank_Account_updates($do_not_pay_during_Bank_Account_updates)
            ->setRemit_to_Supplier_Connection_Status_Data($remit_to_Supplier_Connection_Status_Data);
    }
    /**
     * Get Supplier_Connection_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_Reference()
    {
        return $this->Supplier_Connection_Reference;
    }
    /**
     * Set Supplier_Connection_Reference value
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setSupplier_Connection_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null)
    {
        $this->Supplier_Connection_Reference = $supplier_Connection_Reference;
        return $this;
    }
    /**
     * Get Supplier_Connection_ID value
     * @return string|null
     */
    public function getSupplier_Connection_ID()
    {
        return $this->Supplier_Connection_ID;
    }
    /**
     * Set Supplier_Connection_ID value
     * @param string $supplier_Connection_ID
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setSupplier_Connection_ID($supplier_Connection_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Connection_ID) && !is_string($supplier_Connection_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Connection_ID, true), gettype($supplier_Connection_ID)), __LINE__);
        }
        $this->Supplier_Connection_ID = $supplier_Connection_ID;
        return $this;
    }
    /**
     * Get Supplier_Connection_Name value
     * @return string|null
     */
    public function getSupplier_Connection_Name()
    {
        return $this->Supplier_Connection_Name;
    }
    /**
     * Set Supplier_Connection_Name value
     * @param string $supplier_Connection_Name
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setSupplier_Connection_Name($supplier_Connection_Name = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Connection_Name) && !is_string($supplier_Connection_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Connection_Name, true), gettype($supplier_Connection_Name)), __LINE__);
        }
        $this->Supplier_Connection_Name = $supplier_Connection_Name;
        return $this;
    }
    /**
     * Get Remit_To_Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getRemit_To_Supplier_Reference()
    {
        return $this->Remit_To_Supplier_Reference;
    }
    /**
     * Set Remit_To_Supplier_Reference value
     * @param \StructType\SupplierObjectType $remit_To_Supplier_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setRemit_To_Supplier_Reference(\StructType\SupplierObjectType $remit_To_Supplier_Reference = null)
    {
        $this->Remit_To_Supplier_Reference = $remit_To_Supplier_Reference;
        return $this;
    }
    /**
     * Get Default_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getDefault_Payment_Type_Reference()
    {
        return $this->Default_Payment_Type_Reference;
    }
    /**
     * Set Default_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $default_Payment_Type_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setDefault_Payment_Type_Reference(\StructType\Payment_TypeObjectType $default_Payment_Type_Reference = null)
    {
        $this->Default_Payment_Type_Reference = $default_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Accepted_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType[]|null
     */
    public function getAccepted_Payment_Type_Reference()
    {
        return $this->Accepted_Payment_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAccepted_Payment_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccepted_Payment_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccepted_Payment_Type_ReferenceForArrayConstraintsFromSetAccepted_Payment_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Connection_LineTypeAccepted_Payment_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Connection_LineTypeAccepted_Payment_Type_ReferenceItem instanceof \StructType\Payment_TypeObjectType) {
                $invalidValues[] = is_object($supplier_Connection_LineTypeAccepted_Payment_Type_ReferenceItem) ? get_class($supplier_Connection_LineTypeAccepted_Payment_Type_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Connection_LineTypeAccepted_Payment_Type_ReferenceItem), var_export($supplier_Connection_LineTypeAccepted_Payment_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accepted_Payment_Type_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accepted_Payment_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType[] $accepted_Payment_Type_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setAccepted_Payment_Type_Reference(array $accepted_Payment_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($accepted_Payment_Type_ReferenceArrayErrorMessage = self::validateAccepted_Payment_Type_ReferenceForArrayConstraintsFromSetAccepted_Payment_Type_Reference($accepted_Payment_Type_Reference))) {
            throw new \InvalidArgumentException($accepted_Payment_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Accepted_Payment_Type_Reference = $accepted_Payment_Type_Reference;
        return $this;
    }
    /**
     * Add item to Accepted_Payment_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType $item
     * @return \StructType\Supplier_Connection_LineType
     */
    public function addToAccepted_Payment_Type_Reference(\StructType\Payment_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Accepted_Payment_Type_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accepted_Payment_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Settlement_Bank_Account_Reference value
     * @return \StructType\Settlement_Bank_AccountObjectType|null
     */
    public function getSettlement_Bank_Account_Reference()
    {
        return $this->Settlement_Bank_Account_Reference;
    }
    /**
     * Set Settlement_Bank_Account_Reference value
     * @param \StructType\Settlement_Bank_AccountObjectType $settlement_Bank_Account_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setSettlement_Bank_Account_Reference(\StructType\Settlement_Bank_AccountObjectType $settlement_Bank_Account_Reference = null)
    {
        $this->Settlement_Bank_Account_Reference = $settlement_Bank_Account_Reference;
        return $this;
    }
    /**
     * Get Remit_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getRemit_To_Address_Reference()
    {
        return $this->Remit_To_Address_Reference;
    }
    /**
     * Set Remit_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $remit_To_Address_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setRemit_To_Address_Reference(\StructType\Address_ReferenceObjectType $remit_To_Address_Reference = null)
    {
        $this->Remit_To_Address_Reference = $remit_To_Address_Reference;
        return $this;
    }
    /**
     * Get Remit_To_Email_Address value
     * @return string|null
     */
    public function getRemit_To_Email_Address()
    {
        return $this->Remit_To_Email_Address;
    }
    /**
     * Set Remit_To_Email_Address value
     * @param string $remit_To_Email_Address
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setRemit_To_Email_Address($remit_To_Email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($remit_To_Email_Address) && !is_string($remit_To_Email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remit_To_Email_Address, true), gettype($remit_To_Email_Address)), __LINE__);
        }
        $this->Remit_To_Email_Address = $remit_To_Email_Address;
        return $this;
    }
    /**
     * Get Payee_Alternate_Name_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getPayee_Alternate_Name_Reference()
    {
        return $this->Payee_Alternate_Name_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPayee_Alternate_Name_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayee_Alternate_Name_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayee_Alternate_Name_ReferenceForArrayConstraintsFromSetPayee_Alternate_Name_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Connection_LineTypePayee_Alternate_Name_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Connection_LineTypePayee_Alternate_Name_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($supplier_Connection_LineTypePayee_Alternate_Name_ReferenceItem) ? get_class($supplier_Connection_LineTypePayee_Alternate_Name_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Connection_LineTypePayee_Alternate_Name_ReferenceItem), var_export($supplier_Connection_LineTypePayee_Alternate_Name_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payee_Alternate_Name_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payee_Alternate_Name_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $payee_Alternate_Name_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setPayee_Alternate_Name_Reference(array $payee_Alternate_Name_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($payee_Alternate_Name_ReferenceArrayErrorMessage = self::validatePayee_Alternate_Name_ReferenceForArrayConstraintsFromSetPayee_Alternate_Name_Reference($payee_Alternate_Name_Reference))) {
            throw new \InvalidArgumentException($payee_Alternate_Name_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Payee_Alternate_Name_Reference = $payee_Alternate_Name_Reference;
        return $this;
    }
    /**
     * Add item to Payee_Alternate_Name_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Supplier_Connection_LineType
     */
    public function addToPayee_Alternate_Name_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Payee_Alternate_Name_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payee_Alternate_Name_Reference[] = $item;
        return $this;
    }
    /**
     * Get Payee_Alternate_Name value
     * @return \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType[]|null
     */
    public function getPayee_Alternate_Name()
    {
        return $this->Payee_Alternate_Name;
    }
    /**
     * This method is responsible for validating the values passed to the setPayee_Alternate_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayee_Alternate_Name method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayee_Alternate_NameForArrayConstraintsFromSetPayee_Alternate_Name(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Connection_LineTypePayee_Alternate_NameItem) {
            // validation for constraint: itemType
            if (!$supplier_Connection_LineTypePayee_Alternate_NameItem instanceof \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType) {
                $invalidValues[] = is_object($supplier_Connection_LineTypePayee_Alternate_NameItem) ? get_class($supplier_Connection_LineTypePayee_Alternate_NameItem) : sprintf('%s(%s)', gettype($supplier_Connection_LineTypePayee_Alternate_NameItem), var_export($supplier_Connection_LineTypePayee_Alternate_NameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payee_Alternate_Name property can only contain items of type \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payee_Alternate_Name value
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType[] $payee_Alternate_Name
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setPayee_Alternate_Name(array $payee_Alternate_Name = array())
    {
        // validation for constraint: array
        if ('' !== ($payee_Alternate_NameArrayErrorMessage = self::validatePayee_Alternate_NameForArrayConstraintsFromSetPayee_Alternate_Name($payee_Alternate_Name))) {
            throw new \InvalidArgumentException($payee_Alternate_NameArrayErrorMessage, __LINE__);
        }
        $this->Payee_Alternate_Name = $payee_Alternate_Name;
        return $this;
    }
    /**
     * Add item to Payee_Alternate_Name value
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType $item
     * @return \StructType\Supplier_Connection_LineType
     */
    public function addToPayee_Alternate_Name(\StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType) {
            throw new \InvalidArgumentException(sprintf('The Payee_Alternate_Name property can only contain items of type \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payee_Alternate_Name[] = $item;
        return $this;
    }
    /**
     * Get Payment_Memo value
     * @return string|null
     */
    public function getPayment_Memo()
    {
        return $this->Payment_Memo;
    }
    /**
     * Set Payment_Memo value
     * @param string $payment_Memo
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setPayment_Memo($payment_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Memo) && !is_string($payment_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Memo, true), gettype($payment_Memo)), __LINE__);
        }
        $this->Payment_Memo = $payment_Memo;
        return $this;
    }
    /**
     * Get Is_Default value
     * @return bool|null
     */
    public function getIs_Default()
    {
        return $this->Is_Default;
    }
    /**
     * Set Is_Default value
     * @param bool $is_Default
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setIs_Default($is_Default = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Default) && !is_bool($is_Default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Default, true), gettype($is_Default)), __LINE__);
        }
        $this->Is_Default = $is_Default;
        return $this;
    }
    /**
     * Get Default_Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getDefault_Payment_Terms_Reference()
    {
        return $this->Default_Payment_Terms_Reference;
    }
    /**
     * Set Default_Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $default_Payment_Terms_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setDefault_Payment_Terms_Reference(\StructType\Payment_TermsObjectType $default_Payment_Terms_Reference = null)
    {
        $this->Default_Payment_Terms_Reference = $default_Payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Default_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getDefault_Currency_Reference()
    {
        return $this->Default_Currency_Reference;
    }
    /**
     * Set Default_Currency_Reference value
     * @param \StructType\CurrencyObjectType $default_Currency_Reference
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setDefault_Currency_Reference(\StructType\CurrencyObjectType $default_Currency_Reference = null)
    {
        $this->Default_Currency_Reference = $default_Currency_Reference;
        return $this;
    }
    /**
     * Get Always_Separate_Payments value
     * @return bool|null
     */
    public function getAlways_Separate_Payments()
    {
        return $this->Always_Separate_Payments;
    }
    /**
     * Set Always_Separate_Payments value
     * @param bool $always_Separate_Payments
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setAlways_Separate_Payments($always_Separate_Payments = null)
    {
        // validation for constraint: boolean
        if (!is_null($always_Separate_Payments) && !is_bool($always_Separate_Payments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($always_Separate_Payments, true), gettype($always_Separate_Payments)), __LINE__);
        }
        $this->Always_Separate_Payments = $always_Separate_Payments;
        return $this;
    }
    /**
     * Get Do_not_pay_during_Bank_Account_updates value
     * @return bool|null
     */
    public function getDo_not_pay_during_Bank_Account_updates()
    {
        return $this->Do_not_pay_during_Bank_Account_updates;
    }
    /**
     * Set Do_not_pay_during_Bank_Account_updates value
     * @param bool $do_not_pay_during_Bank_Account_updates
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setDo_not_pay_during_Bank_Account_updates($do_not_pay_during_Bank_Account_updates = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_not_pay_during_Bank_Account_updates) && !is_bool($do_not_pay_during_Bank_Account_updates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_not_pay_during_Bank_Account_updates, true), gettype($do_not_pay_during_Bank_Account_updates)), __LINE__);
        }
        $this->Do_not_pay_during_Bank_Account_updates = $do_not_pay_during_Bank_Account_updates;
        return $this;
    }
    /**
     * Get Remit_to_Supplier_Connection_Status_Data value
     * @return \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType[]|null
     */
    public function getRemit_to_Supplier_Connection_Status_Data()
    {
        return $this->Remit_to_Supplier_Connection_Status_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRemit_to_Supplier_Connection_Status_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemit_to_Supplier_Connection_Status_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemit_to_Supplier_Connection_Status_DataForArrayConstraintsFromSetRemit_to_Supplier_Connection_Status_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Connection_LineTypeRemit_to_Supplier_Connection_Status_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Connection_LineTypeRemit_to_Supplier_Connection_Status_DataItem instanceof \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType) {
                $invalidValues[] = is_object($supplier_Connection_LineTypeRemit_to_Supplier_Connection_Status_DataItem) ? get_class($supplier_Connection_LineTypeRemit_to_Supplier_Connection_Status_DataItem) : sprintf('%s(%s)', gettype($supplier_Connection_LineTypeRemit_to_Supplier_Connection_Status_DataItem), var_export($supplier_Connection_LineTypeRemit_to_Supplier_Connection_Status_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remit_to_Supplier_Connection_Status_Data property can only contain items of type \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remit_to_Supplier_Connection_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType[] $remit_to_Supplier_Connection_Status_Data
     * @return \StructType\Supplier_Connection_LineType
     */
    public function setRemit_to_Supplier_Connection_Status_Data(array $remit_to_Supplier_Connection_Status_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($remit_to_Supplier_Connection_Status_DataArrayErrorMessage = self::validateRemit_to_Supplier_Connection_Status_DataForArrayConstraintsFromSetRemit_to_Supplier_Connection_Status_Data($remit_to_Supplier_Connection_Status_Data))) {
            throw new \InvalidArgumentException($remit_to_Supplier_Connection_Status_DataArrayErrorMessage, __LINE__);
        }
        $this->Remit_to_Supplier_Connection_Status_Data = $remit_to_Supplier_Connection_Status_Data;
        return $this;
    }
    /**
     * Add item to Remit_to_Supplier_Connection_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType $item
     * @return \StructType\Supplier_Connection_LineType
     */
    public function addToRemit_to_Supplier_Connection_Status_Data(\StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType) {
            throw new \InvalidArgumentException(sprintf('The Remit_to_Supplier_Connection_Status_Data property can only contain items of type \StructType\Remit_to_Supplier_Connection_Snapshot_Status_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remit_to_Supplier_Connection_Status_Data[] = $item;
        return $this;
    }
}
