<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Classification Instance and Data
 * @subpackage Structs
 */
class Supplier_Classification_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Classification
     * Meta information extracted from the WSDL
     * - documentation: Supplier Classification
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ClassificationType[]
     */
    public $Supplier_Classification;
    /**
     * Constructor method for Supplier_Classification_Response_DataType
     * @uses Supplier_Classification_Response_DataType::setSupplier_Classification()
     * @param \StructType\Supplier_ClassificationType[] $supplier_Classification
     */
    public function __construct(array $supplier_Classification = array())
    {
        $this
            ->setSupplier_Classification($supplier_Classification);
    }
    /**
     * Get Supplier_Classification value
     * @return \StructType\Supplier_ClassificationType[]|null
     */
    public function getSupplier_Classification()
    {
        return $this->Supplier_Classification;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Classification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Classification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ClassificationForArrayConstraintsFromSetSupplier_Classification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Response_DataTypeSupplier_ClassificationItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Response_DataTypeSupplier_ClassificationItem instanceof \StructType\Supplier_ClassificationType) {
                $invalidValues[] = is_object($supplier_Classification_Response_DataTypeSupplier_ClassificationItem) ? get_class($supplier_Classification_Response_DataTypeSupplier_ClassificationItem) : sprintf('%s(%s)', gettype($supplier_Classification_Response_DataTypeSupplier_ClassificationItem), var_export($supplier_Classification_Response_DataTypeSupplier_ClassificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Classification property can only contain items of type \StructType\Supplier_ClassificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Classification value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ClassificationType[] $supplier_Classification
     * @return \StructType\Supplier_Classification_Response_DataType
     */
    public function setSupplier_Classification(array $supplier_Classification = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ClassificationArrayErrorMessage = self::validateSupplier_ClassificationForArrayConstraintsFromSetSupplier_Classification($supplier_Classification))) {
            throw new \InvalidArgumentException($supplier_ClassificationArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Classification = $supplier_Classification;
        return $this;
    }
    /**
     * Add item to Supplier_Classification value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ClassificationType $item
     * @return \StructType\Supplier_Classification_Response_DataType
     */
    public function addToSupplier_Classification(\StructType\Supplier_ClassificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ClassificationType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Classification property can only contain items of type \StructType\Supplier_ClassificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Classification[] = $item;
        return $this;
    }
}
