<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Return_Line_Split_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: One split for the corresponding return line.
 * @subpackage Structs
 */
class Submit_Return_Line_Split_DataType extends AbstractStructBase
{
    /**
     * The Quantity_for_Distribution_Line
     * Meta information extracted from the WSDL
     * - documentation: The quantity being returned for this split.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Quantity_for_Distribution_Line;
    /**
     * The Currency_Amount_for_Distribution_Line
     * Meta information extracted from the WSDL
     * - documentation: The amount being returned for this split. If quantity is entered than this value must match the unit cost * quantity.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - totalDigits: 18
     * @var float
     */
    public $Currency_Amount_for_Distribution_Line;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the split line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Line_Split_Allocated_From_Reference
     * Meta information extracted from the WSDL
     * - documentation: The purchase order line split this split refers to.
     * @var \StructType\Business_Document_Line_SplitObjectType
     */
    public $Line_Split_Allocated_From_Reference;
    /**
     * Constructor method for Submit_Return_Line_Split_DataType
     * @uses Submit_Return_Line_Split_DataType::setQuantity_for_Distribution_Line()
     * @uses Submit_Return_Line_Split_DataType::setCurrency_Amount_for_Distribution_Line()
     * @uses Submit_Return_Line_Split_DataType::setMemo()
     * @uses Submit_Return_Line_Split_DataType::setLine_Split_Allocated_From_Reference()
     * @param float $quantity_for_Distribution_Line
     * @param float $currency_Amount_for_Distribution_Line
     * @param string $memo
     * @param \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocated_From_Reference
     */
    public function __construct($quantity_for_Distribution_Line = null, $currency_Amount_for_Distribution_Line = null, $memo = null, \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocated_From_Reference = null)
    {
        $this
            ->setQuantity_for_Distribution_Line($quantity_for_Distribution_Line)
            ->setCurrency_Amount_for_Distribution_Line($currency_Amount_for_Distribution_Line)
            ->setMemo($memo)
            ->setLine_Split_Allocated_From_Reference($line_Split_Allocated_From_Reference);
    }
    /**
     * Get Quantity_for_Distribution_Line value
     * @return float|null
     */
    public function getQuantity_for_Distribution_Line()
    {
        return $this->Quantity_for_Distribution_Line;
    }
    /**
     * Set Quantity_for_Distribution_Line value
     * @param float $quantity_for_Distribution_Line
     * @return \StructType\Submit_Return_Line_Split_DataType
     */
    public function setQuantity_for_Distribution_Line($quantity_for_Distribution_Line = null)
    {
        // validation for constraint: float
        if (!is_null($quantity_for_Distribution_Line) && !(is_float($quantity_for_Distribution_Line) || is_numeric($quantity_for_Distribution_Line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity_for_Distribution_Line, true), gettype($quantity_for_Distribution_Line)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($quantity_for_Distribution_Line) && mb_strlen(mb_substr($quantity_for_Distribution_Line, false !== mb_strpos($quantity_for_Distribution_Line, '.') ? mb_strpos($quantity_for_Distribution_Line, '.') + 1 : mb_strlen($quantity_for_Distribution_Line))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($quantity_for_Distribution_Line, true), mb_strlen(mb_substr($quantity_for_Distribution_Line, mb_strpos($quantity_for_Distribution_Line, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($quantity_for_Distribution_Line) && mb_strlen(preg_replace('/(\D)/', '', $quantity_for_Distribution_Line)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($quantity_for_Distribution_Line, true), mb_strlen(preg_replace('/(\D)/', '', $quantity_for_Distribution_Line))), __LINE__);
        }
        $this->Quantity_for_Distribution_Line = $quantity_for_Distribution_Line;
        return $this;
    }
    /**
     * Get Currency_Amount_for_Distribution_Line value
     * @return float|null
     */
    public function getCurrency_Amount_for_Distribution_Line()
    {
        return $this->Currency_Amount_for_Distribution_Line;
    }
    /**
     * Set Currency_Amount_for_Distribution_Line value
     * @param float $currency_Amount_for_Distribution_Line
     * @return \StructType\Submit_Return_Line_Split_DataType
     */
    public function setCurrency_Amount_for_Distribution_Line($currency_Amount_for_Distribution_Line = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Amount_for_Distribution_Line) && !(is_float($currency_Amount_for_Distribution_Line) || is_numeric($currency_Amount_for_Distribution_Line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Amount_for_Distribution_Line, true), gettype($currency_Amount_for_Distribution_Line)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($currency_Amount_for_Distribution_Line) && mb_strlen(mb_substr($currency_Amount_for_Distribution_Line, false !== mb_strpos($currency_Amount_for_Distribution_Line, '.') ? mb_strpos($currency_Amount_for_Distribution_Line, '.') + 1 : mb_strlen($currency_Amount_for_Distribution_Line))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($currency_Amount_for_Distribution_Line, true), mb_strlen(mb_substr($currency_Amount_for_Distribution_Line, mb_strpos($currency_Amount_for_Distribution_Line, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($currency_Amount_for_Distribution_Line) && mb_strlen(preg_replace('/(\D)/', '', $currency_Amount_for_Distribution_Line)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($currency_Amount_for_Distribution_Line, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Amount_for_Distribution_Line))), __LINE__);
        }
        $this->Currency_Amount_for_Distribution_Line = $currency_Amount_for_Distribution_Line;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Submit_Return_Line_Split_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Line_Split_Allocated_From_Reference value
     * @return \StructType\Business_Document_Line_SplitObjectType|null
     */
    public function getLine_Split_Allocated_From_Reference()
    {
        return $this->Line_Split_Allocated_From_Reference;
    }
    /**
     * Set Line_Split_Allocated_From_Reference value
     * @param \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocated_From_Reference
     * @return \StructType\Submit_Return_Line_Split_DataType
     */
    public function setLine_Split_Allocated_From_Reference(\StructType\Business_Document_Line_SplitObjectType $line_Split_Allocated_From_Reference = null)
    {
        $this->Line_Split_Allocated_From_Reference = $line_Split_Allocated_From_Reference;
        return $this;
    }
}
