<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Resource_Plan_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project Abstract or Project Hierarchy for Project Resource Plan.
 * @subpackage Structs
 */
class Submit_Resource_Plan_RequestType extends AbstractStructBase
{
    /**
     * The Resource_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Resource Plan Reference
     * - minOccurs: 0
     * @var \StructType\Project_Resource_PlanObjectType
     */
    public $Resource_Plan_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Resource_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing resource plan detail data. If this element is not included, removal of the plan detail is assumed and the plan detail will be removed from the project, where valid to do so.
     * - minOccurs: 0
     * @var \StructType\Resource_Plan_DataType
     */
    public $Resource_Plan_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Resource_Plan_RequestType
     * @uses Submit_Resource_Plan_RequestType::setResource_Plan_Reference()
     * @uses Submit_Resource_Plan_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Resource_Plan_RequestType::setResource_Plan_Data()
     * @uses Submit_Resource_Plan_RequestType::setAdd_Only()
     * @uses Submit_Resource_Plan_RequestType::setVersion()
     * @param \StructType\Project_Resource_PlanObjectType $resource_Plan_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Resource_Plan_DataType $resource_Plan_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Project_Resource_PlanObjectType $resource_Plan_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Resource_Plan_DataType $resource_Plan_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setResource_Plan_Reference($resource_Plan_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setResource_Plan_Data($resource_Plan_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Resource_Plan_Reference value
     * @return \StructType\Project_Resource_PlanObjectType|null
     */
    public function getResource_Plan_Reference()
    {
        return $this->Resource_Plan_Reference;
    }
    /**
     * Set Resource_Plan_Reference value
     * @param \StructType\Project_Resource_PlanObjectType $resource_Plan_Reference
     * @return \StructType\Submit_Resource_Plan_RequestType
     */
    public function setResource_Plan_Reference(\StructType\Project_Resource_PlanObjectType $resource_Plan_Reference = null)
    {
        $this->Resource_Plan_Reference = $resource_Plan_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Resource_Plan_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Resource_Plan_Data value
     * @return \StructType\Resource_Plan_DataType|null
     */
    public function getResource_Plan_Data()
    {
        return $this->Resource_Plan_Data;
    }
    /**
     * Set Resource_Plan_Data value
     * @param \StructType\Resource_Plan_DataType $resource_Plan_Data
     * @return \StructType\Submit_Resource_Plan_RequestType
     */
    public function setResource_Plan_Data(\StructType\Resource_Plan_DataType $resource_Plan_Data = null)
    {
        $this->Resource_Plan_Data = $resource_Plan_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Resource_Plan_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Resource_Plan_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
