<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Receipt_Adjustment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Receipt Adjustment reference for update, and all Receipt Adjustment data.
 * @subpackage Structs
 */
class Submit_Receipt_Adjustment_RequestType extends AbstractStructBase
{
    /**
     * The Receipt_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Receipt Adjustment
     * - minOccurs: 0
     * @var \StructType\Receipt_AdjustmentObjectType
     */
    public $Receipt_Adjustment_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType[]
     */
    public $Business_Process_Parameters;
    /**
     * The Receipt_Adjustment_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Receipt Adjustment data
     * - minOccurs: 0
     * @var \StructType\Receipt_Adjustment_DataType
     */
    public $Receipt_Adjustment_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update. If an existing instance is found and this flag is set there will be an error.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Receipt_Adjustment_RequestType
     * @uses Submit_Receipt_Adjustment_RequestType::setReceipt_Adjustment_Reference()
     * @uses Submit_Receipt_Adjustment_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Receipt_Adjustment_RequestType::setReceipt_Adjustment_Data()
     * @uses Submit_Receipt_Adjustment_RequestType::setAdd_Only()
     * @uses Submit_Receipt_Adjustment_RequestType::setVersion()
     * @param \StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @param \StructType\Receipt_Adjustment_DataType $receipt_Adjustment_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference = null, array $business_Process_Parameters = array(), \StructType\Receipt_Adjustment_DataType $receipt_Adjustment_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setReceipt_Adjustment_Reference($receipt_Adjustment_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setReceipt_Adjustment_Data($receipt_Adjustment_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Receipt_Adjustment_Reference value
     * @return \StructType\Receipt_AdjustmentObjectType|null
     */
    public function getReceipt_Adjustment_Reference()
    {
        return $this->Receipt_Adjustment_Reference;
    }
    /**
     * Set Receipt_Adjustment_Reference value
     * @param \StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference
     * @return \StructType\Submit_Receipt_Adjustment_RequestType
     */
    public function setReceipt_Adjustment_Reference(\StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference = null)
    {
        $this->Receipt_Adjustment_Reference = $receipt_Adjustment_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType[]|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Process_Parameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Process_Parameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Receipt_Adjustment_RequestTypeBusiness_Process_ParametersItem) {
            // validation for constraint: itemType
            if (!$submit_Receipt_Adjustment_RequestTypeBusiness_Process_ParametersItem instanceof \StructType\Financials_Business_Process_ParametersType) {
                $invalidValues[] = is_object($submit_Receipt_Adjustment_RequestTypeBusiness_Process_ParametersItem) ? get_class($submit_Receipt_Adjustment_RequestTypeBusiness_Process_ParametersItem) : sprintf('%s(%s)', gettype($submit_Receipt_Adjustment_RequestTypeBusiness_Process_ParametersItem), var_export($submit_Receipt_Adjustment_RequestTypeBusiness_Process_ParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @return \StructType\Submit_Receipt_Adjustment_RequestType
     */
    public function setBusiness_Process_Parameters(array $business_Process_Parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Process_ParametersArrayErrorMessage = self::validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters($business_Process_Parameters))) {
            throw new \InvalidArgumentException($business_Process_ParametersArrayErrorMessage, __LINE__);
        }
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Add item to Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType $item
     * @return \StructType\Submit_Receipt_Adjustment_RequestType
     */
    public function addToBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Business_Process_ParametersType) {
            throw new \InvalidArgumentException(sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Process_Parameters[] = $item;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Data value
     * @return \StructType\Receipt_Adjustment_DataType|null
     */
    public function getReceipt_Adjustment_Data()
    {
        return $this->Receipt_Adjustment_Data;
    }
    /**
     * Set Receipt_Adjustment_Data value
     * @param \StructType\Receipt_Adjustment_DataType $receipt_Adjustment_Data
     * @return \StructType\Submit_Receipt_Adjustment_RequestType
     */
    public function setReceipt_Adjustment_Data(\StructType\Receipt_Adjustment_DataType $receipt_Adjustment_Data = null)
    {
        $this->Receipt_Adjustment_Data = $receipt_Adjustment_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Receipt_Adjustment_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Receipt_Adjustment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
