<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Purchase_Order_Change_Order_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Purchase Order Change Order reference for update and all Purchase Order Change Order Item
 * @subpackage Structs
 */
class Submit_Purchase_Order_Change_Order_RequestType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Change_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Change Order for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Change_OrderObjectType
     */
    public $Purchase_Order_Change_Order_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Purchase_Order_Change_Order_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Change_Order_WWS_DataType[]
     */
    public $Purchase_Order_Change_Order_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update to the change order
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Purchase_Order_Change_Order_RequestType
     * @uses Submit_Purchase_Order_Change_Order_RequestType::setPurchase_Order_Change_Order_Reference()
     * @uses Submit_Purchase_Order_Change_Order_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Purchase_Order_Change_Order_RequestType::setPurchase_Order_Change_Order_Data()
     * @uses Submit_Purchase_Order_Change_Order_RequestType::setAdd_Only()
     * @uses Submit_Purchase_Order_Change_Order_RequestType::setVersion()
     * @param \StructType\Purchase_Order_Change_OrderObjectType $purchase_Order_Change_Order_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Purchase_Order_Change_Order_WWS_DataType[] $purchase_Order_Change_Order_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Purchase_Order_Change_OrderObjectType $purchase_Order_Change_Order_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, array $purchase_Order_Change_Order_Data = array(), $add_Only = null, $version = null)
    {
        $this
            ->setPurchase_Order_Change_Order_Reference($purchase_Order_Change_Order_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setPurchase_Order_Change_Order_Data($purchase_Order_Change_Order_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Change_Order_Reference value
     * @return \StructType\Purchase_Order_Change_OrderObjectType|null
     */
    public function getPurchase_Order_Change_Order_Reference()
    {
        return $this->Purchase_Order_Change_Order_Reference;
    }
    /**
     * Set Purchase_Order_Change_Order_Reference value
     * @param \StructType\Purchase_Order_Change_OrderObjectType $purchase_Order_Change_Order_Reference
     * @return \StructType\Submit_Purchase_Order_Change_Order_RequestType
     */
    public function setPurchase_Order_Change_Order_Reference(\StructType\Purchase_Order_Change_OrderObjectType $purchase_Order_Change_Order_Reference = null)
    {
        $this->Purchase_Order_Change_Order_Reference = $purchase_Order_Change_Order_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Purchase_Order_Change_Order_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Purchase_Order_Change_Order_Data value
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType[]|null
     */
    public function getPurchase_Order_Change_Order_Data()
    {
        return $this->Purchase_Order_Change_Order_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Change_Order_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Change_Order_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Change_Order_DataForArrayConstraintsFromSetPurchase_Order_Change_Order_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Purchase_Order_Change_Order_RequestTypePurchase_Order_Change_Order_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Purchase_Order_Change_Order_RequestTypePurchase_Order_Change_Order_DataItem instanceof \StructType\Purchase_Order_Change_Order_WWS_DataType) {
                $invalidValues[] = is_object($submit_Purchase_Order_Change_Order_RequestTypePurchase_Order_Change_Order_DataItem) ? get_class($submit_Purchase_Order_Change_Order_RequestTypePurchase_Order_Change_Order_DataItem) : sprintf('%s(%s)', gettype($submit_Purchase_Order_Change_Order_RequestTypePurchase_Order_Change_Order_DataItem), var_export($submit_Purchase_Order_Change_Order_RequestTypePurchase_Order_Change_Order_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Change_Order_Data property can only contain items of type \StructType\Purchase_Order_Change_Order_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Change_Order_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Change_Order_WWS_DataType[] $purchase_Order_Change_Order_Data
     * @return \StructType\Submit_Purchase_Order_Change_Order_RequestType
     */
    public function setPurchase_Order_Change_Order_Data(array $purchase_Order_Change_Order_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Change_Order_DataArrayErrorMessage = self::validatePurchase_Order_Change_Order_DataForArrayConstraintsFromSetPurchase_Order_Change_Order_Data($purchase_Order_Change_Order_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Change_Order_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Change_Order_Data = $purchase_Order_Change_Order_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Change_Order_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Change_Order_WWS_DataType $item
     * @return \StructType\Submit_Purchase_Order_Change_Order_RequestType
     */
    public function addToPurchase_Order_Change_Order_Data(\StructType\Purchase_Order_Change_Order_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Change_Order_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Change_Order_Data property can only contain items of type \StructType\Purchase_Order_Change_Order_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Change_Order_Data[] = $item;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Purchase_Order_Change_Order_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Purchase_Order_Change_Order_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
