<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Project_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request Element for Submitting a Project via a Web Service
 * @subpackage Structs
 */
class Submit_Project_RequestType extends AbstractStructBase
{
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Project_AbstractObjectType
     */
    public $Project_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Project_Data
     * Meta information extracted from the WSDL
     * - documentation: The project data element containing project details for V22 and up.
     * @var \StructType\Project_DataType
     */
    public $Project_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Project_RequestType
     * @uses Submit_Project_RequestType::setProject_Reference()
     * @uses Submit_Project_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Project_RequestType::setProject_Data()
     * @uses Submit_Project_RequestType::setAdd_Only()
     * @uses Submit_Project_RequestType::setVersion()
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Project_DataType $project_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Project_AbstractObjectType $project_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Project_DataType $project_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProject_Reference($project_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setProject_Data($project_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Project_Reference value
     * @return \StructType\Project_AbstractObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @return \StructType\Submit_Project_RequestType
     */
    public function setProject_Reference(\StructType\Project_AbstractObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Project_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Project_Data value
     * @return \StructType\Project_DataType|null
     */
    public function getProject_Data()
    {
        return $this->Project_Data;
    }
    /**
     * Set Project_Data value
     * @param \StructType\Project_DataType $project_Data
     * @return \StructType\Submit_Project_RequestType
     */
    public function setProject_Data(\StructType\Project_DataType $project_Data = null)
    {
        $this->Project_Data = $project_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Project_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Project_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
