<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Expense_Report_for_Non-Worker_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: You don't have the permissions required to submit expense reports for payee type. | The Project Transaction Adjustment Event is in progress for this expense report. You can't cancel or update the expense report until the event
 * completes. | You can't change this expense report because the ledger period for the transaction isn't open. | Expense Payee for Expense Report must be a non-worker | The Web Service is set to Add Only; documents cannot be resubmitted. | Element
 * containing Expense Report reference for update and all Expense Report data items
 * @subpackage Structs
 */
class Submit_Expense_Report_for_Non_Worker_RequestType extends AbstractStructBase
{
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Report for update only purposes
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType
     */
    public $Expense_Report_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Expense_Report_Data
     * Meta information extracted from the WSDL
     * - documentation: Submit Expense Report for Non-Worker Request
     * @var \StructType\Expense_Report_WWS_DataType
     */
    public $Expense_Report_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Expense_Report_for_Non-Worker_RequestType
     * @uses Submit_Expense_Report_for_Non_Worker_RequestType::setExpense_Report_Reference()
     * @uses Submit_Expense_Report_for_Non_Worker_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Expense_Report_for_Non_Worker_RequestType::setExpense_Report_Data()
     * @uses Submit_Expense_Report_for_Non_Worker_RequestType::setAdd_Only()
     * @uses Submit_Expense_Report_for_Non_Worker_RequestType::setVersion()
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Expense_Report_WWS_DataType $expense_Report_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Expense_ReportObjectType $expense_Report_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Expense_Report_WWS_DataType $expense_Report_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExpense_Report_Reference($expense_Report_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setExpense_Report_Data($expense_Report_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * Set Expense_Report_Reference value
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @return \StructType\Submit_Expense_Report_for_Non_Worker_RequestType
     */
    public function setExpense_Report_Reference(\StructType\Expense_ReportObjectType $expense_Report_Reference = null)
    {
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Expense_Report_for_Non_Worker_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Expense_Report_Data value
     * @return \StructType\Expense_Report_WWS_DataType|null
     */
    public function getExpense_Report_Data()
    {
        return $this->Expense_Report_Data;
    }
    /**
     * Set Expense_Report_Data value
     * @param \StructType\Expense_Report_WWS_DataType $expense_Report_Data
     * @return \StructType\Submit_Expense_Report_for_Non_Worker_RequestType
     */
    public function setExpense_Report_Data(\StructType\Expense_Report_WWS_DataType $expense_Report_Data = null)
    {
        $this->Expense_Report_Data = $expense_Report_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Expense_Report_for_Non_Worker_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Expense_Report_for_Non_Worker_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
