<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Catalog_Load_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Put Catalog Load Response Data
 * @subpackage Structs
 */
class Submit_Catalog_Load_ResponseType extends AbstractStructBase
{
    /**
     * The Catalog_Load_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Load Reference
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Catalog_Load_Reference;
    /**
     * The Exceptions_Response_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Application_Instance_Related_Exceptions_DataType[]
     */
    public $Exceptions_Response_Data;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Catalog Effective Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Supplier_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Catalog for Catalog Load
     * - minOccurs: 0
     * @var \StructType\Abstract_Procurement_CatalogObjectType
     */
    public $Supplier_Catalog_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Catalog_Load_Item_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Catalog Load Item data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Load_Item_DataType[]
     */
    public $Catalog_Load_Item_Reference_Data;
    /**
     * The Catalog_Load_Data_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Catalog Load Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Load_DataType[]
     */
    public $Catalog_Load_Data_Reference_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Catalog_Load_ResponseType
     * @uses Submit_Catalog_Load_ResponseType::setCatalog_Load_Reference()
     * @uses Submit_Catalog_Load_ResponseType::setExceptions_Response_Data()
     * @uses Submit_Catalog_Load_ResponseType::setEffective_Date()
     * @uses Submit_Catalog_Load_ResponseType::setSupplier_Catalog_Reference()
     * @uses Submit_Catalog_Load_ResponseType::setSupplier_Contract_Reference()
     * @uses Submit_Catalog_Load_ResponseType::setCatalog_Load_Item_Reference_Data()
     * @uses Submit_Catalog_Load_ResponseType::setCatalog_Load_Data_Reference_Data()
     * @uses Submit_Catalog_Load_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $catalog_Load_Reference
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $exceptions_Response_Data
     * @param string $effective_Date
     * @param \StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Catalog_Load_Item_DataType[] $catalog_Load_Item_Reference_Data
     * @param \StructType\Catalog_Load_DataType[] $catalog_Load_Data_Reference_Data
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $catalog_Load_Reference = null, array $exceptions_Response_Data = array(), $effective_Date = null, \StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $catalog_Load_Item_Reference_Data = array(), array $catalog_Load_Data_Reference_Data = array(), $version = null)
    {
        $this
            ->setCatalog_Load_Reference($catalog_Load_Reference)
            ->setExceptions_Response_Data($exceptions_Response_Data)
            ->setEffective_Date($effective_Date)
            ->setSupplier_Catalog_Reference($supplier_Catalog_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setCatalog_Load_Item_Reference_Data($catalog_Load_Item_Reference_Data)
            ->setCatalog_Load_Data_Reference_Data($catalog_Load_Data_Reference_Data)
            ->setVersion($version);
    }
    /**
     * Get Catalog_Load_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getCatalog_Load_Reference()
    {
        return $this->Catalog_Load_Reference;
    }
    /**
     * Set Catalog_Load_Reference value
     * @param \StructType\Unique_IdentifierObjectType $catalog_Load_Reference
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setCatalog_Load_Reference(\StructType\Unique_IdentifierObjectType $catalog_Load_Reference = null)
    {
        $this->Catalog_Load_Reference = $catalog_Load_Reference;
        return $this;
    }
    /**
     * Get Exceptions_Response_Data value
     * @return \StructType\Application_Instance_Related_Exceptions_DataType[]|null
     */
    public function getExceptions_Response_Data()
    {
        return $this->Exceptions_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExceptions_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExceptions_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExceptions_Response_DataForArrayConstraintsFromSetExceptions_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Catalog_Load_ResponseTypeExceptions_Response_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Catalog_Load_ResponseTypeExceptions_Response_DataItem instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
                $invalidValues[] = is_object($submit_Catalog_Load_ResponseTypeExceptions_Response_DataItem) ? get_class($submit_Catalog_Load_ResponseTypeExceptions_Response_DataItem) : sprintf('%s(%s)', gettype($submit_Catalog_Load_ResponseTypeExceptions_Response_DataItem), var_export($submit_Catalog_Load_ResponseTypeExceptions_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Exceptions_Response_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Exceptions_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $exceptions_Response_Data
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setExceptions_Response_Data(array $exceptions_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($exceptions_Response_DataArrayErrorMessage = self::validateExceptions_Response_DataForArrayConstraintsFromSetExceptions_Response_Data($exceptions_Response_Data))) {
            throw new \InvalidArgumentException($exceptions_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->Exceptions_Response_Data = $exceptions_Response_Data;
        return $this;
    }
    /**
     * Add item to Exceptions_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType $item
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function addToExceptions_Response_Data(\StructType\Application_Instance_Related_Exceptions_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
            throw new \InvalidArgumentException(sprintf('The Exceptions_Response_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Exceptions_Response_Data[] = $item;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Supplier_Catalog_Reference value
     * @return \StructType\Abstract_Procurement_CatalogObjectType|null
     */
    public function getSupplier_Catalog_Reference()
    {
        return $this->Supplier_Catalog_Reference;
    }
    /**
     * Set Supplier_Catalog_Reference value
     * @param \StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setSupplier_Catalog_Reference(\StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference = null)
    {
        $this->Supplier_Catalog_Reference = $supplier_Catalog_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Catalog_Load_Item_Reference_Data value
     * @return \StructType\Catalog_Load_Item_DataType[]|null
     */
    public function getCatalog_Load_Item_Reference_Data()
    {
        return $this->Catalog_Load_Item_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Load_Item_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Load_Item_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Load_Item_Reference_DataForArrayConstraintsFromSetCatalog_Load_Item_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Catalog_Load_ResponseTypeCatalog_Load_Item_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Catalog_Load_ResponseTypeCatalog_Load_Item_Reference_DataItem instanceof \StructType\Catalog_Load_Item_DataType) {
                $invalidValues[] = is_object($submit_Catalog_Load_ResponseTypeCatalog_Load_Item_Reference_DataItem) ? get_class($submit_Catalog_Load_ResponseTypeCatalog_Load_Item_Reference_DataItem) : sprintf('%s(%s)', gettype($submit_Catalog_Load_ResponseTypeCatalog_Load_Item_Reference_DataItem), var_export($submit_Catalog_Load_ResponseTypeCatalog_Load_Item_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Load_Item_Reference_Data property can only contain items of type \StructType\Catalog_Load_Item_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Load_Item_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Item_DataType[] $catalog_Load_Item_Reference_Data
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setCatalog_Load_Item_Reference_Data(array $catalog_Load_Item_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Load_Item_Reference_DataArrayErrorMessage = self::validateCatalog_Load_Item_Reference_DataForArrayConstraintsFromSetCatalog_Load_Item_Reference_Data($catalog_Load_Item_Reference_Data))) {
            throw new \InvalidArgumentException($catalog_Load_Item_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Load_Item_Reference_Data = $catalog_Load_Item_Reference_Data;
        return $this;
    }
    /**
     * Add item to Catalog_Load_Item_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Item_DataType $item
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function addToCatalog_Load_Item_Reference_Data(\StructType\Catalog_Load_Item_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Load_Item_DataType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Load_Item_Reference_Data property can only contain items of type \StructType\Catalog_Load_Item_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Load_Item_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Catalog_Load_Data_Reference_Data value
     * @return \StructType\Catalog_Load_DataType[]|null
     */
    public function getCatalog_Load_Data_Reference_Data()
    {
        return $this->Catalog_Load_Data_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Load_Data_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Load_Data_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Load_Data_Reference_DataForArrayConstraintsFromSetCatalog_Load_Data_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Catalog_Load_ResponseTypeCatalog_Load_Data_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Catalog_Load_ResponseTypeCatalog_Load_Data_Reference_DataItem instanceof \StructType\Catalog_Load_DataType) {
                $invalidValues[] = is_object($submit_Catalog_Load_ResponseTypeCatalog_Load_Data_Reference_DataItem) ? get_class($submit_Catalog_Load_ResponseTypeCatalog_Load_Data_Reference_DataItem) : sprintf('%s(%s)', gettype($submit_Catalog_Load_ResponseTypeCatalog_Load_Data_Reference_DataItem), var_export($submit_Catalog_Load_ResponseTypeCatalog_Load_Data_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Load_Data_Reference_Data property can only contain items of type \StructType\Catalog_Load_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Load_Data_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_DataType[] $catalog_Load_Data_Reference_Data
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setCatalog_Load_Data_Reference_Data(array $catalog_Load_Data_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Load_Data_Reference_DataArrayErrorMessage = self::validateCatalog_Load_Data_Reference_DataForArrayConstraintsFromSetCatalog_Load_Data_Reference_Data($catalog_Load_Data_Reference_Data))) {
            throw new \InvalidArgumentException($catalog_Load_Data_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Load_Data_Reference_Data = $catalog_Load_Data_Reference_Data;
        return $this;
    }
    /**
     * Add item to Catalog_Load_Data_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_DataType $item
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function addToCatalog_Load_Data_Reference_Data(\StructType\Catalog_Load_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Load_DataType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Load_Data_Reference_Data property can only contain items of type \StructType\Catalog_Load_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Load_Data_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Catalog_Load_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
