<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Category_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Spend Category request criteria
 * @subpackage Structs
 */
class Spend_Category_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Updated_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Spend (Resource) Category Change From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_From_Date;
    /**
     * The Updated_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Spend (Resource) Category Change To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_To_Date;
    /**
     * Constructor method for Spend_Category_Request_CriteriaType
     * @uses Spend_Category_Request_CriteriaType::setUpdated_From_Date()
     * @uses Spend_Category_Request_CriteriaType::setUpdated_To_Date()
     * @param string $updated_From_Date
     * @param string $updated_To_Date
     */
    public function __construct($updated_From_Date = null, $updated_To_Date = null)
    {
        $this
            ->setUpdated_From_Date($updated_From_Date)
            ->setUpdated_To_Date($updated_To_Date);
    }
    /**
     * Get Updated_From_Date value
     * @return string|null
     */
    public function getUpdated_From_Date()
    {
        return $this->Updated_From_Date;
    }
    /**
     * Set Updated_From_Date value
     * @param string $updated_From_Date
     * @return \StructType\Spend_Category_Request_CriteriaType
     */
    public function setUpdated_From_Date($updated_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_From_Date) && !is_string($updated_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_From_Date, true), gettype($updated_From_Date)), __LINE__);
        }
        $this->Updated_From_Date = $updated_From_Date;
        return $this;
    }
    /**
     * Get Updated_To_Date value
     * @return string|null
     */
    public function getUpdated_To_Date()
    {
        return $this->Updated_To_Date;
    }
    /**
     * Set Updated_To_Date value
     * @param string $updated_To_Date
     * @return \StructType\Spend_Category_Request_CriteriaType
     */
    public function setUpdated_To_Date($updated_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_To_Date) && !is_string($updated_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_To_Date, true), gettype($updated_To_Date)), __LINE__);
        }
        $this->Updated_To_Date = $updated_To_Date;
        return $this;
    }
}
