<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Revenue_Center_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Revenue Center Data
 * @subpackage Structs
 */
class Revenue_Center_DataType extends AbstractStructBase
{
    /**
     * The Revenue_Center_ID
     * Meta information extracted from the WSDL
     * - documentation: Revenue Center Reference ID. Used to uniquely identify a Revenue Center Instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Revenue_Center_ID;
    /**
     * The Revenue_Center_Code
     * Meta information extracted from the WSDL
     * - documentation: Revenue Center Code
     * - maxOccurs: 1
     * @var string
     */
    public $Revenue_Center_Code;
    /**
     * The Revenue_Center_Active
     * Meta information extracted from the WSDL
     * - documentation: Revenue Center Active. This flag indicates whether the revenue center is active or inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Revenue_Center_Active;
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Organization for Revenue Center
     * @var \StructType\OrganizationObjectType
     */
    public $Organization_Reference;
    /**
     * The Revenue_Center_Description
     * Meta information extracted from the WSDL
     * - documentation: The Description for this Revenue Center
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Revenue_Center_Description;
    /**
     * Constructor method for Revenue_Center_DataType
     * @uses Revenue_Center_DataType::setRevenue_Center_ID()
     * @uses Revenue_Center_DataType::setRevenue_Center_Code()
     * @uses Revenue_Center_DataType::setRevenue_Center_Active()
     * @uses Revenue_Center_DataType::setOrganization_Reference()
     * @uses Revenue_Center_DataType::setRevenue_Center_Description()
     * @param string $revenue_Center_ID
     * @param string $revenue_Center_Code
     * @param bool $revenue_Center_Active
     * @param \StructType\OrganizationObjectType $organization_Reference
     * @param string $revenue_Center_Description
     */
    public function __construct($revenue_Center_ID = null, $revenue_Center_Code = null, $revenue_Center_Active = null, \StructType\OrganizationObjectType $organization_Reference = null, $revenue_Center_Description = null)
    {
        $this
            ->setRevenue_Center_ID($revenue_Center_ID)
            ->setRevenue_Center_Code($revenue_Center_Code)
            ->setRevenue_Center_Active($revenue_Center_Active)
            ->setOrganization_Reference($organization_Reference)
            ->setRevenue_Center_Description($revenue_Center_Description);
    }
    /**
     * Get Revenue_Center_ID value
     * @return string|null
     */
    public function getRevenue_Center_ID()
    {
        return $this->Revenue_Center_ID;
    }
    /**
     * Set Revenue_Center_ID value
     * @param string $revenue_Center_ID
     * @return \StructType\Revenue_Center_DataType
     */
    public function setRevenue_Center_ID($revenue_Center_ID = null)
    {
        // validation for constraint: string
        if (!is_null($revenue_Center_ID) && !is_string($revenue_Center_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenue_Center_ID, true), gettype($revenue_Center_ID)), __LINE__);
        }
        $this->Revenue_Center_ID = $revenue_Center_ID;
        return $this;
    }
    /**
     * Get Revenue_Center_Code value
     * @return string|null
     */
    public function getRevenue_Center_Code()
    {
        return $this->Revenue_Center_Code;
    }
    /**
     * Set Revenue_Center_Code value
     * @param string $revenue_Center_Code
     * @return \StructType\Revenue_Center_DataType
     */
    public function setRevenue_Center_Code($revenue_Center_Code = null)
    {
        // validation for constraint: string
        if (!is_null($revenue_Center_Code) && !is_string($revenue_Center_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenue_Center_Code, true), gettype($revenue_Center_Code)), __LINE__);
        }
        $this->Revenue_Center_Code = $revenue_Center_Code;
        return $this;
    }
    /**
     * Get Revenue_Center_Active value
     * @return bool|null
     */
    public function getRevenue_Center_Active()
    {
        return $this->Revenue_Center_Active;
    }
    /**
     * Set Revenue_Center_Active value
     * @param bool $revenue_Center_Active
     * @return \StructType\Revenue_Center_DataType
     */
    public function setRevenue_Center_Active($revenue_Center_Active = null)
    {
        // validation for constraint: boolean
        if (!is_null($revenue_Center_Active) && !is_bool($revenue_Center_Active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($revenue_Center_Active, true), gettype($revenue_Center_Active)), __LINE__);
        }
        $this->Revenue_Center_Active = $revenue_Center_Active;
        return $this;
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * Set Organization_Reference value
     * @param \StructType\OrganizationObjectType $organization_Reference
     * @return \StructType\Revenue_Center_DataType
     */
    public function setOrganization_Reference(\StructType\OrganizationObjectType $organization_Reference = null)
    {
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Get Revenue_Center_Description value
     * @return string|null
     */
    public function getRevenue_Center_Description()
    {
        return $this->Revenue_Center_Description;
    }
    /**
     * Set Revenue_Center_Description value
     * @param string $revenue_Center_Description
     * @return \StructType\Revenue_Center_DataType
     */
    public function setRevenue_Center_Description($revenue_Center_Description = null)
    {
        // validation for constraint: string
        if (!is_null($revenue_Center_Description) && !is_string($revenue_Center_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenue_Center_Description, true), gettype($revenue_Center_Description)), __LINE__);
        }
        $this->Revenue_Center_Description = $revenue_Center_Description;
        return $this;
    }
}
