<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restricted_Purchase_Item_List_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that includes Restricted Purchase Item List Response Data
 * @subpackage Structs
 */
class Restricted_Purchase_Item_List_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_List
     * Meta information extracted from the WSDL
     * - documentation: Restricted Purchase Item List.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restricted_Purchase_Item_List_Outbound_DataType[]
     */
    public $Purchase_Item_List;
    /**
     * Constructor method for Restricted_Purchase_Item_List_Response_DataType
     * @uses Restricted_Purchase_Item_List_Response_DataType::setPurchase_Item_List()
     * @param \StructType\Restricted_Purchase_Item_List_Outbound_DataType[] $purchase_Item_List
     */
    public function __construct(array $purchase_Item_List = array())
    {
        $this
            ->setPurchase_Item_List($purchase_Item_List);
    }
    /**
     * Get Purchase_Item_List value
     * @return \StructType\Restricted_Purchase_Item_List_Outbound_DataType[]|null
     */
    public function getPurchase_Item_List()
    {
        return $this->Purchase_Item_List;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_List method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_List method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_ListForArrayConstraintsFromSetPurchase_Item_List(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restricted_Purchase_Item_List_Response_DataTypePurchase_Item_ListItem) {
            // validation for constraint: itemType
            if (!$restricted_Purchase_Item_List_Response_DataTypePurchase_Item_ListItem instanceof \StructType\Restricted_Purchase_Item_List_Outbound_DataType) {
                $invalidValues[] = is_object($restricted_Purchase_Item_List_Response_DataTypePurchase_Item_ListItem) ? get_class($restricted_Purchase_Item_List_Response_DataTypePurchase_Item_ListItem) : sprintf('%s(%s)', gettype($restricted_Purchase_Item_List_Response_DataTypePurchase_Item_ListItem), var_export($restricted_Purchase_Item_List_Response_DataTypePurchase_Item_ListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_List property can only contain items of type \StructType\Restricted_Purchase_Item_List_Outbound_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_List value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_List_Outbound_DataType[] $purchase_Item_List
     * @return \StructType\Restricted_Purchase_Item_List_Response_DataType
     */
    public function setPurchase_Item_List(array $purchase_Item_List = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_ListArrayErrorMessage = self::validatePurchase_Item_ListForArrayConstraintsFromSetPurchase_Item_List($purchase_Item_List))) {
            throw new \InvalidArgumentException($purchase_Item_ListArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_List = $purchase_Item_List;
        return $this;
    }
    /**
     * Add item to Purchase_Item_List value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_List_Outbound_DataType $item
     * @return \StructType\Restricted_Purchase_Item_List_Response_DataType
     */
    public function addToPurchase_Item_List(\StructType\Restricted_Purchase_Item_List_Outbound_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restricted_Purchase_Item_List_Outbound_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_List property can only contain items of type \StructType\Restricted_Purchase_Item_List_Outbound_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_List[] = $item;
        return $this;
    }
}
