<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Pool_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Pool Data Element used in Resource Pool Web Service Task.
 * @subpackage Structs
 */
class Resource_Pool_DataType extends AbstractStructBase
{
    /**
     * The Resource_Pool_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Pool_ID;
    /**
     * The Resource_Pool_Name
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Name is Required.
     * - maxOccurs: 1
     * @var string
     */
    public $Resource_Pool_Name;
    /**
     * The Include_Resource_Pool_ID_in_Name
     * Meta information extracted from the WSDL
     * - documentation: Boolean value indicating if the Resource Pool ID will be included in the display of Resource Pool Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Resource_Pool_ID_in_Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates the resource pool is inactive. A resource pool may also be inactivated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactivated_By_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Hierarchies that this current Resource Pool is inactivated by.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_HierarchyObjectType[]
     */
    public $Inactivated_By_Reference;
    /**
     * The Resource_Pool_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Hierarchy that this Resource Pool belongs to.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_HierarchyObjectType[]
     */
    public $Resource_Pool_Hierarchy_Reference;
    /**
     * The Workers_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workers included in this Resource Pool.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Workers_Reference;
    /**
     * Constructor method for Resource_Pool_DataType
     * @uses Resource_Pool_DataType::setResource_Pool_ID()
     * @uses Resource_Pool_DataType::setResource_Pool_Name()
     * @uses Resource_Pool_DataType::setInclude_Resource_Pool_ID_in_Name()
     * @uses Resource_Pool_DataType::setInactive()
     * @uses Resource_Pool_DataType::setDescription()
     * @uses Resource_Pool_DataType::setInactivated_By_Reference()
     * @uses Resource_Pool_DataType::setResource_Pool_Hierarchy_Reference()
     * @uses Resource_Pool_DataType::setWorkers_Reference()
     * @param string $resource_Pool_ID
     * @param string $resource_Pool_Name
     * @param bool $include_Resource_Pool_ID_in_Name
     * @param bool $inactive
     * @param string $description
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $inactivated_By_Reference
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $resource_Pool_Hierarchy_Reference
     * @param \StructType\WorkerObjectType[] $workers_Reference
     */
    public function __construct($resource_Pool_ID = null, $resource_Pool_Name = null, $include_Resource_Pool_ID_in_Name = null, $inactive = null, $description = null, array $inactivated_By_Reference = array(), array $resource_Pool_Hierarchy_Reference = array(), array $workers_Reference = array())
    {
        $this
            ->setResource_Pool_ID($resource_Pool_ID)
            ->setResource_Pool_Name($resource_Pool_Name)
            ->setInclude_Resource_Pool_ID_in_Name($include_Resource_Pool_ID_in_Name)
            ->setInactive($inactive)
            ->setDescription($description)
            ->setInactivated_By_Reference($inactivated_By_Reference)
            ->setResource_Pool_Hierarchy_Reference($resource_Pool_Hierarchy_Reference)
            ->setWorkers_Reference($workers_Reference);
    }
    /**
     * Get Resource_Pool_ID value
     * @return string|null
     */
    public function getResource_Pool_ID()
    {
        return $this->Resource_Pool_ID;
    }
    /**
     * Set Resource_Pool_ID value
     * @param string $resource_Pool_ID
     * @return \StructType\Resource_Pool_DataType
     */
    public function setResource_Pool_ID($resource_Pool_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Pool_ID) && !is_string($resource_Pool_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Pool_ID, true), gettype($resource_Pool_ID)), __LINE__);
        }
        $this->Resource_Pool_ID = $resource_Pool_ID;
        return $this;
    }
    /**
     * Get Resource_Pool_Name value
     * @return string|null
     */
    public function getResource_Pool_Name()
    {
        return $this->Resource_Pool_Name;
    }
    /**
     * Set Resource_Pool_Name value
     * @param string $resource_Pool_Name
     * @return \StructType\Resource_Pool_DataType
     */
    public function setResource_Pool_Name($resource_Pool_Name = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Pool_Name) && !is_string($resource_Pool_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Pool_Name, true), gettype($resource_Pool_Name)), __LINE__);
        }
        $this->Resource_Pool_Name = $resource_Pool_Name;
        return $this;
    }
    /**
     * Get Include_Resource_Pool_ID_in_Name value
     * @return bool|null
     */
    public function getInclude_Resource_Pool_ID_in_Name()
    {
        return $this->Include_Resource_Pool_ID_in_Name;
    }
    /**
     * Set Include_Resource_Pool_ID_in_Name value
     * @param bool $include_Resource_Pool_ID_in_Name
     * @return \StructType\Resource_Pool_DataType
     */
    public function setInclude_Resource_Pool_ID_in_Name($include_Resource_Pool_ID_in_Name = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Resource_Pool_ID_in_Name) && !is_bool($include_Resource_Pool_ID_in_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Resource_Pool_ID_in_Name, true), gettype($include_Resource_Pool_ID_in_Name)), __LINE__);
        }
        $this->Include_Resource_Pool_ID_in_Name = $include_Resource_Pool_ID_in_Name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Resource_Pool_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Resource_Pool_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactivated_By_Reference value
     * @return \StructType\Resource_Pool_HierarchyObjectType[]|null
     */
    public function getInactivated_By_Reference()
    {
        return $this->Inactivated_By_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInactivated_By_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInactivated_By_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInactivated_By_ReferenceForArrayConstraintsFromSetInactivated_By_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Pool_DataTypeInactivated_By_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Pool_DataTypeInactivated_By_ReferenceItem instanceof \StructType\Resource_Pool_HierarchyObjectType) {
                $invalidValues[] = is_object($resource_Pool_DataTypeInactivated_By_ReferenceItem) ? get_class($resource_Pool_DataTypeInactivated_By_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Pool_DataTypeInactivated_By_ReferenceItem), var_export($resource_Pool_DataTypeInactivated_By_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Inactivated_By_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Inactivated_By_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $inactivated_By_Reference
     * @return \StructType\Resource_Pool_DataType
     */
    public function setInactivated_By_Reference(array $inactivated_By_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($inactivated_By_ReferenceArrayErrorMessage = self::validateInactivated_By_ReferenceForArrayConstraintsFromSetInactivated_By_Reference($inactivated_By_Reference))) {
            throw new \InvalidArgumentException($inactivated_By_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Inactivated_By_Reference = $inactivated_By_Reference;
        return $this;
    }
    /**
     * Add item to Inactivated_By_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType $item
     * @return \StructType\Resource_Pool_DataType
     */
    public function addToInactivated_By_Reference(\StructType\Resource_Pool_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Pool_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Inactivated_By_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Inactivated_By_Reference[] = $item;
        return $this;
    }
    /**
     * Get Resource_Pool_Hierarchy_Reference value
     * @return \StructType\Resource_Pool_HierarchyObjectType[]|null
     */
    public function getResource_Pool_Hierarchy_Reference()
    {
        return $this->Resource_Pool_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Pool_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Pool_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Pool_Hierarchy_ReferenceForArrayConstraintsFromSetResource_Pool_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Pool_DataTypeResource_Pool_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Pool_DataTypeResource_Pool_Hierarchy_ReferenceItem instanceof \StructType\Resource_Pool_HierarchyObjectType) {
                $invalidValues[] = is_object($resource_Pool_DataTypeResource_Pool_Hierarchy_ReferenceItem) ? get_class($resource_Pool_DataTypeResource_Pool_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Pool_DataTypeResource_Pool_Hierarchy_ReferenceItem), var_export($resource_Pool_DataTypeResource_Pool_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Pool_Hierarchy_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Pool_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $resource_Pool_Hierarchy_Reference
     * @return \StructType\Resource_Pool_DataType
     */
    public function setResource_Pool_Hierarchy_Reference(array $resource_Pool_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Pool_Hierarchy_ReferenceArrayErrorMessage = self::validateResource_Pool_Hierarchy_ReferenceForArrayConstraintsFromSetResource_Pool_Hierarchy_Reference($resource_Pool_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($resource_Pool_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Resource_Pool_Hierarchy_Reference = $resource_Pool_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Resource_Pool_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType $item
     * @return \StructType\Resource_Pool_DataType
     */
    public function addToResource_Pool_Hierarchy_Reference(\StructType\Resource_Pool_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Pool_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Pool_Hierarchy_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Pool_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Workers_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getWorkers_Reference()
    {
        return $this->Workers_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorkers_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorkers_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorkers_ReferenceForArrayConstraintsFromSetWorkers_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Pool_DataTypeWorkers_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Pool_DataTypeWorkers_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($resource_Pool_DataTypeWorkers_ReferenceItem) ? get_class($resource_Pool_DataTypeWorkers_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Pool_DataTypeWorkers_ReferenceItem), var_export($resource_Pool_DataTypeWorkers_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $workers_Reference
     * @return \StructType\Resource_Pool_DataType
     */
    public function setWorkers_Reference(array $workers_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($workers_ReferenceArrayErrorMessage = self::validateWorkers_ReferenceForArrayConstraintsFromSetWorkers_Reference($workers_Reference))) {
            throw new \InvalidArgumentException($workers_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Workers_Reference = $workers_Reference;
        return $this;
    }
    /**
     * Add item to Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Resource_Pool_DataType
     */
    public function addToWorkers_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Workers_Reference[] = $item;
        return $this;
    }
}
