<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_Template_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the request criteria to identify the specific instance(s) of a resource plan template.
 * @subpackage Structs
 */
class Resource_Plan_Template_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Resource_Plan_Template_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the resource plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Plan_Template_Name;
    /**
     * Constructor method for Resource_Plan_Template_Request_CriteriaType
     * @uses Resource_Plan_Template_Request_CriteriaType::setResource_Plan_Template_Name()
     * @param string $resource_Plan_Template_Name
     */
    public function __construct($resource_Plan_Template_Name = null)
    {
        $this
            ->setResource_Plan_Template_Name($resource_Plan_Template_Name);
    }
    /**
     * Get Resource_Plan_Template_Name value
     * @return string|null
     */
    public function getResource_Plan_Template_Name()
    {
        return $this->Resource_Plan_Template_Name;
    }
    /**
     * Set Resource_Plan_Template_Name value
     * @param string $resource_Plan_Template_Name
     * @return \StructType\Resource_Plan_Template_Request_CriteriaType
     */
    public function setResource_Plan_Template_Name($resource_Plan_Template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Plan_Template_Name) && !is_string($resource_Plan_Template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Plan_Template_Name, true), gettype($resource_Plan_Template_Name)), __LINE__);
        }
        $this->Resource_Plan_Template_Name = $resource_Plan_Template_Name;
        return $this;
    }
}
