<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Resource Plan Data Element
 * @subpackage Structs
 */
class Resource_Plan_DataType extends AbstractStructBase
{
    /**
     * The Resource_Plan_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Plan_ID;
    /**
     * The Resource_Plan_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing resource plan template.
     * - minOccurs: 0
     * @var \StructType\Project_Resource_Plan_TemplateObjectType
     */
    public $Resource_Plan_Template_Reference;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Reference for which Project Resource Plan is to be created.
     * - choice: Project_Reference | Project_Hierarchy_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Project_AbstractObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Hierarchy Reference for which Project Resource Plan is to be created
     * - choice: Project_Reference | Project_Hierarchy_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType
     */
    public $Project_Hierarchy_Reference;
    /**
     * The Project_Resource_Plan_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan Detail Data Sub Element
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Resource_Plan_Detail_WWS_DataType[]
     */
    public $Project_Resource_Plan_Detail_Data;
    /**
     * Constructor method for Resource_Plan_DataType
     * @uses Resource_Plan_DataType::setResource_Plan_ID()
     * @uses Resource_Plan_DataType::setResource_Plan_Template_Reference()
     * @uses Resource_Plan_DataType::setProject_Reference()
     * @uses Resource_Plan_DataType::setProject_Hierarchy_Reference()
     * @uses Resource_Plan_DataType::setProject_Resource_Plan_Detail_Data()
     * @param string $resource_Plan_ID
     * @param \StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @param \StructType\Project_Resource_Plan_Detail_WWS_DataType[] $project_Resource_Plan_Detail_Data
     */
    public function __construct($resource_Plan_ID = null, \StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference = null, \StructType\Project_AbstractObjectType $project_Reference = null, \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null, array $project_Resource_Plan_Detail_Data = array())
    {
        $this
            ->setResource_Plan_ID($resource_Plan_ID)
            ->setResource_Plan_Template_Reference($resource_Plan_Template_Reference)
            ->setProject_Reference($project_Reference)
            ->setProject_Hierarchy_Reference($project_Hierarchy_Reference)
            ->setProject_Resource_Plan_Detail_Data($project_Resource_Plan_Detail_Data);
    }
    /**
     * Get Resource_Plan_ID value
     * @return string|null
     */
    public function getResource_Plan_ID()
    {
        return $this->Resource_Plan_ID;
    }
    /**
     * Set Resource_Plan_ID value
     * @param string $resource_Plan_ID
     * @return \StructType\Resource_Plan_DataType
     */
    public function setResource_Plan_ID($resource_Plan_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Plan_ID) && !is_string($resource_Plan_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Plan_ID, true), gettype($resource_Plan_ID)), __LINE__);
        }
        $this->Resource_Plan_ID = $resource_Plan_ID;
        return $this;
    }
    /**
     * Get Resource_Plan_Template_Reference value
     * @return \StructType\Project_Resource_Plan_TemplateObjectType|null
     */
    public function getResource_Plan_Template_Reference()
    {
        return $this->Resource_Plan_Template_Reference;
    }
    /**
     * Set Resource_Plan_Template_Reference value
     * @param \StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference
     * @return \StructType\Resource_Plan_DataType
     */
    public function setResource_Plan_Template_Reference(\StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference = null)
    {
        $this->Resource_Plan_Template_Reference = $resource_Plan_Template_Reference;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\Project_AbstractObjectType|null
     */
    public function getProject_Reference()
    {
        return isset($this->Project_Reference) ? $this->Project_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProject_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProject_ReferenceForChoiceConstraintsFromSetProject_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Project_Hierarchy_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Project_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Project_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Project_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @return \StructType\Resource_Plan_DataType
     */
    public function setProject_Reference(\StructType\Project_AbstractObjectType $project_Reference = null)
    {
        // validation for constraint: choice(Project_Reference, Project_Hierarchy_Reference)
        if ('' !== ($project_ReferenceChoiceErrorMessage = self::validateProject_ReferenceForChoiceConstraintsFromSetProject_Reference($project_Reference))) {
            throw new \InvalidArgumentException($project_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($project_Reference) || (is_array($project_Reference) && empty($project_Reference))) {
            unset($this->Project_Reference);
        } else {
            $this->Project_Reference = $project_Reference;
        }
        return $this;
    }
    /**
     * Get Project_Hierarchy_Reference value
     * @return \StructType\Project_HierarchyObjectType|null
     */
    public function getProject_Hierarchy_Reference()
    {
        return isset($this->Project_Hierarchy_Reference) ? $this->Project_Hierarchy_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProject_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Hierarchy_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProject_Hierarchy_ReferenceForChoiceConstraintsFromSetProject_Hierarchy_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Project_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Project_Hierarchy_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Project_Hierarchy_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Project_Hierarchy_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @return \StructType\Resource_Plan_DataType
     */
    public function setProject_Hierarchy_Reference(\StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null)
    {
        // validation for constraint: choice(Project_Reference, Project_Hierarchy_Reference)
        if ('' !== ($project_Hierarchy_ReferenceChoiceErrorMessage = self::validateProject_Hierarchy_ReferenceForChoiceConstraintsFromSetProject_Hierarchy_Reference($project_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($project_Hierarchy_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($project_Hierarchy_Reference) || (is_array($project_Hierarchy_Reference) && empty($project_Hierarchy_Reference))) {
            unset($this->Project_Hierarchy_Reference);
        } else {
            $this->Project_Hierarchy_Reference = $project_Hierarchy_Reference;
        }
        return $this;
    }
    /**
     * Get Project_Resource_Plan_Detail_Data value
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType[]|null
     */
    public function getProject_Resource_Plan_Detail_Data()
    {
        return $this->Project_Resource_Plan_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Resource_Plan_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Resource_Plan_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Resource_Plan_Detail_DataForArrayConstraintsFromSetProject_Resource_Plan_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_DataTypeProject_Resource_Plan_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_DataTypeProject_Resource_Plan_Detail_DataItem instanceof \StructType\Project_Resource_Plan_Detail_WWS_DataType) {
                $invalidValues[] = is_object($resource_Plan_DataTypeProject_Resource_Plan_Detail_DataItem) ? get_class($resource_Plan_DataTypeProject_Resource_Plan_Detail_DataItem) : sprintf('%s(%s)', gettype($resource_Plan_DataTypeProject_Resource_Plan_Detail_DataItem), var_export($resource_Plan_DataTypeProject_Resource_Plan_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Resource_Plan_Detail_Data property can only contain items of type \StructType\Project_Resource_Plan_Detail_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Resource_Plan_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Resource_Plan_Detail_WWS_DataType[] $project_Resource_Plan_Detail_Data
     * @return \StructType\Resource_Plan_DataType
     */
    public function setProject_Resource_Plan_Detail_Data(array $project_Resource_Plan_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Resource_Plan_Detail_DataArrayErrorMessage = self::validateProject_Resource_Plan_Detail_DataForArrayConstraintsFromSetProject_Resource_Plan_Detail_Data($project_Resource_Plan_Detail_Data))) {
            throw new \InvalidArgumentException($project_Resource_Plan_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Resource_Plan_Detail_Data = $project_Resource_Plan_Detail_Data;
        return $this;
    }
    /**
     * Add item to Project_Resource_Plan_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Resource_Plan_Detail_WWS_DataType $item
     * @return \StructType\Resource_Plan_DataType
     */
    public function addToProject_Resource_Plan_Detail_Data(\StructType\Project_Resource_Plan_Detail_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Resource_Plan_Detail_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Resource_Plan_Detail_Data property can only contain items of type \StructType\Project_Resource_Plan_Detail_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Resource_Plan_Detail_Data[] = $item;
        return $this;
    }
}
