<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Forecast_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Resource Forecasts Response Element
 * @subpackage Structs
 */
class Resource_Forecast_Response_DataType extends AbstractStructBase
{
    /**
     * The Resource_Forecast_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Element
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ForecastType[]
     */
    public $Resource_Forecast_Data;
    /**
     * Constructor method for Resource_Forecast_Response_DataType
     * @uses Resource_Forecast_Response_DataType::setResource_Forecast_Data()
     * @param \StructType\Resource_ForecastType[] $resource_Forecast_Data
     */
    public function __construct(array $resource_Forecast_Data = array())
    {
        $this
            ->setResource_Forecast_Data($resource_Forecast_Data);
    }
    /**
     * Get Resource_Forecast_Data value
     * @return \StructType\Resource_ForecastType[]|null
     */
    public function getResource_Forecast_Data()
    {
        return $this->Resource_Forecast_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Forecast_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Forecast_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Forecast_DataForArrayConstraintsFromSetResource_Forecast_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Forecast_Response_DataTypeResource_Forecast_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Forecast_Response_DataTypeResource_Forecast_DataItem instanceof \StructType\Resource_ForecastType) {
                $invalidValues[] = is_object($resource_Forecast_Response_DataTypeResource_Forecast_DataItem) ? get_class($resource_Forecast_Response_DataTypeResource_Forecast_DataItem) : sprintf('%s(%s)', gettype($resource_Forecast_Response_DataTypeResource_Forecast_DataItem), var_export($resource_Forecast_Response_DataTypeResource_Forecast_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Forecast_Data property can only contain items of type \StructType\Resource_ForecastType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Forecast_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ForecastType[] $resource_Forecast_Data
     * @return \StructType\Resource_Forecast_Response_DataType
     */
    public function setResource_Forecast_Data(array $resource_Forecast_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Forecast_DataArrayErrorMessage = self::validateResource_Forecast_DataForArrayConstraintsFromSetResource_Forecast_Data($resource_Forecast_Data))) {
            throw new \InvalidArgumentException($resource_Forecast_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Forecast_Data = $resource_Forecast_Data;
        return $this;
    }
    /**
     * Add item to Resource_Forecast_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ForecastType $item
     * @return \StructType\Resource_Forecast_Response_DataType
     */
    public function addToResource_Forecast_Data(\StructType\Resource_ForecastType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ForecastType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Forecast_Data property can only contain items of type \StructType\Resource_ForecastType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Forecast_Data[] = $item;
        return $this;
    }
}
